	PROGRAM IRS_ROOT
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IRS_ROOT
C
C       PURPOSE -- Root module for ATTC Image Runtime Statistics
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  The root module conteins the main command processing loop.
C	  Module uses VMS CLI$ facility to process commands options.
C	  For command definitions, see IRS_TABLE.CLD definition.
C
C       NOTES --
C
C	  IRS_TABLE must be linked with the IRS image, we do NOT want
C	  depend on system's DCL tables modifications.
C
C       NOTES --
C	  
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  09/26/88,,,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
	IMPLICIT NONE
        Character*132	FORSTR                            ! Foreign CMD string
	Integer		FORLEN
	Character*255	IMAGESTR
	Integer		IMAGELEN
	Character*255	OUTSTR
	Integer		OUTLEN
	Character*255	QUEUESTR
	Integer		QUEUELEN
	Character*32	PIDSTR
	Integer		PIDLEN
	Integer		PID
	Integer		INT
 	INTEGER		IS,I

C
	INTEGER	 CLI$DCL_PARSE,CLI$DISPATCH,CLI$PRESENT,CLI$GET_VALUE
	EXTERNAL LIB$GET_INPUT,IRS_TABLE,LIB$GET_FOREIGN
	EXTERNAL JPI$_OWNER
	INTEGER  LIB$GETJPI
C                        
C  START OF EXECUTABLE CODE --
C
C
        CALL    LIB$GET_FOREIGN(FORSTR,,FORLEN)         ! Get command line
  	IS=CLI$DCL_PARSE('IRS_WATCH '//FORSTR(:FORLEN)	! Add our VERB
     $		,IRS_TABLE               		! (see IRS_TABLE.CLD)
     $		,%val(0)				! LIB$GET_INPUT
     $		,%val(0)			        ! LIB$GET_FOREIGN
     $	        ,'IRS>')                                 
	IF(.not.IS) STOP '%IRS-I-NOCMD, Unable to retrieve arguments'
C	
C	Since all qualifiers are present by default, I do not check status
C
        IS=CLI$GET_VALUE('IMAGE',IMAGESTR,IMAGELEN)
        IS=CLI$GET_VALUE('OUTPUT',OUTSTR,OUTLEN)
        IS=CLI$GET_VALUE('QUEUE',QUEUESTR,QUEUELEN)
        IS=CLI$GET_VALUE('IDENT',PIDSTR,PIDLEN)
	read(PIDSTR(:PIDLEN),*)PID
        IS=CLI$GET_VALUE('INTERVAL',PIDSTR,PIDLEN)
	read(PIDSTR(:PIDLEN),*)INT
C
D	write(*,*)'Image = ',IMAGESTR(:IMAGELEN)
D	write(*,*)'Outfl = ',OUTSTR(:OUTLEN)
D	write(*,*)'Queue = ',QUEUESTR(:QUEUELEN)
D	write(*,*)'Ident = ',PID
D	write(*,*)'Intrv = ',INT
C
C       If no process ID has been provided, try to use the parent's one
C
        if (PID.eq.0) then
           IS = LIB$GETJPI(%ref(%loc(JPI$_OWNER)),,,PID,,I)
           if (.not.IS) Call SYS$EXIT(%val(IS))
        end if
        If (PID.eq.0) STOP '%IRS-F-NOPID, No process identifier'
 
 100	Call IRS_CORE(PID,INT,IMAGESTR(:IMAGELEN),OUTSTR(:OUTLEN))
	If (QUEUESTR(:QUEUELEN).ne.'NONE') 		! default is NO print
     $	  Call LIB$SPAWN('$ PRINT '//OUTSTR(:OUTLEN)//
     $	                    '/QUEUE='//QUEUESTR(:QUEUELEN) )
	If (CLI$PRESENT('CONTINUOUS')) GoTo 100		! Continouous monitor
 	Call sys$exit(%val(1))				! Exit with status
	END	                                                       
