$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ if f$mode() .eqs. "NETWORK" then EXIT		! Max speed FOR NETWORK
$ GoTo START					! Skip comments
$ !
$ ! GRP300start.COM - GROUP STARTUP procedure for GROUP 300 (G_3)
$ ! Facility: ATTC LAVC System START-UP
$ ! Purpose:  Provide cluster-wide GROUP startup (may be executed on any
$ !	      node used by particular group)
$ !
$ ! Notes:    Procedure may is used in stand-alone boot as well
$ !	      N E V E R  load node-specific commands here
$ !	      For detailes refer to design spec 144-14725-000 ATTC LAVC
$ !
$ ! History:  
$ ! 04/17/87,,,MXB, Built form older SYS_300_GRP.COM
$ ! 04/08/87,,,MXB, Template setup
$ !
$START:
$ set NoOn				! Make sure we don't blow out
$!
$! Point system logicals AT_G3DIR and AT$G3USER to in-house installation
$ if .not.f$priv("sysnam") then goto Group_Logicals
$!
$ device = "CHOPIN$DUA0:" ! Current in-house installation
$!
$ dsen = "define/system/exec/nolog"
$ definition = device + "[G3DIR.]"
$ dsen/translation=concealed at_g3dir 'definition
$ definition = device + "[G3USER]"
$ dsen at$g3user 'definition
$!
$Group_Logicals:
$ dgn = "define/group/nolog"
$ dgnt = "define/group/nolog/translation=concealed"
$!
$! Defines Group logicals for UIC = [300,*]  (G_3 group)
$!
$! INCLUDE LOGICALS
$!
$! "VAXC$INCLUDE" takes care of <fspec> references
$! Compiler searches these directories ONLY
$! We should try to enforce this as being only for VAX system includes.
$ dgn	vaxc$include	sys$library
$!
$! "C$INCLUDE" takes care of "fspec" references
$! Compiler searches these directories, then directory containing source
$ dgn	c$include	g3incs,g3err,wksdsk:[swprot.lm.image]
$!
$! LINK LIBRARIES
$ dgn	lnk$library	sys$library:vaxcrtl.olb
$!
$! MAIN LOCATION
$! Our source/development tree is rooted at G_3DSK
$! Our runtime tree is rooted at G_3USR
$! Both of these need to be defined at the system level
$!
$! Source Structure
$ dgnt	g3ctrl		g_3dsk:[g_3ctrl.]
$!
$! Developer Directories
$ dev0 = "G_3MGR MGR"
$ dev1 = "Don Harrington"
$ dev2 = "Doug Young"
$ dev3 = "George Watson"
$ dev4 = "Matt Jackson"
$ dev5 = "Paul Montgomery"
$ dev6 = "Robert Seal"
$ numdev = 7
$ i=0
$Loop:
$! for (i=0;i<numdev;i++)
$!   {
$    firstname = f$ele(0," ",dev'i)
$    lastname = f$ele(1," ",dev'i)
$    username = f$ext(0,3,firstname) + f$ext(0,3,lastname)
$    username = f$edit(username,"upcase")
$    rootname = firstname + "$ROOT"
$    dgn 'firstname "G_3USR:[''username']"
$    dgnt 'rootname "G_3USR:[''username'.]"
$    i = i + 1
$    if i .lt. numdev then goto Loop
$!   }
$!
$! Source Directories
$ dgn	g3source	g3ctrl:[src.primitives.g3source]
$ dgn	g3rtl		g3ctrl:[src.primitives.g3rtl]
$ dgn	g3mar		g3ctrl:[src.primitives.g3mar]
$ dgn	g3incs		g3ctrl:[src.primitives.g3incs]
$ dgn	g3util		g3ctrl:[src.primitives.g3util]
$!
$! Object Directories
$ dgn	g3srcobj	g3ctrl:[obj.primitives.g3source.obj]
$ dgn	g3srcobjdb	g3ctrl:[obj.primitives.g3source.objdb]
$ dgn	g3rtlobj	g3ctrl:[obj.primitives.g3rtl.obj]
$ dgn	g3rtlobjdb	g3ctrl:[obj.primitives.g3rtl.objdb]
$ dgn	g3utilobj	g3ctrl:[obj.primitives.g3util.obj]
$ dgn	g3utilobjdb	g3ctrl:[obj.primitives.g3util.objdb]
$ dgn	g3err		g3ctrl:[obj.primitives.g3err]
$!
$ dgn	g3image		g3ctrl:[image]
$ dgn	g3libs		g3ctrl:[lib]
$ dgn	g3lis		g3ctrl:[lis]
$ dgn	g3prog		g3ctrl:[image.g3util]
$ dgn	g3test		g3ctrl:[g3test]
$ dgn	g3notes		g3ctrl:[g3notes]
$ dgn	g3examp		g3ctrl:[g3examp]
$ dgn	g3garbage	g3ctrl:[g3garbage]
$ dgn	g3ftp		g3ctrl:[g3ftp]
$ dgn	g3rno		g3ctrl:[rno]
$ dgn	g3doc		g3ctrl:[rno]
$ dgn	g3install	g3ctrl:[vmsinstal]
$!g3com is one dir in develop side 
$ dgn	g3com		g3proc
$ dgn	g3proc		g3ctrl:[proc]
$ dgn	g3bld		g3ctrl:[g3bld]
$ dgn	g3info		g3ctrl:[proc.info]
$!
$! INDIVIDUAL FILES - Source/Text
$ dgn	g3sysnames	g3util:g3sys.txt
$ dgn	g3prompts	g3util:g3prompts.txt
$ dgn	g3promhdr	g3incs:g3prompts.h
$ dgn	g3errors	g3util:g3errors.msg
$!
$! XLISP Logicals
$ dgnt	xlisp$root	g_3dsk:[tricad.xlisp.]
$ dgn	xlsrc		xlisp$root:[src]
$ dgn	xllis		xlisp$root:[lis]
$ dgn	xlobj		xlisp$root:[obj]
$ dgn	xlexe		xlisp$root:[exe]
$ dgn	xlcom		xlisp$root:[com]
$!
$FINISH:
$ Verify = f$verify(verify)
$ Exit
