$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ !
$ ! LAVCBATCH.COM - Start up batch queues
$ ! Facility: ATTC LAVC System START-UP
$ ! Purpose:  Start both LOCAL and remote BATCH queues
$ ! Notes:    Procedure may be used in stand-alone boot as well
$ !	      For each node, we create node$MGR and node$BATCH queues.
$ !	      Those are GENERIC, served by generic SYS$BATCH queue.
$ !	      Other, named queues, are function-specific
$ !	      For details refer to design spec 144-14725-000 ATTC LAVC
$ ! History:  
$ ! 10/27/87, -db, included a node-specific INI dropped last edit session
$ ! 10/10/87, -db, made Harpo & Chico's batch ques generic
$ ! 08/03/87, -db, increased batch que WSdef quotas, made generic print ques
$ ! 08/03/87, -db, removed EDISON 20000-block batch que qaulifier line
$ ! 05/07/87,,,MXB, node$BATCH made NoEnab_Generic for VAX-2000 nodes
$ ! 04/07/87,,,MXB, node$BATCH temporr. made NoEnab_Generic for GPX nodes
$ ! 02/03/87,,,MXB, Initial setup
$ !
$ !========================================================================
$PHASE_1:
$ set NoOn
$ ! Check presence of QUEUE MANAGER file, if missing, exit
$ if f$search("sys$system:JOBCTL.EXE") .eqs. "" then $ Goto Finish
$ !
$ DS:=Define/system/nolog			! to define logical names
$ cpu := 'f$getsyi("CPU")			! Cpu type
$ node:= 'f$getsyi("SCSNODE")			! This node name (no trailing blanks)
$ if node .eqs. "" then node = "SALONE"		! - it MUST always exist
$ INI="INIT/Que/Batch"				! Simplify writing
$ !
$ !==================Make sure QUE MANAGER is UP ==========================
$ Ass/user nl: sys$error			! Prevent ugly messages
$ Ass/user nl: sys$output			! if allready running
$ START/QUE/MANAGER JBCSYSQUE			! Start using logical name
$ !						! (assigned by LAVCLOGNM.COM)
$ !
$ !=================== STANDARD LOCAL NODE QUEUES =========================
$ ! Each node except for VAX-2000 always has at least one queue:
$ !  node$BATCH         - for common, nonspecific batch usage, cluster-wide
$ !			  *** Temporrarily, node$batch are NO Generic
$ ! 
$ pro="/Prot=(O:D,G:RW,W:W)"		! standard batch queue protection
$ gen="/Enable_Generic			! Enabled  generic processing
$ nog="/NoEnable_Generic		! Disabled generic processing
$ qual="/Base_prio=3/Job_Lim=1/WSext=2500"+pro+nog	! *** NO Generic
$ !					! standard batch queue qualifiers
$ !
$ ! 780 (cpu=1) Batch queues are made large & generic
$ !	We need to initialize all execution ques...start only on
$ !	the node the que is running on
$ !
$ startif_chico = "/NOSTART"    ! Set NoSTART assuming we are not on this node
$ startif_harpo = "/NOSTART"	! (thus we can't start que)
$ startif_'node'="/START"	! But set /startif for this particular node
$ !
$ if cpu .eq. 1  then - 
	qual="/Base=4/Job_Limit=4 /WSext=12000"+ pro + gen
$ !
$ if cpu .eq. 1 then -
	INI chico$batch/BATCH /on=chico::'startif_chico' 'qual'
$ if cpu .eq. 1 then -
	INI harpo$batch/BATCH /on=harpo::'startif_harpo' 'qual'
$!
$ start_sym = startif_'node'
$ !
$ INI 'NODE'$BATCH /BATCH /On='node':: 'start_sym' 'qual' ! Workstation queues
$ !
$ !
$ !========================= LAVC WIDE QUEUES =============================
$ !
$ ! Define generic batch queue, it dispatches to any que with ENABLE_GENERIC
$ !
$ if cpu .eq. 1 then -
	INI SYS$BATCH/BATCH/Generic=(CHICO$BATCH,HARPO$BATCH) ! Define GENERIC queue
$ if cpu .ne. 1 then -
	INI SYS$BATCH
$ Ass/user nl: 	sys$error			! Prevent ugly messages
$ Ass/user nl: sys$output			! if allready running
$ START/Que	SYS$BATCH			! Make sure it's running
$ !
$ ! LAVC wide NAMED queues are function-specific. Therefore, we can NOT allow
$ ! them to serve generic requests (Enable_Generic).
$ ! Let JOB manager know about any other queue in the cluster, and start
$ ! the local ones. First we must set couple flags - DCL symbols:
$ !
$ !   QUEUE     where      (start)  qualifiers....
$ !
$ INI CHICOBLD	/Batch/On=CHICO::'startif_chico'/Prot=(G:RW,W:W)/Noenable_Gen -
		/Base_pri=4 /Job_lim=1 /WSdef=2000 /WSext=8000 /WSquo=2000
$ INI HARPOBLD	/Batch/On=HARPO::'startif_harpo'/Prot=(G:RW,W:W)/Noenable_Gen -
		/Base_pri=4 /Job_lim=1 /WSdef=2000 /WSext=8000 /WSquo=2000
$ INI S7KQUE	/Batch/On=CHICO::'startif_chico'/Prot=(G:RW,W:W)/Noenable_Gen -
		/Base_pri=4 /Job_lim=1 /WSdef=2000 /WSext=8000 /WSquo=2000
$ INI S5KQUE	/Batch/On=HARPO::'startif_harpo'/Prot=(G:RW,W:W)/Noenable_Gen -
		/Base_pri=4 /Job_lim=1 /WSdef=2000 /WSext=8000 /WSquo=2000
$ !
$ !===================== LAVC MANAGEMENT QUEUE =============================
$ !
$ !	LAVC management queue is intended to run on the LAVC MASTER node only
$ !
$ dev=f$getdvi(f$search("lavc$data:[LAVCCOM]lavcbatch.com"),"FULLDEVNAM")
$ master=f$element(0,"$",dev)-"_"		! Get the MASTER node name
$ if node .nes. master then Goto Finish
$ Ass/user nl: sys$error			! Prevent ugly messages
$ Ass/user nl: sys$output			! if que does not exist yet
$ STOP/Que   LAVC$MGR  /Next	 		! Stop que to allow Delete 
$ Ass/user nl: sys$error			! Prevent ugly messages
$ Ass/user nl: sys$output			! if que does not exist
$ DELE/Que   LAVC$MGR				! Delete and start que again
$ INI	     LAVC$MGR /Batch/On='node'::/Start-
		      /Base=4/Job=5/Prot=(G:RW,W)/NoEnable_Gen
$ DS SYS$MGR LAVC$MGR				! Create the old logical name
$ !
$Finish:
$ Verify = f$verify(verify)
