$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ !
$ ! LAVCDEVSET.COM - Device SET-UP procedure for LAVC startup
$ ! Facility: ATTC LVAC System START-UP
$ ! Purpose:  Procedure to perform individual peripheral device SET-UP
$ !	      during system startup in safe and controlled way.
$ !	      - skip devices allready allocated (so we can run this repeatedly)
$ !	      - give us a message which device setup failed (if failed)
$ !	      - have the entire device setup a single call (one line)
$ !
$ !	      Call argument P1 has a format:
$ !	      "device:|TERM|term-setup|DEVICE|dev-setup|PROT=W:R|/Dev" ! Comment
$ !	      (number of pairs |facility|qualifiers| is unlimited, any DCL
$ !	       SET command facility may be used here).
$ !
$ ! Notes:    Typically called from NODESPEC.COM to set-up node specific
$ !	      devices.
$ !	      We do not report errors via systaerr symbol to avoid its overflow.
$ ! History:
$ ! 05/05/87,MXB,Initial setup
$ !
$SET_DEVICE:	
$ SET NoOn
$ p1=P1+P2+P3+P4+P5+P6+P7	! Concatenate arguments, if more than one
$ dev=f$element(0,"|",P1)	! Extract device field from argument
$ !
$ if .not. f$getdvi(dev,"EXISTS") then GoTo NO_DEVICE
$ pid=f$getdvi(dev,"PID")	! Check devicess PID to determine allocation
$ if pid .nes. "" .and. pid .nes. f$getjpi("","PID") then GoTo ALLOC_DEVICE
$ n=0
$SET_DEV_LOOP:
$ faci=f$element(n+1,"|",P1)	! Extract facility to SET (TERM,DEV,PROT...)
$ qual=f$element(n+2,"|",P1)	! Extract SET qualifiers
$ if faci .eqs. "" .or. faci .eqs. "|" then GoTo Finish
$ SET 'faci 'dev' 'qual		! SET according to a requirement
$ if .not. $STATUS then write sys$output -
 "%SYSTARTUP-E-SETDV, Errors setting device ''dev' as ''faci' ''qual'"
$ n=n+2
$ GoTo SET_DEV_LOOP
$NO_DEVICE:
$ write sys$output "%SYSTARTUP-W-NODEV, ''dev' does not exist"
$ GoTo Finish
$ALLOC_DEVICE:
$ write sys$output "%SYSTARTUP-W-ALLOC, ''dev' allready allocated"
$ GoTo Finish
$ !
$FINISH:
$ Verify=f$verify(Verify)
