$ Verify = f$verify(f$extract(0,1,"''debug'0"))
$ GoTo PHASE_1
$ !
$ ! LAVCDISKS.COM - ATTC R&D LVAC system startup, mount cluster-wide disks
$ ! Facility: ATTC LVAC System START-UP
$ ! Purpose:  Mount disks in the ATTC LVAC cluster
$ !	      Dismount/Abort disks served by  "node" (P1=DISMOUNT, P2=nodename)
$ !	      Rebuilds disks served by "node"        (P1=REBUILD,  P2=nodename)
$ ! Notes:    For detailes refer to design spec 144-14725-000 ATTC LAVC
$ !	      We assume here that all MSCP disk controllers completed their
$ !	      initialization (no "WAIT" included here)
$ ! Arguments:
$ !	P1	MOUNT(default), DISMOUNT or REBUILD
$ !	P2	nodename - commands applies to the node's disks only
$ !		may be "*"=all, empty=local node's disks
$ !	P3	addtitional options for dismount (/CLUSTER)
$ !	P4,P5	schedule time. If present, and procedure has been started later
$ !		than 2 minutes AFTER sheduled time, no procedure exits. This
$ !		is to prevent mess caused by delayed batch execution of
$ !		dismounts scheduled by LAVCSHUT.COM, or rebuilds.
$ ! History:
$ ! 01/08/88, MXB, Support argument P1 for MOUNT as well, add MNT to REBLD
$ !		   MOUNT default changed to "local only", use REBUILD *
$ ! 10/22/87, MXB, Added argument 4,5 support
$ ! 09/24/87, -db, Added Church, removed Grouch, changed Dnn & Max nodes
$ ! 09/23/87, MXB, Added GRIEG, removed NEUMAN
$ ! 07/03/87, -db, Added Bell
$ ! 07/23/87, -db, Removed Harpo RPO6 drives
$ ! 06/23/87, -db, Added more nodes..put machly back in
$ ! 06/15/77, MXB, Added more nodes, re-numbered (using system groups), cleanup
$ ! 05/29/87,  db, Added VAX 200's, and note about Volume labels.
$ ! 05/13/87, MXB, Added installed images removal, /Cluster only as P3
$ ! 05/08/87, MXB, Added HARPO's disks
$ ! 12/16/86, MXB, Updated, added GROUCHo disks
$ ! 11/05/86, MXB, Initial set-up for test-cluster
$ !
$ ! DEFINE ALL THE LAVC AVAILABLE DISKS BELOW:
$ ! Define unique dnn symbol for each drive. Thre may be undefined dnn-s,
$ ! (procedure will skip those, but it goes from  d1 up to dmax).
$ ! Always check the value "dmax" to be the hignest dnnn defined.
$ ! For any symbol d1-dmax, procedure will attempt to mount/System/Cluster
$ ! the "device" using "label". If the disk does not exist, it will skip
$ ! this device. Mounted volumes wolumes will be modified using
$ ! "qualifiers" (if not empty).
$ !
$ ! To add a "diskless" node, determine sys_id for NODE_SYSID vol label 
$ ! when the node is up.  Do not attempt to rename volume label assigned
$ ! by SATELLITE_CONFIG (appears in multiple locations)
$ ! 
$ ! ========================================================================
$PHASE_1:	
$ SET NOON
$ p4=p4+" "+p5						! Get time from arguments
$ maxtim = f$cvt(P4,"COMPARISON")			! default to "NOW"
$ curtim = f$cvt("-00:02:00","COMPARISON")		! NOW - 2 minutes
$ if curtim .ges. maxtim then $EXIT			! Beyond limit = done
$ node:='f$getsyi("NODENAME")				! Get local node name
$ FAC :="%LAVCDISKS-"					! Our facility name
$ SAY :="write sys$error"				! Shorthands for
$ ERR :="write sys$error"				! messages
$ !
$ !Define all known disks in the cluster
$ !dn    device:     label     set volume qualifiers      node
$ !
$ ! Boot nodes (780's)
$ !
$ d1  = "CHICO$DUA4:|CHICO_SYS |/NoHigh"		! CHICO 11/780
$ d2  = "CHICO$DUA5:|CHICO_DUA5|/NoHigh"		! CHICO 11/780
$ d3  = "CHICO$DUA6:|CHICO_DUA6|/NoHigh"		! CHICO 11/780
$ d4  = "CHICO$DUA7:|CHICO_DUA7|/NoHigh"		! CHICO 11/780
$ d5  = "HARPO$DUA0:|HARPO_SYS |/NoHigh"		! HARPO 11/780
$ d6  = "HARPO$DUA1:|HARPO_DUA1|/NoHigh"		! HARPO 11/780
$ D7  = "BACH$DUA2: |HARPO_DUA2|/NOHIGH"	 	! DUAL-PORTED BACH/HARPO
$!D7  = "HARPO$DUA2:|HARPO_DUA2|/NoHigh"		! HARPO 11/780
$ !
$ d8  = "DVORAK$DUA0:|DVORAK_SYS|/NoHigh"		! DVORAK VS3500
$ d9  = "DVORAK$DUA1:|DVORAK_DUA1|/NoHigh"		! DVORAK VS3500
$ !
$ !	uVAX-II/GPX based systems
$ !
$ d10 = "WAGNER$DUA0:|WAGNER_SYS |/NoHigh"		! WAGNER uVAX GPX
$ d11 = "WAGNER$DUA1:|WAGNER_DUA1|/NoHigh"		! WAGNER uVAX GPX
$ d12 = "WAGNER$DUA2:|WAGNER_DUA2|/NoHigh"		! WAGNER uVAX GPX
$ d13 = "CHOPIN$DUA0:|CHOPIN_SYS |/NoHigh"		! CHOPIN uVAX GPX
$ d14 = "EDISON$DUA0:|EDISON_SYS |/NoHigh"		! EDISON uVAX GPX
$ d15 = "EDISON$DUA1:|EDISON_DUA1|/NoHigh"		! EDISON uVAX GPX
$ d16 = "EDISON$DUB0:|CD_DOC_82211|			! DECW on line DOC kit
$ d17 = "HAYDEN$DUA1:|HAYDEN_DUA1|/NoHigh"		! HAYDEN uVAX GPX
$ d18 = "MOZART$DUA0:|MOZART_SYS |/NoHigh"		! MOZART uVAX GPX
$ d19 = "MOZART$DUA1:|MOZART_DUA1|/NoHigh"		! MOZART uVAX GPX
$ d20 = "MOZART$DUA2:|MOZART_DUA2|/NoHigh"		! MOZART uVAX GPX
$ d21 = "STRAUS$DUA0:|STRAUS_SYS |/NoHigh"		! STRAUS uVAX GPX
$ d22 = "STRAUS$DUA1:|STRAUS_DUA1|/NoHigh"		! STRAUS uVAX GPX
$ d23 = "BACH$DUA3:  |BACH_SYS   |/NoHigh"		! BACH   uVAX GPX
$ d24 = "BACH$DUC0:  |BACH_DUC0  |/Nohigh"		! BACH   uVAX GPX 
$ d25 = "BRAHMS$DUA0:|BRAHMS_SYS |/Nohigh"		! BRAHMS VS 3200
$ d26 = "DVORAK$DUA0:|DVORAK_SYS |/Nohigh"    		! DVORAK VS 3500
$ d27 = "DVORAK$DUA1:|DVORAK_DUA1|/Nohigh"    		! DVORAK VS 3500
$ !
$ !      VAX-STATION 2000 based systems
$ !
$ d31 = "HOPPER$DUA0:|HOPPER_1046|/Nohigh"		! HOOPER uVAX 2000
$ d32 = "HOPPER$DUA1:|HOPPER_DUA1|/Nohigh"		! HOOPER uVAX 2000
$ d33 = "CHURCH$DUA0:|CHURCH_1056|/NoHigh"		! CHURCH VAXStn 2000
$ d34 = "ECKERT$DUA0:|ECKERT_1043|/NoHigh"		! ECKERT VAXStn 2000
$ d35 = "ZEUSS$DUA0: |ZEUSS_1045 |/NoHigh"		! ZEUSS  VAXStn 2000
$ d36 = "MACHLY$DUA0:|MACHLY_1044|/NoHigh"		! MACHLY VAXStn 2000
$ d37 = "KOHAVI$DUA0:|KOHAVI_1050|/NoHigh"		! KOHAVI VAXStn 2000
$ d38 = "SHANON$DUA0:|SHANON_1051|/NoHigh"		! SHANON VAXStn 2000
$ d39 = "MINSKY$DUA0:|MINSKY_1047|/Nohigh"		! MINSKY VAXstn 2000
$ d40 = "LISZT$DUA0: |LISZT_SYS  |/NoHigh"		! LISZT  VAXStn 2000
$ d41 = "RICHTE$DUA0:|RICHTE_1052|/NoHigh"		! RICHTE VAXStn 2000
$ d42 = "WIRTH$DUA0: |WIRTH_1825 |/NoHigh"		! WIRTH  VAXStn 2000
$ d43 = "BABAGE$DUA0:|BABAGE_1054|/NoHigh"		! BABAGE VAXStn 2000
$ d44 = "BELL$DUA0:  |BELL_SYS   |/NoHigh"		! BELL   VAXStn 2000
$ d45 = "TURING$DUA0:|TURING_1826|/NoHigh"		! TURING VAXStn 2000
$ d46 = "NEUMAN$DUA0:|NEUMAN_SYS |/Nohigh"		! NEUMAN VAXStn 2000 C
$ !
$ dmax=46					! Max disk drive defined 
$ ! ========================================================================
$ node = P2						! Explicite node
$ if node .eqs. "" then node:='f$getsyi("NODENAME")	! not given = use local
$ n=0							! Init disk counter
$ if P1 .eqs. "DISMOUNT" then $ GoTo PHASE_3
$ if P1 .eqs. "REBUILD"  then $ GoTo PHASE_4
$ ! ========================================================================
$ ! 
$ !  M O U N T  -  Mount CLUSTERWIDE all disks for local, "*" or "node"
$ !		   (remote disks are mounted /NoRebuild)
$PHASE_2:					
$MOUNT_LOOP:
$ n=n+1							! next disk
$ if f$type(d'n) .nes. "STRING" then GoTo NODISK	! Undefined disk dnnn
$ arg=d'n						! Get disk arguments
$ dsk=f$element(0,"|",arg)				! Parse arguments:
$ lab=f$element(1,"|",arg)				! disk|label|set-qualifiers
$ qua=f$element(2,"|",arg)				!
$ if node .nes. "*" then -				! Not all the disks
  if f$locate(node,dsk) .eq. f$len(dsk) then GoTo NODISK ! check for node
$ !
$ ! Mount the disk, if on-line and NOT mounted on this node
$ if .not. f$getdvi(dsk,"EXISTS") then GoTo NODISK	! Does not exist, skip
$ if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NODISK	! Does not exist, skip
$ if .not. f$getdvi(dsk,"REMOTE_DEVICE") then GoTo LOCDISK
$REMDISK:						! No REBUILD on remote
$ if f$getdv(dsk,"MNT") then GoTo NODISK		! Skip if mounted
$ MOUNT/Sys/NoReb/NoAssi/Cluster 'dsk 'lab
$ if .not. $status then  ERR FAC+"I-MNTERR, Mount problem on ''dsk' label ''lab'"
$ GoTo NODISK
$LOCDISK:						! REBUILD on LOCAL disks
$ MOUNT/System/NOassist/Cluster 'dsk 'lab		! Mount disk cluster-wide
$ if .not. $status then  ERR FAC+"I-MNTERR, Mount problem on ''dsk' lable ''lab'"
$ if f$getdv(dsk,"MNT") then SET volume 'qua 'dsk	! and set it's attributes
$NODISK:
$ if n .lt. dmax then GoTo MOUNT_LOOP			! Loop for the next disk
$ GoTo Finish
$ ! ========================================================================
$ !  
$ !  D I S M O U N T - Dismount mounted disks for local, "*" or "node"
$ !  Note, we can't dismount disk with system files on it (VMS 4.5 hangup)
$ !
$PHASE_3:
$DMOUNT_LOOP:
$ n=n+1							! next disk
$ if f$type(d'n) .nes. "STRING" then GoTo NODMOUNT	! Undefined disk dnnn
$ arg=d'n						! Get disk arguments
$ dsk=f$element(0,"|",arg)				! Parse arguments:
$ if node .nes. "*" then -				! Not all the disks
  if f$locate(node,dsk) .eq. f$len(dsk) then GoTo NODMOUNT ! check for node
$ if .not. f$getdvi(dsk,"EXISTS") then GoTo NODMOUNT
$ if .not. f$getdvi(dsk,"MNT")    then GoTo NODMOUNT
$ if f$getdvi(dsk,"FULLDEVNAM") .eqs. -
     f$getdvi("sys$sysdevice","FULLDEVNAM")  then GoTo NODMOUNT
$ DISMOUNT/ABORT 'dsk' 'p3'				! Forced dismount
$ ERR FAC+"I-DISMNT, ''dsk' dismounted /ABORT ''p3'"	! Tell which disk dismounted
$ ! The folowing checking attempts to fix MOUNTED/DISMOUNT disks:
$ if f$getdvi(dsk,"REFCNT") .gt. 0 then -		! Some channels opened
     @lavc$data:[LAVCMGM]MGMINSTALL REMOVE 'dsk		! so remove all images
$NODMOUNT:
$ if n .lt dmax then GoTo DMOUNT_LOOP			! Loop for the next disk
$ GoTo FINISH
$ ! ========================================================================
$ !  
$ !  R E B U I L D   -  Rebuild mounted disks for local, "*" or "node"
$ !  If the disk is NOT mounted yet, it will be mounted here
$ !
$PHASE_4:
$REBLD_LOOP:
$ n=n+1							! Next disk
$ if f$type(d'n) .nes. "STRING" then GoTo NOREBLD	! Undefined disk dnnn
$ arg=d'n						! Get disk arguments
$ dsk=f$element(0,"|",arg)				! Parse arguments:
$ if node .nes. "*" then -				! Not all the disks
  if f$locate(node,dsk) .eq. f$len(dsk) then GoTo NOREBLD ! check for node
$ if .not. f$getdvi(dsk,"EXISTS") then GoTo NOREBLD	! Does not exist, skip
$ if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NOREBLD	! No access, skip
$ if       f$getdvi(dsk,"MNT")    then GoTo REBLD
$REBLDMNT:						! Mount the disk 
$ lab=f$element(1,"|",arg)				! disk|label|set-qualifiers
$ MOUNT/System/NOassist/Cluster 'dsk 'lab 		! Mount disk cluster-wide
$ if .not. $status then  ERR FAC+"I-MNTERR, Mount problem on ''dsk' lable ''lab'"
$REBLD:
$ SET VOLUME/Rebuild 'dsk' 'P3'				! Rebuild volume caches
$NOREBLD:
$ if n .lt dmax then GoTo REBLD_LOOP			! Loop for the next disk
$FINISH:
$ Verify = f$verify(Verify)
$ EXIT
