$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ set nocontrol=y				! Disable interrupts
$ if f$extract(3,3,f$getjpi("","USERNAME")) .eqs. "MGR" then GoTo GROUP_MANAGER
$ if f$mode() .nes. "NETWORK" then GoTo START	! Max speed FOR NETWORK
$ write sys$output "This is node ''f$getsyi("NODENAME")'" ! What node?
$ EXIT
$ !
$ ! LAVCLOGIN.COM - LAVC WIDE master LOGIN procedure
$ ! Facility: ATTC LAVC System START-UP
$ ! Purpose:  Provide LAVC wide LOGIN control
$ !	      - Check GROUP MANAGER's access rights
$ !	      - Check user access right to NODE
$ !	      - Setup user privileges
$ !	      - Print out messages and notices
$ !	      - Define cluster-wide setup symbols for user logins
$ !
$ ! Notes:    Procedure may is used in stand-alone boot as well
$ !	      N E V E R  load node-specific commands here
$ !	      For detailes refer to design spec 144-14725-000 ATTC LAVC
$ !
$ ! History:  
$ ! 01/07/88,,,MXB, Moved terminal inquiry into right place, and LOGGED here
$ ! 07/13/87,,,-db, Changed TCP disk reference to TCPDSK
$ ! 05/27/87,,,MXB, Check for sys$login availability to prevent hang-up
$ ! 02/03/87,,,MXB, Initial setup
$ !
$GROUP_MANAGER:				! Group manager specific adjustements
$ if .not. f$getsyi("CLUSTER_MEMBER") then GoTo START	! STD-ALONE, no changes
$ Set PROC/PRIVS=(NOALL,GRPNAM,DETACH,LOG_IO,GROUP,PRMCEB,PRMMBX,TMPMBX,-
                  OPER,EXQUOTA,NETMBX,VOLPRO,PHY_IO,PRMGBL,GRPPRV)
$ if f$mode() .eqs. "NETWORK" then EXIT			! Max speed FOR NETWORK
$START:
$ set NoOn				! Make sure we don't blow out
$ node:='f$getsyi("SCSNODE")		! This node name (no trailing blanks)
$ grp=f$fao("!3OW",f$getjpi("","GRP"))	! User's group octal number, 3 digit
$ ws:=write sys$output			!
$ if f$mode() .nes. "INTERACTIVE" then  GoTo NOT_INTERACTIVE
$ !
$ ! Interactive login implies ACCESS CONTROL CHECK (no checks for other modes)
$ !		      lavc$access concatenates "+GGG" "-GGG" or "ALL"
$ACCESS_CONTROL:
$ node=f$getsyi("NODENAME")			! get node name for messages
$ nacc=f$trnlnm("LAVC$ACCESS","LNM$SYSTEM")	! Get Node Access Control String
$ lacc=f$length (nacc)				! and it's length
$ if nacc .eqs.    "" then GoTo ACCESS_GRANTED	! No logical - grant evrybody
$ if grp  .eqs. "001" then GoTo ACCESS_GRANTED	! Always grant access to SYStem
$ n=f$loc(grp,nacc)				! Is this group in access string
$ if n .eq. lacc then GoTo ACCESS_RESTRICTED	! - no, restricted user
$ if f$extract(n-1,1,nacc) .eqs. "-" then GoTo ACCESS_DENIED ! preceeded by "-"
$ GoTo ACCESS_GRANTED				! no "-" = not DENIED = granted
$ACCESS_DENIED:
$ WS ""						! Print out notification
$ WS "SORRY, your group is NOT authorized to use node ''node'"
$ WS "Please, consult LAVC system manager. 	!
$ WS "Logging off ''node' ''f$time()'"		! And kill the process
$ STOP/Ide=0					! the fastes possible way
$ACCESS_RESTRICTED:
$ if f$loc("ALL",nacc) .ne. lacc then GoTo ACCESS_GRANTED	
$ WS ""						! Check, if everybody is granted
$ WS "WARNING, your group may use node ''node' in RESTRICTED mode only"
$ SET PROC/PRIO=3				! Reduce priority (.....)
$ACCESS_GRANTED:
$ !
$ ! Initial interactive session setup ( do the MINIMUM, let user LOGIN do it)
$ !
$ if (f$getsyi("CPU") .ne. 8) .and. -		! For BIG VAXes only
     (f$extract(0,2,f$getjpi("","TERMINAL")).nes."RT") -! and non-SET-HOST's
     then $ Set Terminal/Inquire			! inquire terminal type
$ SET CONTROL=Y						! Enable INTERRUPTS
$ SET CONTROL=T						! Enable CTRL^T
$ !
$ ! Type out our messages, if found 
$ !
$ file = f$search("lavc$data:[''node']NODENOTE.TXT")	! Node specific NOTE
$ if file .nes. "" then type 'file			
$ file = f$search("lavc$data:[GRP''grp']GRPNOTE.TXT")	! Group specific NOTE
$ if file .nes. "" then type 'file
$ file = f$search("sys$manager:SYSBOOT.TXT")		! Bootsrap errors
$ if file .nes. "" then type 'file
$NOT_INTERACTIVE:
$ !
$ ! Commands performed for INTERACTIVE, BATCH and "OTHER" process modes:
$ ! Here we define symbols that allow user to activate particular setup:
$ !
$ SET_S7*K	:==	"@gsys:[GSYS]GSLOGIN.COM"	! Set-up for S7K
$ SET_AT*COM	:==	"@AT$SYSDISK:[ATEXE]ATCOMML.COM	! Set-up for ATCOM
$ SET_TC*P	:==	"@TCPDSK:[NETDIST.MISC]SYSLOGIN.COM! Set-up for TCP/IP 
$ SET_PLO*T	:==	"@SPOL:[PLOT]PLSETUP.COM	! Set-up for PLOT
$!
$! Execute GROUP and process default LOGINs (if present)
$!
$ SET CONTROL=Y
$ file = f$search("lavc$data:[GRP''grp']GRPLOGIN.COM")	! Group LOGIN
$ if file .nes. "" then  @'file'
$!
$! Default process login is called only if HOST is available to prevent hang-up
$!
$ if .not. f$getdvi("sys$login:","EXISTS")     then GoTo FINISH
$ if .not. f$getdvi("sys$login:","HOST_AVAIL") then GoTo FINISH
$ if .not. f$getdvi("sys$login:","MNT")        then GoTo FINISH
$ file = f$search("sys$login:LOGIN.COM")		! Default dir. LOGIN
$ if file .nes. "" then  @'file'
$ verify = f$verify(0)
$!
$FINISH:
$ Verify = f$verify(verify)
$ Exit
