$ On CONTROL_Y then $  GoTo Terminate	! do not allow CTRL_Y
$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ !
$ ! LAVCSHUT.COM - System SHUTDOWN ACCOUNT login procedure
$ ! Facility: ATTC LAVC System shut down
$ ! Purpose:  Allow non-priviledged user to shut down his workstation
$ !	      and bring it up either as a cluster member or stand-alone
$ ! Notes:    For detailes refer to design spec 144-14725-000 ATTC LAVC
$ ! History:  
$ ! 04/06/88,,,MXB, Allow RT (remote) terminal if GCA0/GCC0 present
$ ! 04/06/88,,,MXB, Two system parameter files: DECWINDOWS/UISWINDOWS.PAR
$ ! 03/16/88,,,MXB, Upgrade to VMS 5.0
$ ! 01/06/88,,,MXB, ADD selection of DECWINDOW/UIS windowing system
$ ! 11/06/87,,,-db, CHICO & HARPO must notify all nodes of shutdown
$ ! 06/10/87,,,MXB, Do not allow diskless WS to "leave cluster"
$ ! 05/11/87,,,MXB, relate to syshutdown.com which will dismount/abort disks
$ ! 04/14/87,,,MXB, provisions for 11/780 nodes CHICO and HARPO
$ ! 11/06/86,,,MXB, Initial code
$ !
$ On CONTROL_Y then $ GoTo TERMINATE	! handle CTRL_Y by exit
$ Set Control=Y				!
$ On ERROR then $ Goto ERROR		! handle any errors by  Exit
$ MASTER="EDISON"			! LAVC MASTER node
$ SPARE ="EDISON"			! LAVC SPARE  node
$ SAY="write sys$output"
$!
$Start:
$ node:='f$getsyi("NODENAME")
$ SAY ""
$ SAY "	''node' SHUTDOWN PROCEDURE"
$ SAY "	executing from port "+f$getjpi("","TERMINAL")
$ SAY ""	
$ SHO USERS				! Let user know who else is using WS
$ SAY ""
$ SAY "Active BATCH processes:"
$ SHO SYS/BATCH				! Don't forget about batches
$ SAY ""
$ !
$ ! PRIVILEGE CHECKS. Only LOCAL users are allowed to use this procedure.
$ if f$mode() .nes. "INTERACTIVE"               then Goto BADUSER
$ dev=f$extract(0,1,f$getjpi("","TERMINAL"))
$ if f$getsyi("CPU") .eq. 1 .and. (dev .nes. "O") then Goto BADUSER
$ if dev .eqs. "R" .and. (f$getdvi("GCA0:","EXISTS") .or. - ! DECW$ provision
			  f$getdvi("GAA0:","EXISTS")) then GoTo Nextboot
$ if dev .nes. "T" .and. dev .nes. "W" .and. dev .nes. "O" then Goto BADUSER
$ !
$Nextboot:
$ next_cluster="YES"				! Assume we stay in cluster
$ if f$getdvi("sys$sysdevice","REMOTE_DEVICE") then GoTo WINDOWMGR
$ Inquire next_cluster "* The folowing boot should JOIN a CLUSTER [Y/N] "
$ if next_cluster .nes. "" then Goto Windowmgr
$ SAY ""
$ SAY "	The next boot may bring your workstation up either as"
$ SAY "	a standalone node,  or as an ATTC LAVC Cluster member"
$ SAY "	Note, stand-alone node functions are limited"
$ SAY ""
$ Goto Nextboot
$Windowmgr:
$ next_decwindow = "NO"				! Assume VWS (UIS) SW
$ if(.not.(f$getdvi("VAA0","EXISTS").or. -	! Graphics HW present ?
           f$getdvi("VCA0","EXISTS").or. -
           f$getdvi("GAA0","EXISTS").or. -
           f$getdvi("GCA0","EXISTS") ) ) then GoTo SetSysgen
$ Inquire next_decwindow "* The folowing boot should use  DECWINDOW [Y/N] "
$ if next_decwindow .nes. "" then $ Goto SetSysgen
$ SAY ""
$ SAY "	The next boot may bring your workstation up either as"
$ SAY "	with standard UIS/VWS windownig system, or used the new"
$ SAY "	DECWINDOW  (X-11) windownig software"
$ SAY ""
$ Goto Windowmgr
$ !
$ !	Set the SYSGEN requirements for the next boot
$SetSysgen:
$ ! Since I can not create a temporrray file here, I'v got to dispatch
$ if       next_cluster .and.       next_decwindow then goto NEXT_CD
$ if       next_cluster .and. .not. next_decwindow then goto NEXT_CU
$ if .not. next_cluster .and.       next_decwindow then goto NEXT_SD
$ if .not. next_cluster .and. .not. next_decwindow then goto NEXT_SU
$ !
$NEXT_CD:		! Cluster, DECWINDOW
$ Run sys$system:SYSGEN
USE sys$system:DECWINDOWS.PAR
SET VAXCLUSTER 2
SET WINDOW_SYSTEM 1
WRITE sys$system:VAXVMSSYS.PAR
$ GoTo NEXT_MSG
$NEXT_CU:		! Cluster, UIS
$ Run sys$system:SYSGEN
USE sys$system:UISWINDOWS.PAR
SET VAXCLUSTER 2
SET WINDOW_SYSTEM 2
WRITE sys$system:VAXVMSSYS.PAR
$ GoTo NEXT_MSG
$NEXT_SD:		! No Cluster, DECWINDOW
$ Run sys$system:SYSGEN
USE sys$system:DECWINDOWS.PAR
SET VAXCLUSTER 0
SET WINDOW_SYSTEM 1
WRITE sys$system:VAXVMSSYS.PAR
$ GoTo NEXT_MSG
$NEXT_SU:		! No Cluster, UIS
$ Run sys$system:SYSGEN
USE sys$system:UISWINDOWS.PAR
SET VAXCLUSTER 0
SET WINDOW_SYSTEM 2
WRITE sys$system:VAXVMSSYS.PAR
$ GoTo NEXT_MSG
$ !
$NEXT_MSG:
$ purge sys$system:VAXVMSSYS.PAR
$ if       next_cluster   then SAY "* The next BOOT will JOIN the VAX Cluster"
$ if .not. next_cluster   then SAY "* The next BOOT will boot STAND-ALONE workstation"
$ if       next_decwindow then SAY "* The next BOOT will bring up DECWINDOWs"
$ if .not. next_decwindow then SAY "* The next BOOT will bring up VWS (UIS) windows"
$!
$Shuttime:
$ Inquire shut "* How many minutes before shutdown start [0-nn] "
$ if "''shut'" .eqs. "" then shut = 0
$ if f$type(shut) .nes. "INTEGER" then $ Goto Timehelp
$ If shut .lt. 0 then $ SAY "* Zero shutdown, exiting ..."
$ If shut .lt. 0 then $  GoTo Terminate
$ Goto Downtime
$Timehelp:
$ SAY ""
$ SAY "	Enter the time to allow system operation before shutting"
$ SAY "	down, in minutes. "
$ SAY ""
$ Goto Shuttime
$!
$Downtime:
$ Inquire reboot "* Do you want an  automatic system reboot [YES] "
$ if reboot .eqs. "" then $ reboot = "YES"
$ if .not. reboot then $ reboot = "NO"
$ reason = "user requested reboot"
$ uptime = "after reboot completion"
$ if reboot then $ Goto Dismount
$ Inquire reason "* Enter shutdown reason [ shutting down for...] "
$ if reason .eqs. "" then $ reason = "user requested shutdown"
$ Inquire uptime "* Enter when the  system  will be up [...up...] "
$ if uptime .eqs. "" then $ uptime = "later ..."
$ !
$ ! Ask if local disks should be kept mounted cluster-wide
$ !
$Dismount:
$ keepmnt="YES"					! Assume no dismount necessary
$ if .not. f$getsyi("CLUSTER_MEMBER") then GoTo Inform
$ keepmnt="NO"					! If node is leaving cluster
$ if .not. next_cluster then $ SAY "* Disks will be DISMOUNTED from the cluster"
$ if .not. next_cluster then $ GoTo Inform	! then disks MUST be dismounted
$ Inquire keepmnt "* Do you want to leave your disks MOUNTED [Y/N] "
$ if keepmnt .nes. "" then $ Goto Dismount_1
$ SAY ""
$ SAY "To avoid mount verification problems, node's disks should"
$ SAY "be dismounted from CLUSTER, (unless node comes back soon)"
$ SAY ""
$ GoTo Dismount				! After help, inquire again
$Dismount_1:
$ if .not. keepmnt then $ Goto Inform	! Keep = skip next
$ Define LAVC$NODISMOUNT "YES"		! Tell SYSHUTDOWN to keep disks MNT
$ SAY "* Disks will remain MOUNTED to the cluster"
$ !
$ ! Inquire which nodes hould get all the shutdown messages
$ !
$Inform:
$ if .not. f$getsyi("CLUSTER_MEMBER") then GoTo Shutdown
$ if node .eqs. MASTER then nodes = "ALL"
$ if node .eqs. MASTER then $ GoTo Shutdown
$ if node .eqs. SPARE  then nodes = "ALL"
$ if node .eqs. SPARE  then $ GoTo Shutdown
$ Inquire nodes "* Nodes to notify  [comma sep. or ALL] [''node'] "
$ if nodes .eqs. "" then nodes = node
$ if nodes .eqs. "ALL" then GoTo Shutdown
$ n=-1
$Inform_loop:
$ n=n+1
$ nam = f$ele(n,",",nodes)			! Check next node
$ if nam .eqs. "," then GoTo Inform_set
$ if f$getsyi("CLUSTER_MEMBER",nam) then $ GoTo Inform_loop
$ Say "* Node ''nam' not a cluster member. Re-enter list"
$ GoTo Inform
$Inform_set:
$ DEFINE SHUTDOWN$INFORM_NODES 'nodes
$ !
$ ! Last chance inquiry to make sure he really wants shut down
$ !
$Shutdown:
$ Inquire YN "* Do you REALLY  want  to  start shutdown [Y/N] "
$ if YN .eqs. "" then $ Goto Shutdown
$ if .not. YN then $ Say "* Shutdown request cancelled ..."
$ if .not. YN then $ Goto Terminate
$ !
$ !  Dismount cluster-wide mounted local node's disks using LAVC$MGR queue
$ !
$ if keepmnt then GoTo Startshut			   ! Keep = no dismount
$ if .not. f$getsyi("CLUSTER_MEMBER") then GoTo Startshut  ! No cluster ...
$ On ERROR then GoTo DISERR				   ! Additional err msg.
$ ! Here we submit dismount command to the LAVC master (assuming it's not us)
$ ! taking down the master is too complex for now (queues restart etc...)
$ hour=shut/60			! Compute shutdown time in hours, mins
$ min= shut - (60*hour)		! to dismount at same time as going down
$ sched = f$cvt("+''hour':''min':00","ABSOLUTE")
$ SAY "* Telling the cluster MASTER to dismount our disks"
$ ! Normally, dismount is performed by MASTER in LAVC$MGR queue. However,
$ ! since dismounts sometimes fail, we do it an SPARE also, which takes care
$ ! of the master's disk shutdown as well.
$ if node .nes. MASTER then -
  submit/after="''sched'"/Que=LAVC$MGR/User=SYSTEM/NoPrint  -
  lavc$data:[LAVCCOM]LAVCDISKS.COM -
  /Par=("DISMOUNT","''node'","/CLUSTER","''sched'")
$ if node .nes. SPARE then -
  submit/after="''sched'"/Que='SPARE'$BATCH/User=SYSTEM/NoPrint  -
  lavc$data:[LAVCCOM]LAVCDISKS.COM -
  /Par=("DISMOUNT","''node'","/CLUSTER","''sched'")
$ !
$ ! Start the standard shutdown procedure
$ !
$Startshut:
$ if f$search("sys$system:QUEMAN.EXE") .eqs. "" then GoTo Noqueman
$ stop /que /manager				! Make sure queue manager 
$ SAY "* Stopping queue manager to prevent hangup"
$ wait 00:00:30					! Give it some time
$Noqueman:
$ On ERROR then GoTo ERROR			! Reset standard error handler
$ opt = "REBOOT_CHECK"
$ if f$getsyi("CLUSTER_MEMBER") then $ opt = "REMOVE_NODE"
$ set CONTROL=Y
$ @sys$system:shutdown 'shut "''reason'" NO YES "''uptime'" 'reboot 'opt
$ GoTo Terminate
$DISERR:
$ SAY "* Disks can not be dismounted, JOB QUEUE system is not operational"
$ SAY "* Inform system manager BEFORE you join cluster back !!!!!!!!!!!!!"
$ keepmnt="YES"					! Let disks mounted
$ GoTo Dismount_1
$!
$ERROR:
$ SAY "* Severe error within SHUTDOWN procedure. Please, inform system manager"
$ GoTo Terminate
$BADUSER:
$ SAY "* Sorry, this procedure may be used from local terminal or 11/780 console only"
$TERMINATE:
$ ON CONTROL_Y THEN CONTINUE
$ SAY "* SHUTDOWN Logged of at ''f$time()'"
$ WAIT 00:00:02
$ STOP/Ide=0
