$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ GoTo PHASE_1	! Development specific commands currently flagged ******
$ !
$ ! LAVCWATCH.COM - LAVC WATCH process (Dynamic RE-CONFIGURATION procedure)
$ ! Facility: ATTC LVAC System Startup and Runtime
$ ! Purpose:  Watch for LAVC configuration changes (i.e. MASTER and SPARE
$ !           nodes leaving/joining cluster
$ !	      and perform actions necessary to maintain node operational
$ !	      (all such operations are listed below)
$ !	      The procedure MUST be called FIRST in LAVC node startup, since
$ !	      it creates the intial LAVC environment, before detaching.
$ ! Notes:    Here we assume a SINGLE system COMMON per disk ([VMS$COMMON]).
$ !	      Otherwise, we would have to used [SYSn.COMMON] for the local
$ !	      common element.
$ ! History:
$ ! 03/16/88,MXB,Upgared for VMS 5.0 Subcluster
$ ! 03/02/88,MXB,Fix multiple occurences of the same disk in sys$common
$ ! 01/07/87,MXB,Instead of SYS$SYSROOT, manipulate SYS$COMMON since some SW
$ !		 seems to use SYS$COMMON (bypassing search list in sys$sysroot).
$ !		 Also removed LAVC$ROOT logicals not used any more
$ ! 12/11/87,-db,Changed system manager to JIMGRE
$ ! 07/24/87,MXB,Changed CHICO disks to DUAn:
$ ! 07/23/87,-db,Changed HARPO$DBA0 to HARPO$DUA0
$ ! 07/13/87,MXB,Added QUORUM monitoring and JOB-QUEUE system failover, 60 sec
$ ! 05/08/87,MXB,Switchover the spare node to HARPO
$ ! 04/06/87,MXB,Fixed, added initial setup in PHASE-2
$ ! 03/30/87,MXB,Initial setup
$ !
$ ! This procedure:
$ !
$ ! (1) Defines the location of LAVC "master" and "spare" node, disks
$ !	and other parameters
$ !
$ ! (2) Creates the intial LAVC environment (later checked and monitored)
$ !     (see 4b)
$ !
$ ! (3) Detaches itselves as a detached process LAVC_WATCH (if not running)
$ !
$ ! (4) Enters the checking loop:
$ !
$ !	a) If the cluster membership count (CLUSTER_NODES) loweres, adjust
$ !	   quorum to minimum (SET CLUSTER=2)
$ !
$ ! 	b) On any MASTER or SPARE nodes status (presence in cluster) change, 
$ !	   Re-define basic concealed devices:
$ !        LAVC$DATA:  (LAVC$DATA_MASTER, LAVC$DATA_SPARE,   LAVC$DATA_LOCAL)
$ !        SYS$COMMON: (SYS$COMMON_LOCAL, SYS$COMMON_MASTER, SYS$COMMON_SPARE)
$ !        adding "master" and "spare" node's  sys$common trees.
$ !	   Since VMS has troubles when some of the logicals in search list
$ !	   points to an "unavailable" or non-existent disk, we try to keep
$ !	   our logicals clean, t.e. on configuration change we re-define
$ !
$ !	c) If the LAVC configuration change is permannent (longer than nn
$ !	   checks), restarts the JOB and QUEUE system (using management
$ !	   forced restart procedure MGMQUESTA) using the new LAVC$DATA.
$ !	   (blocked it LAVC$DATA swithes back to the original).
$ !	
$ !
$ !==================(1) DEFINE ATTC LAVC CONFIGURATION ====================
$PHASE_1:
$ Set NoOn
$ Set Proc/privs=all
$ ! The LAVC database is assumed to reside in the node$device:[LAVCDATA...]
$ ! directory of the MASTER, SPARE and LOCAL node disks "node$device"
$ ! The COMMON system ROOT is assumed to be node$device:[VMS$COMMON...]
$ !
$ MASTER_NODE =="EDISON"
$ SPARE_NODE  =="MISING"
$ MASTER_DISK =="EDISON$DUA0"			! ATTC LAVC master disk
$ MASTER_LABEL=="EDISON_SYS"			! ATTC LAVC master disk label
$ SPARE_DISK  =="MISSING"			! ATTC LAVC spare  disk
$ SPARE_LABEL =="MISSING"			! ATTC LAVC spare  disk label
$ LAVC_MANAGER=="CHICO::jimgre"			! ATTC LAVC manager mail addr
$ WATCH_WAIT  =="00:01:00"			! Watchdog loop wait time	
$ QUEUE_RESET == 10				! Que MGR restart after n waits
$ MIN_QUORUM  == 02				! Minimum QUORUM required
$ !==================== ATTC LAVC  CONFIGURATION DEFINED ===================
$ !
$ ! 	If running as LAVC_WATCH, we do watchdog job. Otherwise, we assume
$ !	call from STARTUP, and we MUST detach to be totally independent.
$ !
$ lavc=f$getsyi("CLUSTER_MEMBER")	! Make sure we are in cluster
$ if f$getjpi("","PRCNAM") .eqs. "LAVC_WATCH" then GoTo PHASE_4
$ !
$ !==================== PERFORM IMMEDIATE SETUPS ======================
$PHASE_2:
$ !	When called from STARTUP, we have the responsibility
$ !	of initially pre-set the LAVC environment for the rest
$ !	of system startup.
$ !
$ GOSUB LAVC_LOGICALS			! Adjust LAVC logical names
$ if .not. lavc then GoTo Finish	! Not in cluster = nothing to do
$ !
$ !================ CREATE THE LAVC_WATCH DETACHED JOB =================
$PHASE_3:
$ !
$ ! 	LAVC WATCH must run from local system disk not to die
$ !	on LAVC state change. Thus we always make a fresh copy.
$ !
$ copy  'f$environment("PROCEDURE")' sys$specific:[SYSMGR]LAVCWATCH.COM;0
$ purge sys$specific:[SYSMGR]LAVCWATCH.COM
$ if f$search("sys$specific:[SYSMGR]LAVCWATCH.LOG") .nes. "" then -
$ purge/keep=3 sys$specific:[SYSMGR]LAVCWATCH.LOG
$ cntx=""
$PROCESS_LOOP:
$ pid=f$pid(cntx)
$ if pid .eqs. "" then GoTo PROCESS_START
$ if "LAVC_WATCH" .eqs. f$getjpi(pid,"PRCNAM") then GoTo FINISH
$ GoTo PROCESS_LOOP
$PROCESS_START:
$ RUN/Detach/uic=[1,4]-
	/Input=sys$specific:[SYSMGR]LAVCWATCH.COM-
	/Output=sys$specific:[SYSMGR]LAVCWATCH.LOG-
	/Working_set=50-
	/Process_name=LAVC_WATCH-
	/Prio=4		sys$system:LOGINOUT.EXE
$ GoTo Finish
$ !
$ !
$ !====================== CHECK FOR CLUSTER CHANGE ========================
$PHASE_4:
$ !
$ ! Initial LOOP variables setup
$ !
$ write sys$output "%LAVCWATCH-I-SETUP, LAVC WATCH set up at ''f$time()"
$ old_master = f$getsyi("CLUSTER_MEMBER",MASTER_NODE)	! Remeber configuration
$ old_spare  = f$getsyi("CLUSTER_MEMBER",SPARE_NODE)	! at this moment
$ GOSUB LAVC_LOGICALS					! and set-up logicals
$ old_count  = f$getsyi("CLUSTER_NODES")		! Remeber mebership
$ old_queman = f$logical("LAVC$DATA")			! Que Owner from logical
$ que_checks = 0					! Init counter
$ !
$ ! We keep all the comments out of our loop to reduce it's CPU cost (later,
$ ! we should make this loop an executable which returns control to us only
$ ! if something happened.
$ !
$ ! Action 4a - QUORUM MONITORING (to prevent deadlocks if more nodes crash)
$ ! Action 4b - CLUSTER MASTER MONITORING to setup our logicals and other
$ ! Action 4c - JOB/QUEUE system restart QUEUE_RESET loops after config. change
$ !
$CHECK_LOOP: que_checks = que_checks+1
$ if f$getsyi("CLUSTER_NODES")              .ne. old_count  then GoTo QUORUM
$ if f$getsyi("CLUSTER_MEMBER",MASTER_NODE) .ne. old_master then GoTo CHANGE
$ if f$getsyi("CLUSTER_MEMBER",SPARE_NODE)  .ne. old_spare  then GoTo CHANGE
$ if QUEUE_RESET  .eq. que_checks then GoTo RESET
$ Wait 'WATCH_WAIT'
$ GoTo CHECK_LOOP
$ !
$QUORUM:
$ if old_count .lt. f$getsyi("CLUSTER_NODES") then GoTo QUORUM_UPD
$ write sys$output "%LAVCWATCH-I-QUORUM, LAVC quorum adjusted at ''f$time()"
$ SET CLUSTER/QUORUM='MIN_QUORUM'		! Force quorum to minimum
$QUORUM_UPD: old_count=f$getsyi("CLUSTER_NODES")! Remeber new member count
$ GoTo CHECK_LOOP
$ !
$CHANGE:
$ write sys$output "%LAVCWATCH-I-CHANGE, LAVC configuration change at ''f$time()"
$ Request "%LAVCWATCH-I-CHANGE, LAVC configuration change at ''f$time()"
$ que_checks = 0					! No checks since change
$ old_master=f$getsyi("CLUSTER_MEMBER",MASTER_NODE)	! Remeber new master
$ old_spare =f$getsyi("CLUSTER_MEMBER",SPARE_NODE)	! and spare node
$ GOSUB LAVC_LOGICALS					! Set-up logicals 
$GoTo CHECK_LOOP
$ !
$ ! For QUEUE reset, we assume first item in LAVC$DATA search list will be
$ ! the JBCSYSQUE.DAT owner. Sometimes, we may have multiple configuraqtion
$ ! changes before we get here, and we DO NOT want to KILL/RESTART queues
$ ! in case we came back. We use SPAWN here since queue restart may hang.
$ !
$RESET:						! 
$ if old_queman .eqs. f$logical("LAVC$DATA") then GoTo CHECK_LOOP ! No Reset 
$ write sys$output "%LAVCWATCH-I-RESET, LAVC JBCSYSQUE reset at ''f$time()"
$ Request "%LAVCWATCH-I-RESET, LAVC JBCSYSQUE reset at ''f$time()"
$ old_queman = f$logical("LAVC$DATA")		! Get new Owner from logical
$ RUN/Detach/uic=[1,4]-				! And create RESET process
	/Input='f$parse("LAVC$DATA:[LAVCMGM]MGMQUESTA.COM",,,,"NO_CONCEAL")'-
	/Output=sys$specific:[SYSMGR]MGMQUESTA.LOG-
	/Process_name=LAVC_QRESET-
	/Prio=4		sys$system:LOGINOUT.EXE
$ if f$search ("sys$specific:[SYSMGR]MGMQUESTA.LOG") .nes. "" then -
  PURGE/KEEP=3	sys$specific:[SYSMGR]MGMQUESTA.LOG
$GoTo CHECK_LOOP
$ !
$ !
$LAVC_LOGICALS:
$ !====================== DEFINE CONCEALED DEVICES ========================
$ !
$ !			M O U N T   L A V C  D I S K S
$ !
$ arg="''MASTER_DISK'|''MASTER_LABEL'|/NoHigh|"
$ if lavc then Gosub mount_disk		! Mount the "MASTER" LAVC disk
$ arg="''SPARE_DISK'|''SPARE_LABEL'|/NoHigh|"
$ if lavc then Gosub mount_disk		! Mount the "SPARE" LAVC disk$ !
$ !
$ ! 	Build search list logical names. To avoid existing VMS problems with
$ ! 	non-existent devices in the search list, we build our search lists
$ ! 	using only devices which are online, mounted. This implies that on
$ ! 	dynamic cluster configuration change we will have to change those
$ ! 	logicals. Also, we avoid duplicate reference to the same device
$ !	(resulting from boot of master or spare disk). 
$ !
$ !		  A N A L Y Z E   C O N F I G U R A T I O N
$ !
$ sysdv=f$getdvi("sys$sysdevice","FULLDEVNAM")	! Local system device
$ ldata=sysdv+"[LAVCDATA.]"			! Local database
$ lcomm=sysdv+"[VMS$COMMON.]"			! Local common
$ mdata=""
$ mcomm=""
$ if .not. f$getdvi(MASTER_DISK,"EXISTS")    then GoTo NO_MASTER
$ if .not. f$getdvi(MASTER_DISK,"MNT")       then GoTo NO_MASTER
$ if .not. f$getdvi(MASTER_DISK,"HOST_AVAIL")then GoTo NO_MASTER
$ MASTER_DISK=f$getdvi(MASTER_DISK,"FULLDEVNAM")! Get exact device name
$ mdata=MASTER_DISK+"[LAVCDATA.]"		! Master's data
$ mcomm=MASTER_DISK+"[VMS$COMMON.]"		! Master's common
$ if MASTER_DISK .eqs. sysdv then ldata=""	! Equal disks = don't add local
$ if MASTER_DISK .eqs. sysdv then mcomm=""	! Equal disks = don't add master
$NO_MASTER:
$ sdata=""
$ scomm=""
$ if .not. f$getdvi(SPARE_DISK,"EXISTS")     then GoTo NO_SPARE
$ if .not. f$getdvi(SPARE_DISK,"MNT")        then GoTo NO_SPARE
$ if .not. f$getdvi(SPARE_DISK,"HOST_AVAIL") then GoTo NO_SPARE
$ SPARE_DISK=f$getdvi(SPARE_DISK,"FULLDEVNAM")	! Remove rooted dev's
$ sdata= SPARE_DISK+"[LAVCDATA.]"		! Spare's data
$ scomm= SPARE_DISK+"[V4COMMON.]"		! Spare's common
$ if SPARE_DISK .eqs. sysdv then ldata=""	! Equal disks = don't add local
$ if SPARE_DISK .eqs. sysdv then scomm=""	! Equal disks = don't add spare
$NO_SPARE:
$ !
$ !			D E F I N E    L O G I C A L S
$ !
$ DS = "Define/System/Exec"			! shorthand fore define
$ srchl=""					! Logical LAVC$DATA =
$ if mdata .nes. "" then srchl=srchl+"LAVC$DATA_MASTER,"! - master's (if any)
$ if sdata .nes. "" then srchl=srchl+"LAVC$DATA_SPARE,"	! + spare's  (if any)
$ if ldata .nes. "" then srchl=srchl+"LAVC$DATA_LOCAL"	! + local    (if not eq)
$ if ldata .eqs. "" then srchl=f$extract(0,f$len(srchl)-1,srchl)
$ if mdata .nes. "" then DS LAVC$DATA_MASTER 'mdata'/Transl=CONCEALED
$ if sdata .nes. "" then DS LAVC$DATA_SPARE  'sdata'/Transl=CONCEALED
$ 			 DS LAVC$DATA_LOCAL  'sysdv'[LAVCDATA.]/Transl=CONCEALED
$ DS LAVC$DATA	'srchl'
$ !
$ !						! Individual COMMONs:
$ syssp=f$trnlnm("sys$sysroot","lnm$system",0)	! system "specific" tree
$ sysco=syssp-"]"+"SYSCOMMON.]"			! system "common" tree
$ if f$trnlnm("sys$sysroot","lnm$system",1) -	! FLAT system disk (no common)
     .eqs. "" then sysco = syssp		! = > common = specific
$ !
$ 			 DS SYS$COMMON_LOCAL  'sysco'/Transl=CONCEALED
$ if mcomm .nes. "" then DS SYS$COMMON_MASTER 'mcomm'/Transl=CONCEALED
$ if scomm .nes. "" then DS SYS$COMMON_SPARE  'scomm'/Transl=CONCEALED
$ !						! Logical SYS$COMMON=
$ srchl =		              "SYS$COMMON_LOCAL" ! - Local (always)
$ if mcomm .nes. "" then srchl=srchl+",SYS$COMMON_MASTER"! - master's (if any)
$ if scomm .nes. "" then srchl=srchl+",SYS$COMMON_SPARE" ! + spare's  (if any)
$ DS SYS$COMMON 'srchl'
$ !
$ RETURN
$ !
$ !========================= MOUNT DISK PROCEDURES ==========================
$MOUNT_DISK:
$ ! Mount the disk, if on-line and NOT mounted on this node
$ dsk=f$element(0,"|",arg)	! Parse arguments:
$ lab=f$element(1,"|",arg)	! disk|label|set-qualifiers
$ qua=f$element(2,"|",arg)	! qualifiers not used here
$ if .not. f$getdvi(dsk,"EXISTS") then GoTo NO_DISK
$ if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NO_DISK
$ if .not. f$getdv(dsk,"MNT")    then MOUNT/system/NOassist/Cluster/Noreb 'dsk 'lab
$ if       f$getdv(dsk,"MNT")    then Return
$NO_DISK:
$ Return
$ !==========================================================================
$Finish:
$ Verify = f$verify(verify)
