$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ !
$ ! SYSHUTDWN.COM - GENERIC VMS LAVC System Shut-Down Procedure
$ ! Facility: ATTC LVAC System SHUT-DOWN
$ ! Purpose:  Generic system shutdown procedure. DISMOUNTS local node's 
$ !	      disks from cluster unless prevented by a logical name
$ !           LAVC$NODISMOUNT=YES
$ ! Notes:    Local disk DISMOUNT is required if the node leaves cluster
$ !	      to boot stand-alone and then comes back to cluster.  
$ !	      In such a scenario, the rest of the cluster will try
$ !	      to re-mount disks after node comes back, resulting in endless
$ !	      mount verification (since volume mount-count has changed).
$ !	      This file is maintained in LAVC$DATA:[LAVCCOM] 
$ !	      and distributed to each node's sys$common:[SYSMGR]
$ !	      directory ( to be used by SATELLITES, if any ).
$ ! History:
$ ! 05/10/87,MXB,Initial setup
$ !
$ ! Designed to work in LAVC configuration(s) as well for STAND-ALONE boot 
$ ! configuration. For details refer to FUNCTIONAL SPECIFICATION
$ ! 144-14725-000 ATTC LAVC CONFIGURATION
$ !
$ !
$ !
$ ! Dismount /Abort/Cluster all local disks (if required). By default,
$ ! we force dismout. Only if specially requested, we leave disks monted
$ ! assuming we leave cluster for a short while only.
$ ! Since we can NOT dismount our system disk, we submit dismount procedure
$ ! to LAVC MASTER (assuming it's up and running, otherwise, LAVC$MGR
$ ! queue is stopped and will be deleted at MASTER startup).
$ ! 
$ write sys$output "%SYSHUTDWN-I-EXEC, System specific shutdown executing"
$ if f$logical("LAVC$NODISMOUNT") .eqs. "YES" then GoTo Finish
$ node:='f$getsyi("NODENAME")
$ write sys$output "%SYSHUTDWN-I-DISM, Dismounting all served disks"
$ @LAVC$DATA:[LAVCCOM]LAVCDISKS DISMOUNT 'node' /CLUSTER
$ !
$FINISH:
$ write sys$output "%SYSHUTDWN-I-EXEC, System specific shutdown finished"
$ Verify = f$verify(Verify)
$ Exit
