$ Verify = f$verify(f$extract(0,1,"''debug'0"))	! Set $ Debug==1 for trace
$ GoTo PHASE_1	! Development specific commands currently flagged ******
$ !
$ ! SYSTARTUP.COM - GENERIC VMS LAVC System Start-up Procedure
$ ! Facility: ATTC LVAC System START-UP
$ ! Purpose:  Top level system startup procedure. Dispatches individual
$ !	      startup files, based upon particular system configuration.
$ ! Notes:    N E V E R  put any NODE-SPECIFIC commands here !
$ !	      See description below W H E R E to put commands to execute
$ !	      during system startup.
$ !	      This file must be updated on major LAVC configuration
$ !	      change and distributed to each node's sys$common:[SYSMGR]
$ !	      directory ( to be used by SATELLITES, if any ).
$ !	      Normally, such a distribution is automatic by MGMDATUPD.COM
$ ! History:
$ ! 01/07/87,MXB,Add support for ARGUMENTS in NODESTART.DAT
$ ! 01/07/87,MXB,Changed LAVC disks mount to MOUNT/NOREB to save time
$ ! 09/23/87,MXB,Changed VMSD1 to VMSD2 for PRIVATE boot (VMS 4.6 uses VMSD1)
$ ! 08/17/87,MXB,Added skipping blank records in NODESTART.DAT
$ ! 07/24/87,MXB,CHICO disks changed to DUAn:
$ ! 07/23/87,-db,Changed HARPO$DBA0 to HARPO$DUA0
$ ! 05/28/87,MXB,Skip procedures on non-available disks
$ ! 05/19/87,MXB,Add wait for MASTER and SPARE disks to come up (powerfail)
$ ! 05/08/87,MXB,Switchover the SPARE node to node HARPO
$ ! 03/29/87,MXB,Logical names setup update, simplified configuration
$ ! 02/03/87,MXB,Initial setup
$ ! 01/11/88,JLG,Added accounting on startup.
$ !
$ ! GENERIC LAVC VMS system startup procedure. Designed to work both for
$ ! boot in LAVC configuration(s) as well for STAND-ALONE boot of (limited)
$ ! configuration. For details refer to FUNCTIONAL SPECIFICATION
$ ! 144-14725-000 ATTC LAVC CONFIGURATION
$ !
$ ! To add/modify commands executed for this particular node, DO NOT modify
$ ! this SYSTARTUP.COM. Add any product startup procedures (normally called
$ ! by SYSTARTUP.COM) into a file LAVC$DATA:[nodename]NODESTART.DAT. 
$ ! If you need to add NODE specific commands, which are NOT a part of some
$ ! product startup procedure, use LAVC$DATA:[nodename]NODESPEC.COM
$ ! 
$ ! This procedure:
$ !
$ ! (1) Defines the location of LAVC "master" and "spare" node, mounts
$ !	"master" (or "spare") disk for access
$ !
$ ! (2) Executes the LAVCWATCH.COM procedure. This procedure establishes
$ !	basic cluster logical names, and starts the monitor process
$ !	to dynamically watch the LAVC configuration changes. LAVCWATCH
$ !	contains hardcoded LAVC configuration, and creates logicals:
$ !
$ !     LAVC$DATA   as a search list pointing to LAVC database
$ !     SYS$COMMON  adding MASTER and SPARE node's  sys$common trees.
$ !
$ ! (3) Locates the file LAVC$DATA:[node]NODESTART.DAT. This file contains
$ !     a list of nested DCL command procedures to execute for that node.
$ !	Executes all the listed DCL procedures, either on-line or as a
$ !	detached process for explicite UIC. The on-line procedures may
$ !	have arguments, the detached ones NOT.
$ !	Typical procedures:
$ !	  lavc$data:[nodename]NODESPEC  Configure LOCAL terminals and devices
$ !	  lavc$data:[LAVCCOM]LAVCDISKS Mount LAVC disks	
$ !	  lavc$data:[LAVCCOM]LAVCPRINT Start LAVC print queues, define forms
$ !	  lavc$data:[LAVCCOM]LAVCBATCH Start LAVC batch queues	
$ !	  lavc$data:[LAVCCOM]LAVCLOGNM Define system/group wide logical names
$ !	  sys$manager:STARTNET      Start DECNET
$ !	  sys$manager:STARTVWS	    Start UIS Workstation software
$ !
$ !	The NODESTART.DAT fields are separated by vertical bar "|":
$ !	               E|[1,4]|pathname | comment
$ !     field 1: Severity code W,E,F for procedure "not found".
$ !	         If the field 1 contains "$", the rest is DCL command
$ !	field 2: UIC for detached process. Empty fields means on-line.
$ !	field 3: Pathname. Should use cluster-qualified logical names.
$ !	field 4: Comment, displayed on console.
$ !	         
$ !
$ ! (4) Checks the startup success. In case of any error create and display
$ !     notification message. Send such a message to LAVC administrator(s).
$ !
$ ! Limited startup:
$ ! This startup procedure uses Startup paramaters to allow for
$ ! complete startup with non-operator user access restricted ("private")
$ ! Requirements should be set using conversational bootstrap:
$ ! 		SYSBOOT> SET VMSD2 1	! Private
$ !
$ !==================(1) DEFINE ATTC LAVC CONFIGURATION ====================
$PHASE_1:
$ Set NoOn
$ ! The LAVC database is assumed to reside in the node$device:[LAVCDATA...]
$ ! directory of the MASTER, SPARE and LOCAL node disks "node$device"
$ !
$ MASTER_DISK =="EDISON$DUA0"			! ATTC LAVC master disk
$ MASTER_LABEL=="EDISON_SYS"			! ATTC LAVC master disk label
$ SPARE_DISK  =="MISSING"			! ATTC LAVC spare  disk
$ SPARE_LABEL =="MISSING"			! ATTC LAVC spare  disk label
$ LAVC_MANAGER=="CHICO::MARBRU"			! ATTC LAVC manager mail addr
$ !==================== ATTC LAVC  CONFIGURATION DEFINED ===================
$ !
$ ! All called startup procedures may add information to following symbols 
$ ! if they need to report any errors: systaerr==systaerr+"error"+systacrlf
$ !
$ systaerr:== ""		! report system startup error
$ systafat:== ""		! report system startup fatal error
$ systawar:== ""		! report system startup warning
$ systaCRLF:=="
"	! messages delimiter
$ !
$ DS = "Define/System/Exec"	! shorthand fore define
$ W  = "Write sys$output"	! print out a message
$ node := 'f$getsyi("NODENAME")	! get this node name (no trailing spaces)
$ if node .eqs. "" then node = "SALONE"
$ lavc=f$getsyi("CLUSTER_MEMBER")
$ if .not. lavc then W "%STARTUP-I-COMMENCING Starting STAND ALONE ''node' at ''f$time()'"
$ if lavc       then W "%STARTUP-I-COMMENCING Starting LAVC MEMBER ''node' at ''f$time()'"
$ !
$ !====================== EXECUTE LAVC WATCH PROCEDURE ========================
$PHASE_2:
$ !
$ !         M O U N T   L A V C  M A S T E R / S P A R E   D I S K S
$ !
$ arg="''MASTER_DISK'|''MASTER_LABEL'|/NoHigh|"
$ if lavc then Gosub mount_disk		! Mount the "MASTER" LAVC disk
$ arg="''SPARE_DISK'|''SPARE_LABEL'|/NoHigh|"
$ if lavc then Gosub mount_disk		! Mount the "SPARE" LAVC disk$ !
$ !
$ !	    F I N D  a n d   E X E C U T E    L A V C W A T C H . C O M
$ !
$ path = f$search("''MASTER_DISK':[LAVCDATA.LAVCCOM]LAVCWATCH.COM")
$ if path .nes. "" then GoTo EXEC_LAVCWATCH
$ path = f$search("''SPARE_DISK':[LAVCDATA.LAVCCOM]LAVCWATCH.COM")
$ if path .nes. "" then GoTo EXEC_LAVCWATCH
$ path = f$search("sys$sysdevice:[LAVCDATA.LAVCCOM]LAVCWATCH.COM")
$ if path .nes. "" then GoTo EXEC_LAVCWATCH
$ WS "%STARTUP-F-NOWATCH, LAWCWATCH procedure not found"
$ systafat==systafat+"LAVCWATCH not found"+systaCRLF
$ GoTo PHASE_3
$EXEC_LAVCWATCH:
$ @'path			! Execute LAVCWATCH.COM 
$ GoTo PHASE_3			! to set-up basic LAVC logicals
$ ! 
$MOUNT_DISK:			! Subroutine for disk mounts
$ ! Mount the disk, if on-line and NOT mounted on this node
$ num_retry=10			! Allow up to 10 retries (5 minutes !!!)
$MOUNT_RETRY:
$ dsk=f$element(0,"|",arg)	! Parse arguments:
$ lab=f$element(1,"|",arg)	! disk|label|set-qualifiers
$ qua=f$element(2,"|",arg)	!
$ if dsk .eqs. "MISSING"              then Return
$ if .not. f$getdvi(dsk,"EXISTS")     then GoTo NO_DISK
$ if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NO_DISK
$ if .not. f$getdv(dsk,"MNT")    then MOUNT/system/NOassist/Noreb 'dsk 'lab
$ sts = $status
$ if .not. sts then W "STARTUP-I-MNTFAIL Failed to mount ''dsk'"
$ if .not. sts then systaerr==systaerr+"''dsk' mount err ''sts'"+systaCRLF
$ Return
$NO_DISK:
$ num_retry=num_retry-1		! Update remaining retries
$ if num_retry .le. 0 then GoTo MOUNT_FAILED
$ W "%STARTUP-I-DSKWAIT Waiting for cluster disk ''dsk'  ''num_retry' retries left"
$ WAIT 00:00:30			! WAIT and hope node/disk comes
$ GOTO MOUNT_RETRY		! Repeat the mount attempt
$MOUNT_FAILED:
$ W "%STARTUP-W-NOLAVCDISK Cluster disk ''dsk' presently not available"
$ systawar==systawar+"''dsk' unavailable"+systaCRLF
$ Return
$ !
$ !=================== EXECUTE NODE SPECIFIC PROCEDURES ===================
$PHASE_3:
$ OPEN/Read NODE_DATA lavc$data:['node']NODESTART.DAT
$ if .not. $STATUS then $ Goto NO_NODE_DATA
$ !
$ ! Record format:  x|UIC|filespec|note 
$ ! where:	    x=comment "!" flag or
$ !		      severity flag (F,E,W)(error class if file not found) or
$ !		      DCL command flag "$" (execute this line)
$ !		    UIC = directs to detach procedure under this UIC
$LOOP:
$ READ/End=END_NODE_DATA NODE_DATA rec		! Get next data record
$ seve=f$extract(0,1,rec)			! Get severity code for a line
$ if seve .eqs. "!" then GoTo LOOP		! Skip comments
$ if seve .eqs. "$" then 'rec			! Execute direct DCL command
$ if seve .eqs. "$" then GoTo LOOP		!  and loop for next line
$ rec = f$edit(rec,"UNCOMMENT")+"|"		! Remove comment, if any
$ UIC=f$ele(1,"|",rec)				! Get UIC specifier
$ UIC=UIC-"["-"]"				! remove brackets, if any
$ tmp =f$ele(2,"|",rec)				! extract filename
$ file=f$ele(0," ",tmp)				! - separating arguments
$ args=tmp-file					! - from filespecifier
$ note=f$ele(3,"|",rec)				! extract comment
$ if UIC .eqs. "|" .or. file .eqs. "|" then GoTo LOOP
$ !
$ !			 Execute Directly (with atguments)
$EXECUTE_FILE:
$ if .not. f$getdvi(f$parse(file,,,"DEVICE","SYNTAX_ONLY"),"HOST_AVAIL") then -
  GoTo Unknown_file				! Dont hang-up on device
$ path=f$search(file)				! Check file presence
$ if path .eqs. "" then $ Goto Unknown_file	! no - report error
$ W "%STARTUP-I-COMMENCING "+note		! Comment on console
$ if UIC .nes. "" then GoTo DETACH_FILE		!
$ @'path 'args					! Execute file immediately
$ sts=$STATUS					! Save status for check
$ if (sts.and.6).ne.0 then systaerr==systaerr+"Status ''sts' on ''file'"+systaCRLF
$ Goto LOOP
$ !			Execute Detach Process
$DETACH_FILE:
$ name=f$par(path,,,"NAME")			! get file name from path
$ run/uic=['UIC']/Detach/input='path'/output=sys$manager:'name'.LOG -
      sys$system:loginout.exe			! create detached process
$ sts=$STATUS					! Save status for check
$ if (sts.and.6).ne.0 then systaerr==systaerr+"Status ''sts' on ''file'"+systaCRLF
$ if f$search("sys$manager:''name'.LOG") .nes. "" then Purge sys$manager:'name'.LOG
$ GoTo LOOP					!
$ !			File not Found
$UNKNOWN_FILE:
$ if seve .eqs. "E" then $ W "%STARTUP-E-NOFILE-FOR "+note	! report error
$ if seve .eqs. "E" then $ systaerr==systaerr+"Missing file ''file'"+systaCRLF
$ if seve .eqs. "F" then $ W "%STARTUP-F-NOFILE-FOR "+note	! report error
$ if seve .eqs. "F" then $ systafat==systafat+"Missing file ''file'"+systaCRLF  
$ GOTO LOOP
$ !			Final File Processing
$END_NODE_DATA:					! End of data file
$ Close NODE_DATA				! Close node data file
$Goto PHASE_4
$NO_NODE_DATA:					! Handle fatal error
$ W "%STARTUP-F-NODATAFILE Node startup data file not available"
$ systafat==systafat+"Node startup data file not available"+systaCRLF
$Goto PHASE_4
$ !
$ !
$ !=================== CHECK ERRORS AND ALLOW ACCESS =========================
$PHASE_4:
$ ! Here we create a file sys$manager:sysboot.txt, which is either empty
$ ! or contains logged startup errors. This file is (normally) displayed
$ ! by the system login procedure (sys$sylogin) at each user's boot.
$ ! Also, in case of any errors, we attempt to mail file to "LAVC_MANAGER"
$ !
$ Create sys$manager:sysboot.txt;0	! Create a new boot notice file
$ Purge  sys$manager:sysboot.txt	! Purge an old ones
$ set protection=(w:re) sys$manager:sysboot.txt;0
$ errors=systawar+systaerr+systafat
$ if errors .eqs. "" then $ Goto Done
$ wf := write file
$ Open/append file sys$manager:sysboot.txt;0	
$ if .not. $status then $ Goto Done
$ wf ""
$ wf "System START-UP on ''f$time()' completed with"
$ if systawar .nes. "" then $ wf "Warnings  on: "
$ if systawar .nes. "" then $ wf systawar
$ if systaerr .nes. "" then $ wf "Errors    on: "
$ if systaerr .nes. "" then $ wf systaerr
$ if systafat .nes. "" then $ wf "Fatal errors: "
$ if systafat .nes. "" then $ wf systafat
$ wf "SORRY for any inconvenience this may cause"
$ wf ""
$ Close file
$ Type sys$manager:sysboot.txt
$ if LAVC_MANAGER .nes. "" then -
$ Mail/Subj="Startup Errors on ''f$time()'" sys$manager:sysboot.txt 'LAVC_MANAGER
$ !
$Done:
$ requests = p1+p2+p3+p4+p5+p6+p7+p8		! Check for MINIMUM startup
$ if f$loc("MINI",requests) .ne. f$len(requests) then $ Exit
$ Private  = 0					! Check for PRIVATE startup
$ if f$getsyi("VMSD2") .ne. 0 then $ Private = 1
$ intuser=f$getsyi("IJOBLIM")			!Max users allowed for system
$ if systafat .nes. "" then $ intuser = 0	!Disable non-operator logins
$ if Private           then $ intuser = 0	!Disable non-operator logins
$ startup$interactive_logins == intuser		!Tell startup.com how many
$ if intuser .gt. 1 then $ REPLY /ALL/NODE/BELL "''node' VMS system operational"
$ if Private then $ W "STARTUP-I-PRIVATE Private startup, non-operator logins are disabled"
$FINISH:
$ Verify = f$verify(Verify)
$ Exit
