$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ !
$ ! MGMCOLLECT.COM - LAVC Management Data Collection procedure
$ ! Facility: ATTC LVAC System Management
$ ! Purpose:  Procedure used to collect important cluster management data
$ !	      from individual node  to a common database
$ ! Notes:    
$ !	      The following system files are handled here:
$ !	      sys$manager:ACCOUNTNG.DAT   -->  target:Node_ACC_ddMMMyy.DAT
$ !	      sys$manager:OPERATOR.LOG    -->  target:Node_OPR_ddMMMyy.LOG
$ !	      sys$errorlog:ERRLOG.SYS     -->  target:Node_ERR_ddMMMyy.SYS
$ !
$ !           The date is the date of collection, thus the file
$ !	      contains information BEFORE the date (it is assumed
$ !	      collection executes  at MIDNIGHT.
$ !		The ACCOUNTNG.DAT needs to be mainained for later
$ !	      analysis...the OPERATOR.LOG & ERRLOG.SYS simply need to be
$ !	      archived and deleted.
$ !
$ ! History:
$ ! 20 Oct 87, -db, Coding resumed
$ ! 05/28/87,  MXB, Coding started
$ !
$ ! Arguments:
$ !	P1	Target data acconting collection device/directory  "dev:[dir]"
$ !
$ ! ********************************************************************
$START:
$	Set NoOn
$ 	if P1 .eqs. "" then P1 = "OPRDSK:[LAVC_ACNT]
$	target=p1
$	SAY="Write sys$output"			! Shorthands for messages
$	ERR="Write sys$error"			! and errors
$	FAC="%DATCOL-"				! Our "facility code"
$	STS=1					! Standard status
$ !	
$	node=f$getsyi("NODENAME")		! This local node ...
$	if node .eqs. "" then ERR FAC+"F-NONODE, Unknown node name, exiting"
$	if node .eqs. "" then GoTo FATERR
$	mon=f$extract(3,3,f$time())		! Get month
$	day=f$extract(0,2,f$time())		! and day
$	if f$extract(0,1,day) .eqs. ""  then day="0"+f$extract(1,1,day)
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ ! *********************** Handle the ACCOUNTING file **********************
$ !
$ RENAME  sys$specific:[sysmgr]ACCOUNTNG.DAT;* sys$specific:[sysmgr]ACC.DAT;*
$ SET ACC/NEW					! Create the new accountng file
$ COPY  sys$specific:[sysmgr]ACC.DAT;*	'target'ACC_'mon''day'.'node'
$ if $status then DELETE  sys$specific:[sysmgr]ACC.DAT;*
$ !
$ ! ********************** Handle the  OPERATOR LOG files ******************
$ !
$ RENAME  sys$specific:[sysmgr]OPERATOR.LOG;* sys$specific:[sysmgr]OPR.LOG;*
$ SET UIC [1,4]					! Make sure we are SYSTEM
$ STOP OPCOM					! Kill the OPCOM job
$ IF $STATUS THEN @SYS$SYSTEM:STARTUP OPCOM	! And restart to create new file
$ DEFINE/User sys$command OPA0:			! Disable console messages
$ if f$getsyi("CPU") .eq. 8 then REPLY/Disable	! on any flavour of uVAXes
$ COPY sys$specific:[sysmgr]OPR.LOG;*    'target'OPR_'mon''day'.'node'
$ if $status  then  DELETE sys$specific:[sysmgr]OPR.LOG;*
$ !
$ ! ********************** Handle the  ERRLOG file *************************
$ !
$ RENAME  sys$specific:[syserr]ERRLOG.SYS;* sys$specific:[syserr]ERR.SYS;*
$ COPY    sys$specific:[syserr]ERR.SYS;*    'target'ERR_'mon''day'.'node'
$ if $status  then  DELETE sys$specific:[syserr]ERR.SYS;*
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	Verify = f$verify(Verify)
$	Exit %X10000004
