$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMDATCVT.COM - CONVERT THE LAVC DATABASE FILES from V4.x to VMS 5.x
$ ! Facility: ATTC LAVC System Management
$ ! Purpose:  Procedure used to propagate LAVC databse changes to VMS 5.n
$ !	      SUBCLUSTER.
$ ! Notes:    Procedure contains hardcoded DEFAULTS for ATTC LAVC
$ ! History:
$ ! 03/16/88,MARBRU, Created from MGMDATUPD.COM
$ !
$ ! Arguments:
$ !
$ !	P1	Source V4.n (MASTER) disk 		    "node::ddcu:"
$ !	P2	Target V5.n (MASTER) disk           	    "node$ddcu"
$ !	P3	not used
$ !	P4	Options: SUBMIT (after=tomorrow+01:00:00)
$ !
$ ! ********************************************************************
$START:
$	Set NoOn
$	if P1 .eqs. "" then P1 = "CHICO::DUA4:"	! Default MASTER node
$	if P2 .eqs. "" then P2 = "EDISON$DUA0:"	! Default SPARE node
$	if P3 .eqs. "" then P3 = "NONE"
$	if P3 .eqs. "NONE" then P3 = ""		! Allow explicit NONE
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error
$	FAC="%DATUPD-"
$	STS=1					! Standard status
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ !	If P4=SUBMIT, procedure (RE) submits itself int LAVC$MGR queue
$RESUBMIT:
$	if f$extr(0,3,P4) .nes. "SUB" then GoTo CHECK_MASTER
$!	wait 00:00:30				! Avoid cluster time problem
$	if f$search(   "sys$manager:MGMDATUPD.LOG") .nes. "" then -
   	PURGE /Keep=3   sys$manager:MGMDATUPD.LOG
$	SUBMIT/Keep/Log=sys$manager:MGMDATUPD.LOG -
	      /Para=("''p1'","''p2'","''p3'","''p4'") -
	      /After="TOMORROW+00:10:00" -	! Resubmit self
              /User=SYSTEM/Que=LAVC$MGR	-	! using SYSTEM account
	      'f$elem(0,";",f$environment("PROCEDURE"))
$ !
$CHECK_MASTER:
$ 	dsk=P1					! Check MASTER disk presence
$ 	GOSUB CHECK_DISK				
$ 	if dsk .eqs. "" then ERR FAC+"F-NOMASTER, Master disk ''p1' not ready"
$ 	if dsk .eqs. "" then GoTo FATERR
$	mas=dsk					! Save master disk device name
$ !
$ ! *********************** SPARE NODE UPDATE *************************
$ !
$UPDATE_MASTER:
$ 	dsk=P2					! Check target disk presence
$ 	GOSUB CHECK_DISK			!
$ 	if dsk .eqs. "" then ERR FAC+"E-NOSPARE, Spare disk ''p2' not ready"
$ 	if dsk .eqs. "" then GoTo UPDATE_NODES
$	tgt=dsk
$	SAY FAC+"I-UPDSPR, Updating the TARGET disk ''tgt'"
$ !             
$UPDATE_FILES:
$	dir = "[LAVCDATA.LAVCCOM]"		! LAVCCOM directory used here
$	COPY 'mas''dir'SYSUAF.DAT;0,NETUAF.DAT;0,RIGHTSLIST.DAT;0 -
	     'tgt''dir'*.*;0
$	DEFINE  NETUAF   'tgt''dir'NETUAF.DAT	! Setup for NETUAF conversion
$	DEFINE  NETPROXY 'tgt''dir'NETPROXY.DAT	!
$	RUN SYS$SYSTEM:CVTNAFV5.EXE		! Convert NETUAF to NETPROXY
$	MCR NCP SET KNOWN PROXIES ALL		! Reload DECNET databse
$	PURGE   'tgt''dir'*.*			! Limit OUT files to one version
$	RENAME  'tgt''dir'*.*;0   *.*;1		! (require version 1)
$	GoTo FINISH
$ !
$ !  Disk accessibility cheking subroutine (argument = dsk, updated)
$ !
$CHECK_DISK:
$	if f$search("''dsk'[000000]*.*").eqs. "" then GoTo NO_DISK ! Decnet 
$	RETURN
$NO_DISK:
$	dsk=""					! Flag disk not available
$	RETURN
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	if f$search("GRPLIST.TMP") .nes. "" then DELETE GRPLIST.TMP;*
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	if f$search("GRPLIST.TMP") .nes. "" then DELETE GRPLIST.TMP;*
$	Verify = f$verify(Verify)
$	Exit %X10000004
