$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMDATUPD.COM - UPDDATE THE LAVC DATABASE from the MASTER node
$ ! Facility: ATTC LAVC System Management
$ ! Purpose:  Procedure used to propagate LAVC databse changes to SPARE
$ !	      and all LAVC FULL member nodes.
$ ! Notes:    Procedure contains hardcoded DEFAULTS for ATTC LAVC
$ ! History:
$ ! 03/16/88,MARBRU, Limited to V5.0 subcluster
$ ! 07/09/87,-db,Added Edison & cleaned up some comments
$ ! 06/15/87,MXB,Quit JBCSYSQYE.DAT copy, add new boot nodes to update
$ ! 05/15/87,MXB,Added cleanup of satellite directories
$ ! 04/08/87,MXB,Coding started
$ !
$ ! Arguments:
$ !
$ !	P1	Source (MASTER) disk 		    "node$ddcu"
$ !	P2	Spare disk           		    "node$ddcu"
$ !	P3	List of full node's disks to update "node$ddcu|node$ddcu"
$ !	P4	Options: SUBMIT (after=tomorrow+01:00:00)
$ !
$ ! ********************************************************************
$START:
$	Set NoOn
$	if P1 .eqs. "" then P1 = "EDISON$DUA0:"	! Default MASTER node
$	if P2 .eqs. "" then P2 = "MISSING:"	! Default SPARE node
$	if P3 .eqs. "" then P3 = "NONE"
$	if P3 .eqs. "NONE" then P3 = ""		! Allow explicit NONE
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error
$	FAC="%DATUPD-"
$	STS=1					! Standard status
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ !	If P4=SUBMIT, procedure (RE) submits itself int LAVC$MGR queue
$RESUBMIT:
$	if f$extr(0,3,P4) .nes. "SUB" then GoTo CHECK_MASTER
$!	wait 00:00:30				! Avoid cluster time problem
$	if f$search(   "sys$manager:MGMDATUPD.LOG") .nes. "" then -
   	PURGE /Keep=3   sys$manager:MGMDATUPD.LOG
$	SUBMIT/Keep/Log=sys$manager:MGMDATUPD.LOG -
	      /Para=("''p1'","''p2'","''p3'","''p4'") -
	      /After="TOMORROW+01:00:00" -	! Resubmit self
              /User=SYSTEM/Que=LAVC$MGR	-	! using SYSTEM account
	      'f$elem(0,";",f$environment("PROCEDURE"))
$ !
$CHECK_MASTER:
$ 	dsk=P1					! Check MASTER disk presence
$ 	GOSUB CHECK_DISK				
$ 	if dsk .eqs. "" then ERR FAC+"F-NOMASTER, Master disk ''p1' not ready"
$ 	if dsk .eqs. "" then GoTo FATERR
$	mas=dsk					! Save master disk device name
$	dir/Out=GRPLIST.TMP/Col=1/Nohead/Notrail 'mas'[LAVCDATA]GRP*.DIR
$ !
$ ! *********************** SPARE NODE UPDATE *************************
$ !
$UPDATE_SPARE:
$ 	dsk=P2					! Check SPARE disk presence
$ 	GOSUB CHECK_DISK			!
$ 	if dsk .eqs. "" then ERR FAC+"E-NOSPARE, Spare disk ''p2' not ready"
$ 	if dsk .eqs. "" then GoTo UPDATE_NODES
$	SAY FAC+"I-UPDSPR, Updating the SPARE disk ''dsk'"
$	dir="[LAVCDATA...]"			! Directories to update
$	GOSUB UPDATE_FILES			! Do update
$ !
$ ! *********************** MEMBER NODES UPDATE *************************
$ !
$ !  Local node's LAVC database update is based on the list of disk names
$ !  in argument P3 using form: "node$ddcu|node$ddcu|node$ddcu"
$ !
$UPDATE_NODES:					! Entry for loop head
$	n=0
$UPDATE_NODE:
$	dsk=f$element(n,"|",P3)			! Get the next disk from list
$	n=n+1					! bump pointer
$	if (dsk.eqs."" .or. dsk.eqs."|") then GoTo FINISH	! All  nodes
$	node=f$element(0,"$",dsk)		! Get target NODE name from disk
$	SAY	FAC+"I-UPDNOD, Updating node ''node'"
$	GOSUB CHECK_DISK			! Check disk presence
$	if (dsk.eqs."") then ERR FAC+"E-NODISK, Disk for ''node' not ready"
$	if (dsk.eqs."") then GoTo UPDATE_NODE	! Disk missing = skip it
$	dir="[LAVCDATA.LAVCCOM]"		! All LAVC common files
$	GOSUB	UPDATE_FILES			! Do update
$	dir="[LAVCDATA.''node']"		! All node specific files
$	GOSUB	UPDATE_FILES			! Do update
$	Open/Read/Err=GROUP_END file GRPLIST.TMP! Open our directory list
$GROUP_LOOP:
$	READ/End=GROUP_END file dir		! Get the next directory record
$	dir=f$element(1,"]",dir)		! Remove header info
$	dir="[LAVCDATA."+f$element(0,".",dir)+"]"! Make [LAVCDATA.GRPnnn]
$	GOSUB	UPDATE_FILES			! Do update
$	GoTo 	GROUP_LOOP			! Loop for next grp.dir
$GROUP_END:
$	CLOSE	file				! Close our file
$	GoTo	UPDATE_NODE			! Loop for next
$ !
$ ! *********************** Action Subroutines *************************
$ !
$ !  Data update subroutine currently does NOT warn if any files in
$ !  updates directories are "more current". Always uses "MASTER"
$ !  To prevent data loss in case of crash, we go file by file
$ !  instead deleting and re-loading the entire directory.
$ !  Since we do not want to transfer pending jobs from MASTER, we always
$ !  delete JBCSYSQUE.DAT, and NEVER copy it over.
$ !  Arguments: 
$ !     mas - master disk, dsk - target disk, dir - directory
$ !             
$UPDATE_FILES:
$	if f$search(dsk+dir+"*.*") .eqs. "" -	! No files on target yet
	   then GoTo UPDATE_COPY		! so skip cleaning
$	if f$search("''dsk'''dir'JBCSYSQUE.DAT") .nes. "" then -
	   DELETE/Noconfirm 'dsk''dir'JBCSYSQUE.DAT;*
$	PURGE   'dsk''dir'*.*			! Limit OUT files to one version
$	RENAME  'dsk''dir'*.*;0   *.*;1		! (require version 1)
$UPDATE_CLEAN:
$	nam=f$search(dsk+dir+"*.*",1)		! Find next file in output dir
$	if nam .eqs. "" then GoTo UPDATE_COPY	! No more files in output dir.
$	fil=f$par(nam,,,"NAME")+f$par(nam,,,"TYPE") ! get file name and type
$	if f$search(mas+dir+fil,2) .eqs. "" -	! Master does not have such one
	   then delete/noconfirm/log 'nam	! se delete it
$	GoTo UPDATE_CLEAN			! Go for next file
$UPDATE_COPY:
$	BACKUP/Ignore=(Interlock) -		! Use BACKUP
		/Exclude=(JBCSYSQUE.DAT) -	! Don't try to copy queue file
		'mas''dir'*.*;0 -		! Preserve all file attributes
		'dsk''dir'*.*;0/Overlay/Own=ORIG
$	RETURN
$ !
$ !  Disk accessibility cheking subroutine (argument = dsk, updated)
$ !
$CHECK_DISK:
$	if .not. f$getdvi(dsk,"EXISTS")     then GoTo NO_DISK
$	if .not. f$getdvi(dsk,"MNT")        then GoTo NO_DISK
$	if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NO_DISK
$	dsk=f$getdvi(dsk,"FULLDEVNAM")		! Get exact device name
$	RETURN
$NO_DISK:
$	dsk=""					! Flag disk not available
$	RETURN
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	if f$search("GRPLIST.TMP") .nes. "" then DELETE GRPLIST.TMP;*
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	if f$search("GRPLIST.TMP") .nes. "" then DELETE GRPLIST.TMP;*
$	Verify = f$verify(Verify)
$	Exit %X10000004
