$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMDSKRBL.COM - REBUILD all the LAVC disks
$ ! Facility: ATTC LAVC System Management
$ ! Purpose:  Procedure used to rebuild all the LAVC disks
$ !	      (assumes batch, midnight execution)
$ !	      LATER, this procedure may use DISKKEEPER to de-fragment
$ !	      those disks as well
$ ! Notes:    Since we mount most of the disks in LAVC with /NOREBUILD
$ !	      qualifier, we MUST do the rebuild sometimes. This procedure
$ !	      is intended to run at midnights, and do what's necessary.
$ !	     
$ !	      The procedure uses SHOW CLUSTER to get nodes available
$ !	      in the cluster, and LAVCDISKS.COM to do the rebuilds.
$ !	      It assumes ALL nodes have node$BATCH queue available.
$ !	      Several provisions are used to:
$ !		- prevent rebuilds from running LATE after scheduled
$ !		- prevent leaving multiple rebuilds in any queue
$ ! History:
$ ! 02/10/88,MXB,Coding started
$ !
$ ! Arguments:
$ !	P1 = SUBMIT	(RE)submit itselves
$ !
$ ! ********************************************************************
$START:
$	Set NoOn
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error"
$	FAC="%DSKRBL-"
$	STS=1					! Standard status
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ !	If P4=SUBMIT, procedure (RE) submits itself int LAVC$MGR queue
$RESUBMIT:
$	if f$extr(0,3,P1) .nes. "SUB" then GoTo REB000
$	wait 00:00:30				! Avoid cluster time problem
$	if f$search(   "sys$manager:MGMDSKRBL.LOG") .nes. "" then -
   	PURGE /Keep=3   sys$manager:MGMDSKRBL.LOG
$	SUBMIT/Keep/Log=sys$manager:MGMDSKRBL.LOG -
	      /Para=("''p1'","''p2'","''p3'","''p4'") -
	      /After="TOMORROW+02:00:00" -	! Resubmit self
              /User=SYSTEM/Que=LAVC$MGR	-	! using SYSTEM account
	      'f$elem(0,";",f$environment("PROCEDURE"))
$ !
$ ! *********************** MASTER REBUILD *************************
$ !
$REB000:
$ !lavc$data:[LAVCCOM]LAVCDISKS DEFRAG  * "/LOG"! Defragment ALL disks (not avl)
$ @lavc$data:[LAVCCOM]LAVCDISKS REBUILD * "/LOG"! Rebuild ALL disks
$ !						! FROM CURRENT NODE
$ SHO PROC /ACC					! Display costs
$ !
$ ! ********************* LAVC MEMBERS REBUILDS ********************
$ !
$ !	The MASTER REBUILD re-builds disk data structures on disks
$ !	and caches on MASTER. At this point, it seems NOT to update
$ !	caches for OTHER nodes in LAVC. Therefor, we try to do the
$ !	same thing for EVERY node present in cluster.
$ !
$ !	Build list of nodes present NOW, then process node by node
$ !
$ 	SHO CLUSTER/OUT=NODELIST.TMP;0
$ 	OPEN/ERR=REB050  XXX  NODELIST.TMP;0
$REB010:READ/END=REB040 XXX recrd
$ 	recrd = f$edit(recrd,"COMPRESS,UPCASE,TRIM")
$ 	node  = f$element(1," ",recrd)		! Get node name from listing
$	if node .eqs. " " then $ GoTo REB010	! Invalid name
$ 	if f$len(node) .gt. 6 then GoTo REB010	! Invalid name (some -----'s)
$ 	if .not. f$getsyi("CLUSTER_MEMBER",node) then GoTo REB010
$ !
$	SAY FAC+"I-PRCNOD, Processing node ''node'"
$	
$ ! 	First make sure no other submitted jobs are pending in the queue
$	BATQUE = node+"$BATCH"				! Node specific queue
$ 	ASSIGN/USER BATCHES.TMP SYS$OUTPUT		! 
$ 	SHO QUE 'BATQUE' /ALL				! List queue
$	if .not.$status then $ GoTo REB035		! Error = skip
$ 	OPEN/READ/ERR=REB035 YYY BATCHES.TMP		! Kill any old MGMDSKRBL
$REB020:READ/END=REB030 YYY X				! jobs laying around
$ 	if f$locate("NODEDSKRBL",X) .eq. f$len(X) then GoTo REB020
$ 	if f$locate("Executing" ,X) .ne. f$len(X) then GoTo REB020
$ 	job=f$edit(f$extract(30,7,x),"COLLAPSE")	! Get entry #
$ 	DELETE/ENTRY='job' 'BATQUE'			! Kill this entry
$ 	GoTo REB020
$REB030:CLOSE YYY
$ 	if f$search("BATCHES.TMP" ) .nes. "" then DELETE BATCHES.TMP;*
$	killtime=f$cvt("+02:00:00","ABSOLUTE")		! Allow start NOW+2hrs
$	SUBMIT/USER=SYSTEM/NAME=NODEDSKRBL/QUE='BATQUE'-! Submit "node" rebuild
	  /Param=(REBUILD,"*","/LOG","''killtime'") -	! LAVCDISKS time limit
	  lavc$data:[LAVCCOM]LAVCDISKS.COM /Print/NoKeep! 
$	WAIT 00:03:00					! Let this node complete
$	GoTo REB010					! Loop for next
$REB035:ERR FAC+"E-OPNQLS, Error getting queue listing file, ''node' skipped"
$	GoTo REB010	
$ !
$REB040:CLOSE XXX					! Close tmp.file
$	GoTo FINISH					! Done
$
$REB050:ERR FAC+"E-OPNERR, Error opening NODELIST.TMP"	! Report error
$	GoTo FATERR					!
$ !             
$ !
$ ! ************************** TERMINATION *************************
$FINISH:
$	if f$search("NODELIST.TMP") .nes. "" then DELETE NODELIST.TMP;*
$ 	if f$search("BATCHES.TMP" ) .nes. "" then DELETE BATCHES.TMP;*
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	if f$logica("XXX") .nes. "" then CLOSE XXX
$	if f$logica("YYY") .nes. "" then CLOSE YYY
$	if f$search("NODELIST.TMP") .nes. "" then DELETE NODELIST.TMP;*
$ 	if f$search("BATCHES.TMP" ) .nes. "" then DELETE BATCHES.TMP;*
$	Verify = f$verify(Verify)
$	Exit %X10000004
