$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMDSKUSE.COM - Disk USAGE monitor command file
$ ! Facility: ATTC LAVC System Management
$ ! Purpose:  Procedure used to monitor disks usage on periodic basis
$ ! Notes:    Procedure contains hardcoded pointer to the VUS programm
$ ! History:
$ ! 07/30/87,MXB,Coding started
$ !
$ ! Arguments:
$ !
$ !	P1	Options: SUBMIT (after=tomorrow) 
$ !		or "node" name for node which we want to see
$ !		or "node$ddcu" for disk we want to see
$ !
$ ! ********************************************************************
$START:	Set NoOn
$	On control_Y then GoTo FINISH
$	VUS  = "$wkswrk:[MARBRU.VUS]VUS"	! VUS programm
$	page[0,8]=12				! Form feed to force new page
$	if f$mode() .eqs. "INTERACTIVE" then page = ""	! No pages on terminals
$ !
$ !	If P1=SUBMIT, procedure (RE) submits itself int LAVC$MGR queue
$ !
$	if f$extr(0,3,P1) .nes. "SUB" then GoTo GET10
$ !	wait 00:00:30				! Avoid cluster time problem
$	if f$search(   "sys$manager:MGMDSKUSE.LOG") .nes. "" then -
   	PURGE /Keep=3   sys$manager:MGMDSKUSE.LOG
$	SUBMIT/Keep/Log=sys$manager:MGMDSKUSE.LOG -
	      /Para=("''p1'") -			! Propagate "SUBMIT"
	      /After="TOMORROW" -		! Resubmit self
              /User=SYSTEM/Que=LAVC$MGR	-	! using SYSTEM account
	      'f$elem(0,";",f$environment("PROCEDURE"))
$	P1 = ""					! Make P1 empty = default run
$ !
$ !	Get a listing of all the disk drives available:
$ !
$GET10:
$	node = f$element(0,"$",p1)		! Process P1 argument to get
$	devi = f$element(1,"$",p1)		! valid option for
$	if node .nes. ""  then node = node +"$"	! SHOW DEVICE
$	if f$loc("D",devi) .eq. f$len(devi) then devi = "D"
$	if devi .eqs. "$" then devi = "D"	!
$	On control_Y then GoTo FINISH
$ !	
$	assign/User devlist.tmp sys$output	! Use temporrary file
$ 	sho dev/mount 'node''devi'	 	! All mounted drives
$	if .not. $status then GoTo Finish	! No drives found = done
$ !
$ !	Process all those drives listed
$ !
$	inpu = "/NOINP"			 	! No VUS summary input file yet	
$	zero = "/ZERO"				! Zeroe VUS cumulatives first 
$ !
$	open/read f devlist.tmp			! Open file with disk names
$	On control_Y then GoTo LOP20
$LOP10:	read/end=LOP20  f  recrd
$	if f$loc(":",recrd) .eq. f$len(recrd) then GoTo LOP10	! No device
$ 	dsk = f$element(0,":",recrd)+":"		! Get disk name, skip "bad" ones
$	if .not. f$getdvi(dsk,"HOST_AVAIL") .and. -
       	   .not. f$getdvi(dsk,"ALT_HOST_AVAIL") then GoTo LOP10
$ !
$	VUS 'dsk'/PROC/LIST/NOFULL/VOL/NOUPD'zero''inpu'/OUTPUT	! process disk
$	Purge VOLSTAT.DAT			! keep last version only
$	inpu = "/INPUT"				! now we have input file 
$	zero = "/NOZER"				! now we don't zero cumulatives
$	GoTo LOP10				! try next disk
$ !
$ !	Generate the cumulative listing, using VUSD in non-processing mode
$ !
$LOP20:	Close f					! Close and delete disk list 
$	On control_Y then GoTo FINISH		! allow to kill
$	Delete/Noconf devlist.tmp;*		! and generate summary usage 
$	VUS 'dsk'/NOPROC/FULL/NOSUM/NOZER/UPDATE/INPUT/NOOUTPUT/LIST=USAGE.LIS
$	if f$mode() .nes. "INTERACTIVE" then Sho proc/acc ! display our costs
$	SORT /KEY=(POS:1,SIZE:20,CHAR) USAGE.LIS USAGE.LIS
$	write sys$output page			! Start new page
$	type USAGE.LIS;0			! and print detailed usage
$ !
$ !	Generate group summary statistics from sorted file
$ !
$	write sys$output  page			! Start a new page
$	Open/read f USAGE.LIS			! Read sorted file
$	On control_Y then GoTo GRP50
$	sgrp = ""				! No group summary yet
$GRP20:	Read/end=GRP50 f recrd
$	cgrp = f$element(0,",",recrd)+"]"	! Current group
$	curr = f$element(3,":",recrd)		! Current usage record
$	if curr .eqs. ":" then GoTo GRP20	! invalid - skip
$	if cgrp .eqs. sgrp  then GoTo GRP40	! Group matches, cumulate
$	if sgrp .eqs. "" then GoTo GRP30	! No summary to print
$	x=f$fao("!8<!AS!> !5UL Dir   !6UL Fil  !9UL Blk",sgrp,sdir,sfil,sblk)
$	write sys$output x			! print previous group
$GRP30:
$	sgrp = cgrp				! New group
$	sdir = 0				! Init counters
$	sfil = 0
$	sblk = 0
$GRP40:
$	sdir = sdir + f$integer(f$extract (00,3,curr))	! Update summaries
$	sfil = sfil + f$integer(f$extract (07,5,curr))
$	sblk = sblk + f$integer(f$extract (16,8,curr))
$	GoTo GRP20
$ !
$GRP50:	Close f
$	if sgrp .eqs. "" then GoTo GRP60	! No summary left
$	x=f$fao("!8<!AS!> !5UL Dir   !6UL Fil  !9UL Blk",sgrp,sdir,sfil,sblk)
$	write sys$output x
$GRP60:
$	delete USAGE.LIS;*			! Delete our usage file
$ !
$ !	 Finished
$FINISH:
$	verify = f$verify(verify)	! Restore verification
