$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMOPRLOG.COM - Maintain LAVC OPERATOR.LOG files for Self-booting LAVC nodes
$ ! Facility: ATTC LAVC System Management
$ ! Purpose:  Procedure used to propagate OPERATOR.LOG file from
$ !		LAVC nodes to archival area & purge old copies
$ ! Notes:    Procedure contains hardcoded DEFAULTS for ATTC LAVC
$ !	      Workstations that have log file on boot node not done
$ ! History:
$ ! 	Dec 87, -db, Coding started...using MGMUPD as a template
$ !
$ ! Arguments:
$ !
$ !	P1	Source (target) disk 		    "node$ddcu"
$ !	P2	List of full node's disks to cleanup "node$ddcu|node$ddcu"
$ !	P3	Options: SUBMIT (after=tomorrow+02:00:00)
$ !
$ ! ********************************************************************
$START:
$	Set NoOn
$	if P1 .eqs. "" then P1 = "CHICO$DUA4:"	! Default Target node
$	if P2 .eqs. "" then -
   	   P2 = "WAGNER$DUA0|HAYDEN$DUA0|CHOPIN$DUA0|"+ -
                "MOZART$DUA0|STRAUS$DUA0|BACH$DUA0|" + -
		"LISZT$DUA0|EDISON$DUA0|"
$	if P2 .eqs. "NONE" then P2 = ""		! Allow explicit NONE
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error
$	FAC="%OPRLOG-"
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ !	If P3=SUBMIT, procedure (RE) submits itself int LAVC$MGR queue
$RESUBMIT:
$	if f$extr(0,3,P3) .nes. "SUB" then GoTo CHECK_TARGET
$!	wait 00:00:30				! Avoid cluster time problem
$	if f$search(   "sys$manager:MGMOPRLOG.LOG") .nes. "" then -
   	PURGE /Keep=3   sys$manager:MGMOPRLOG.LOG
$	SUBMIT/Keep/Log=sys$manager:MGMOPRLOG.LOG -
	      /Para=("''p1'","''p2'","''p3'") -
	      /After="TOMORROW+02:00:00" -	! Resubmit self
              /User=SYSTEM/Que=LAVC$MGR	-	! using SYSTEM account
	      'f$elem(0,";",f$environment("PROCEDURE"))
$ !
$CHECK_TARGET:
$ 	dsk=P1					! Check TARGET disk presence
$ 	GOSUB CHECK_DISK				
$ 	if dsk .eqs. "" then ERR FAC+"F-NOTARGET , Target disk ''p1' not ready"
$ 	if dsk .eqs. "" then GoTo FATERR
$	mas=dsk					! Save target disk device name
$ !
$ ! *********************** MEMBER NODES CLEANUP *************************
$ !
$ !  Local node's LAVC database cleanup is based on the list of disk names
$ !  in argument P2 using form: "node$ddcu|node$ddcu|node$ddcu"
$ !
$CLEANUP_NODES:					! Entry for loop head
$	n=0
$CLEANUP_NODE:
$	dsk=f$element(n,"|",P2)			! Get the next disk from list
$	n=n+1					! bump pointer
$	if (dsk.eqs."" .or. dsk.eqs."|") then GoTo FINISH	! All  nodes
$	node=f$element(0,"$",dsk)		! Get target NODE name from disk
$	SAY	FAC+"I-UPDNOD, Updating node ''node'"
$	GOSUB CHECK_DISK			! Check disk presence
$	if (dsk.eqs."") then ERR FAC+"E-NODISK, Disk for ''node' not ready"
$	if (dsk.eqs."") then GoTo CLEANUP_NODE	! Disk missing = skip it
$	target="[ARCHIVE]"			! where to put log files
$	source="''dsk'[SYS0.SYSMGR]"		! All node specific files
$	GOSUB	MOVE_FILES			! Do cleanup
$ !
$ ! *********************** Action Subroutines *************************
$ !
$ !  Arguments: 
$ !     target - target of copy, node - source node, source - source of copy
$ !             
$MOVE_FILES:
$	if f$search(dsk+dir+"*.*") .eqs. "" -	! No files on target yet
	   then GoTo CLEANUP_COPY		! so skip cleaning
$	COPY	'source'OPERATOR.LOG;* -
	     -  'target''node'operator.log;*	! 
$	PURGE   'dsk''dir'*.*			! Limit OUT files to one version
$ !
$ !  Disk accessibility cheking subroutine (argument = dsk, cleanup)
$ !
$CHECK_DISK:
$	if .not. f$getdvi(dsk,"EXISTS")     then GoTo NO_DISK
$	if .not. f$getdvi(dsk,"MNT")        then GoTo NO_DISK
$	if .not. f$getdvi(dsk,"HOST_AVAIL") then GoTo NO_DISK
$	dsk=f$getdvi(dsk,"FULLDEVNAM")		! Get exact device name
$	RETURN
$NO_DISK:
$	dsk=""					! Flag disk not available
$	RETURN
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	if f$search("GRPLIST.TMP") .nes. "" then DELETE GRPLIST.TMP;*
$	Verify = f$verify(Verify)
$	Exit %X10000004
