$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ !
$ ! MGMQUESTA.COM - (RE)START LAVC QUEUES
$ ! Facility: ATTC LVAC System Management
$ ! Purpose:  Restart the LAVC queue system, if necessary
$ !	      (Que manager dies/locks for some reason)
$ !	      Typically used when the JBCSYSQUE.DAT becomes unaccessible
$ !	      due to server node hang-up (then it has to be executed
$ !	      on each node which re-assigned JBCSYSQUE logical)
$ ! Notes:    This procedure explicitly KILLS JOBCTL process and any
$ !	      print symbionts laying around, to allow for restart.
$ !	      See MGMREMCMD to execute CMD on multiple nodes.
$ ! History:
$ ! 05/20/87,MXB,Kill all symbionts along with JOBCTL (they don't die othervise)
$ ! 04/08/87,MXB,Coding started
$ !
$ 	Set NoOn
$	Set Proc/Privs=ALL			! Force all privileges
$	savuic=f$user()				! Save UIC
$	Set UIC [1,4]				! Set to system
$	Stop JOB_CONTROL			! Stop  the JOB controller
$	CNTX=""					! Init loop context
$KILL_LOOP:
$	PID=f$PID(CNTX)				! Get next PID
$	if PID .nes. "" then -			! Valid PID
           if f$extract(0,9,f$getjpi(PID,"PRCNAM")).eqs."SYMBIONT_" then -
	      Stop/Ide='PID'			! Kill "SYMBIONT_nnn
$	if PID .nes. "" then GoTo KILL_LOOP	! Loop for next
$	@sys$system:STARTUP.COM JOBCTL		! Start the JOB controller
$	@lavc$data:[LAVCCOM]LAVCPRINT.COM	! Start print queues
$	@lavc$data:[LAVCCOM]LAVCBATCH.COM	! Start batch queues
$FINISH:
$ 	Set UIC 'savuic'			! reset UIC
$	Verify = f$verify(Verify)
$	Exit
