$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !
$ ! MGMSYSCPY.COM - SYSTEM COPY TO ANOTHER LAVC NODE
$ ! Facility: ATTC LVAC System Management
$ ! Purpose:  Procedure used to build a VMS system disk on another
$ !	      LAVC member node. Assumed this node is booted DISKLESS
$ !	      (or from another disk), procedure copies required VMS
$ !	      (sub)set to prescribed system disk, and prepares everything
$ !	      for the first boot.
$ ! Notes:    
$ !	MGMSYSCPY.COM MUST be be revised on each VMS and VWS software release 
$ !	to make sure harcoded LAVC sysgen  parameter requirements
$ !	(for initial boot and AUTOGEN)  are up-to-date.
$ !	If BACKUP option is used, make sure your source system tree is
$ !	cleaned-up (no garbage).
$ !	If the TARGET disk is not MOUNTED, procedure will INITIALIZE it !
$ !	Procedure now allows to sneak-in a new VMS$COMMON onto a disk
$ !	with existing roots [SYSn]. Only [SYS0]SYSCOMMN alias is updated,
$ !	since we may have even more VMS versions on one disk.
$ !	
$ !	Procedure contains hardcoded ATTC LAVC GROUP number and PASSWORD
$ !	     
$ ! History:
$ ! 10/12/88,MXB,Minor enhancements
$ ! 07/06/88,MXB,Upgrade to VMS 5.0 NOTE, VMSKITBLD use not worked out yet
$ !		 Major changes in the entire code
$ ! 10/31/87,MXB,Removed SYSGEN parameters coputed by VMS 4.6 AUTOGEN
$ ! 06/17/87,MXB,Boosted min_processcnt to 24, raised initial SPTREQ, no PHY
$ ! 05/14/87,MXB,Updated, removed QDSS/QVSS code (handled by AUTOGEN 4.5 C)
$ ! 02/25/87,MXB,Initial setup for VMS 4.5 
$ !
$ ! Arguments:
$ !
$ !	P1	Source VMS system root device (Full VMS system assumed)
$ !
$ !	P2	Target VMS system root device (Cluster layout will be created)
$ !		If not mounted, device will be INITIALIZED !!!!!!!
$ !
$ !	P3	Target system node name
$ !
$ !	P4	Target system DECNET node id (nn.nn)
$ !
$ !	P5	Required VMS subset, components and configuration:
$ !		either: BACKUP ( copies the entire sys$common tree )
$ !	        or:     one of:        ALL,REQ,LIB,OPT (VMS save-set)
$ !		        combined with: UETP,HELP,FORT,DNET [,UIS,CCC]
$ !
$ !		note:   support for UIS and CCC (vaxC) copy should be
$ !		        added later (not presnt in standard VMSKITBLD.DAT)
$ !		       
$ !	P6	VMSKITBLD control file (default=VMSKITBLD.DAT)
$ !
$ !	P7	Target system PAGE:SWAP:DUMP files sizes
$ !		default = none (use VMS minimums)
$ !
$ !	P8	Number of cluster members (default = 24)
$ !
$ ! The procedure:
$ !	(1)	Performs a copy of the VMS system to target disk.
$ !		Depending on options P5, either BACKUP or VMSKITBLD is used
$ !	(2)	Creates system root SYS0. If SYS0 already exists, the
$ !		SYSCOMMON alias is updated, and new STARTUP1 and MODPARAMS.DAT
$ !		supersede previous. PAGE/SWAP files are adjusted
$ !	(3)	Creates files needed for initial system operation:
$ !		- SYSUAF.DAT with SYSTEM/MANAGER account
$ !		- PAGEFILE.SYS,SWAPFILE.SYS,SYSDUMP.DMP
$ !		- VAXVMSSYS.PAR with DEFAULT sysgen parameters, SYSTARTUP1.COM
$ !		- MODPARAMS.DAT with initial setting
$ !		- STARTUP1.COM to perform AUTOGEN (and NETCONFIG for new SYS0)
$ !		Runs SYSMAN SET CLUSTER_AUTHORIZE on target disk
$ !	(4)	Copies LAVC$DATA files:
$ !		- [LAVCCOMM] - all the common cluster files
$ !		- [node] - node specific files, if available
$ !
$START:
$	Set NoOn
$	Set UIC [1,4]				! Make sure running under SYSTEM
$	LAVCGRP=305				! LAVC GROUP NUMBER  (ATTC TEST)
$	LAVCPWD="ATTCRD"			! LAVC PASSWORD      (ATTC R&D)
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error
$	FAC="%SYSCPY-"
$	STS=1					! Standard status
$	ready = "YES"				! Assume target was ready
$	ROOT0 = 0				! Assume no SYS0 root present
$	SAY FAC+"I-RNOTES, Please, read NOTES in procedure header"
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ ! Argument inquiry:
$ !
$GETSRC:
$	x = f$log("sys$sysdevice")
$	if P1 .eqs. "" then INQUIRE p1 "* Source device holding  VMS tree [''x'] "
	if P1 .eqs. "" then P1 = x
$GETTGT:
$	if P2 .eqs. "" then INQUIRE p2 "* Target device for LAVC VMS tree [node$ddcu:] "
$	if p2 .eqs. "" then GoTo GETTGT
$GETNOD:
$	if P3 .eqs. "" then INQUIRE p3 "* DECNET node name [1-6 characters] "
$	if P3 .eqs. "" then GoTo GETNOD
$	node=f$extract(0,6,f$edit(P3,"COLLAPSE"))
$GETADR:
$	if P4 .eqs. "" then INQUIRE p4 "* DECNET node address [area.number] "
$	if P4 .eqs. "" then GoTo GETADR
$	P4="''p4'"
$	if f$loc(".",P4) .eq. f$len(P4) then P4="1."+P4
$	if f$loc(".",P4) .eq. 0 then P4="1"+p4
$	SCSSYSTEMID=1024*0'f$element(0,".",P4) + 0'f$element(1,".",P4)
$	dnetadr = P4
$GETOPT:
$	if p5 .eqs. "" Then INQUIRE p5 "* COPY options [BACkup or ALL,FOR ] "
$	if P5 .eqs. "" then P5 = "BACKUP"
$	if p5 .eqs. "" then Goto GETOPT
$GETKIT:
$ 	if f$loc("BAC",P5) .ne. f$len(P5) then GoTo GETSIZ
$	x=f$search("sys$update:VMSKITBLD.DAT")
$	if P6 .eqs. "" then INQUIRE p6 "* VMSKITBLD data file [''x'] "
	if p6 .eqs. "" then P6 = x
	if f$searech(p6) .eqs. "" then P6 = ""
	if f$searech(p6) .eqs. "" then GoTo GETKIT
$GETSIZ:
$	if P7 .eqs. "" then INQUIRE p7 "* Size for PGF:SWF:DMP [4604,1000,0] "
$	if P7 .eqs. "" then P7="4604:1000:0"		! Default minimum sizes
$	P7=P7+",0,0,0"					! default missing value
$	PFSIZ=0'f$element(0,",",P7)			! Get pagefile size
$	SWSIZ=0'f$element(1,",",P7)			! Get pagefile size
$	DMSIZ=0'f$element(2,",",P7)			! Get pagefile size
$GETMEM:
$	if P8 .eqs. "" then INQUIRE p8 "* Expected Cluster Members  [0 - nn] "
$	if P8 .eqs. "" then P8 = "0"
$	NM=f$integer(P8)				! Make numeric sym.
$ !
$ ! ************************* VMS SYSTEM FILES MOVE *************************
$ !
$ ! Check the target device. If not mounted, will be initialized !
$ !
$DEVCHK:
$ 	if f$getdvi(P1,"EXISTS") then -
  	if f$getdvi(P1,"MNT") then GoTo DEVCHK0
$	ERR FAC+"F-NOTEXI, Source device does not exist, or not mounted: "+p1
$	GoTo FATERR
$DEVCHK0:
$	if f$getdvi(P2,"EXISTS") then Goto DEVCHK1
$	ERR fac+"F-NOTEXI, Target root device does NOT exist: "+p2
$	Goto FATERR
$DEVCHK1:
$	ready=f$getdvi(P2,"MNT")			! Get device readiness state
$	if .not. ready then SAY fac+"I-TGTINI, Target device will be INITIALIZED "
$DEVCHK2:
$	inpdev=f$getdvi(P1,"FULLDEVNAM")		! Get full input device name
$	outdev=f$getdvi(p2,"FULLDEVNAM")		! Get full output device name
$ !
$ !  ******************    SYSTEM COPY USING BACKUP   *********************
$ ! 
$ ! 	System common tree copy using BACKUP ( not using VMSKITBLD )
$ !	Here we have to emulate some of the VMSKITBLD functions,
$ !	since BACKUP only copies basic system tree (does not create
$ !	any directory aliases). We use [VMS$COMMON] tree on the source.
$ !
$VMSBCK:
$	if f$loc("FIL",P5) .ne. f$len(P5) then Goto MAKEFIL
$	if f$loc("BAC",P5) .eq. f$len(P5) then Goto VMSCOP
$	SAY FAC+"I-BACKUP, Backup of the entire system tree selected"
$	SRCROOT="VMS$COMMON"
$	if .not. f$getdvi(outdev,"MNT") then Goto VMSBCK0
$ !	Make sure mounted device does not have VMS system on it
$	If f$sea("''outdev'[000000]''SRCROOT'.dir") .EQS. "" .and. -
	   f$sea("''outdev'[000000]SYS0.dir")       .EQS. "" .and. -
	   f$sea("''outdev'[000000]SYSEXE.dir")     .EQS. "" .and. -
	   f$sea("''outdev'[000000]SYSMAINT.dir")   .EQS. "" then GoTo VMSBCK1
$	ERR  FAC+"F-DIREXI, System directory found on target device"
$	inquire YN "Do you want to continue [NO]"
$	if YN .eqs. "" then GoTo FATERR			! Default = give up
$	if YN then GoTo VMSBCK1
$	GoTo FATERR
$VMSBCK0:
$	Allocate 'outdev				! Allocate device
$	INIT 'outdev'/Sys 'node'_SYS			! Initialize it
$	Dealloc  'outdev				! 
$	MOUNT/System 'outdev 'node'_SYS			! and mount
$VMSBCK1:
$	if f$search("''outdev'[VMS$COMMON]*.*") .nes. ""
$	then
$	  SAY FAC+"W-EXISTS, VMS$COMMON already exists, skipping BACKUP !"
$	  goto ROOTSET
$	endif
$	SAY FAC+"I-BACKUP, Backup of [''SRCROOT'...] tree started  "+f$time()
$	BACKUP/IGNORE=INTER/VERIFY -
	/Exclude=(PAGEFILE.SYS,SWAPFILE.SYS,SYSDUMP.DMP,JBCSYSQUE.DAT,*.LOG,ACCOUNTNG.DAT) -
	'inpdev'['SRCROOT'...]*.*;0 'outdev'[*...]/Own=ORIG
$	sts=$Status
$	SAY FAC+"I-BACKUP, Backup of [''SRCROOT'...] tree finished "+f$time()
$	if (sts.and.4).eq.4 then Goto FATERR		! Fatal Error occured, damned
$ !
$ ! The following directory operations are reminder of the old VMS times ....
$ ! 	(but still seem to be necessary):
$	SAY FAC+"I-CRALIA, Creating [SYSEXE]SYSBOOT.EXE alias "
$	CREATE/DIR/PROT=(S=RWE,O=RWE,G=RWE,W=RE) 'outdev'[SYSEXE]
$	SET FILE/ENTER='outdev'[SYSEXE]SYSBOOT.EXE -
		       'outdev'[VMS$COMMON.SYSEXE]SYSBOOT.EXE
$	if .not. $status then -
	   ERR FAC+"E-NOBOOT, SYSBOOT entry failed, ''outdev' may not be bootable"
$ !
$ ! Write boot block to the new device:
$ !	(not needed except for 11/750. does not work on uVAXes)
$ 	x=f$search("''outdev'[VMS$COMMON.SYSEXE]VMB.EXE")
$	if x .eqs. "" then ERR FAC+"F-VMBNEX, VMB does not exist on "+outdev
$	if x .eqs. "" then Goto FATERR
$	SAY FAC+"I-WRBOOT, Writing BOOT block to the ''outdev'"
$	Assign/User 'outdev'[VMS$COMMON.SYSEXE] VMBDIR
$	Run sys$system:WRITEBOOT.EXE
VMBDIR:VMB.EXE
1
200
$	if .not. $status then -
	   ERR FAC+"E-WRBOOT, WRITEBOOT failed, ''outdev' not bootable on 11/750"
$	GoTo ROOTSET
$ !
$ !  ******************    SYSTEM COPY USING VMSKITBLD *********************
$ !
$ !  	Here we support VMSKITBLD "BUILD", "ADD" or "COPY" depending on the
$ !	target disk contents:
$VMSCOP:
$ !	Determine  operation to perform
$	oper="BUILD"					! Assume VMSKIT BUILD 
$	if .not. ready then GoTo VMSCOP1		! on non-mounted disk
$	oper="ADD"					! Ready = will be ADD
$	if f$search("''outdev:[SYS0]*.*")) .nes. "" then oper="COPY"

$	if f$search("''outdev:[SYS0]*.*")) .nes. "" then -
	   ERR FAC+"W-TGTEXI, Target [SYS0] already exists, COPY performed"
$VMSCOP1:
$	if oper .eqs. "BUILD" then SAY FAC+"I-VMSBLD, Building new VMS"
$	if oper .eqs. "ADD"   then SAY FAC+"I-VMSADD, Adding new [SYS0...] VMS tree"
$	if oper .eqs. "COPY"  then -
	   ERR FAC+"W-VMSEXI, Copying VMS to existing [SYS0...] tree"
$ ! Find copy control file
$	file=f$search(P6)				! Check kit bld file
$	if file .eqs. "" then ERR FAC+"F-KITBLD, VMSKITBLD data file missing: "+P6
$	if file .eqs. "" then GoTo FATERR
$ ! Find source VMS tree
$	inproot="''inpdev'[vms$common]
$ ! Determine conditionally moved files
$	n=f$len(P5)
$	mask=0						! No add-on files
$	if f$loc(P5,"UET") .ne. n then mask=mask+1	! Move UETP files
$	if f$loc(P5,"DNE") .ne. n then mask=mask+64	! Move DECNET files
$	if f$loc(P5,"FOR") .ne. n then mask=mask+16	! Move FORTRAN files
$	if f$loc(P5,"CCC") .ne. n then mask=mask+0	! (*Move VAX "C" files)
$	if f$loc(P5,"UIS") .ne. n then mask=mask+0	! (*Move UIS files)
$ ! Perform actual copy or build
$	SAY FAC+"I-COPVMS, Copy from ''inproot'tree started  "+f$time()
$	if f$loc(P5,"ALL") .ne. n then @sys$update:VMSKITBLD -
 	   'file 'mask 'inproot 'outdev''node'_SYS[SYS0] ALL "" 'oper NOPROMPT
$	if f$loc(P5,"ALL") .ne. n then GoTo VMSCOP3	! For ALL we are done
$	if f$loc(P5,"REQ") .ne. n then @sys$update:VMSKITBLD  -
 	   'file 'mask 'inproot 'outdev''node'_SYS[VMS$COMMON] REQ "" 'oper NOPROMPT
$	   if f$loc(P5,"REQ") .ne. n then oper = "COPY"	! Next will be ADD
$	if f$loc(P5,"LIB") .ne. n then @sys$update:VMSKITBLD -
 	   'file 'mask 'inproot 'outdev''node'_SYS[VMS$COMMON] LIB "" 'oper NOPROMPT
$	   if f$loc(P5,"LIB") .ne. n then oper = "COPY" ! Next will be ADD
$	if f$loc(P5,"OPT") .ne. n then @sys$update:VMSKITBLD -
 	   'file 'mask 'inproot 'outdev''node'_SYS[VMS$COMMON] OPT "" 'oper NOPROMPT
$VMSCOP3:
$ !	Several fix-up operations related to LAVC are performed here:
$ 	BACKUP/Ver/Repl 'inproot:[SYSEXE]PEDRIVER.EXE -
			'outdev'[VMS$COMMON.SYSEXE]/Own=orig
$ 	BACKUP/Ver/Repl 'inproot:[SYSEXE]CLUSTER_AUTHORIZE.DAT -
			'outdev'[SVMS$COMMON.SYSEXE]/Own=orig
$	
$	SAY FAC+"I-COPVMS, Copy from ''inproot'tree finished "+f$time()
$	if .not. f$getdvi(outdev,"MNT") then -
           ERR  FAC+"I-MOUTGT, Re-mounting target disk"
$	if .not. f$getdvi(outdev,"MNT") then MOUNT/System 'outdev' 'node'_SYS
$ !
$ ! ************* CONFIGURING TARGET AS CLUSTER DISK ********************
$ !
$ ! Create the system ROOT for the SYS0 tree, page/swap files etc
$ !
$ROOTSET:
$	if f$search("''outdev'[SYS0]*.*") .nes. "" 
$	then
$	   SAY FAC+"W-ROOT0, ''outdev'[SYS0] VMS root already exists"
$	   ROOT0 = 1				! Flag root presence
$	else
$	   SAY FAC+"I-ROOT0, Creating a new ''outdev'[SYS0] VMS root tree."
$	   CD = "CREATE/DIR/PROT=(S=RWE,O=RWE,G=RWE,W=RE) ''outdev'[SYS0"
$	   'CD]   		!Create SYS0 directory
$	   'CD.DECNET]
$	   'CD.MOM$SYSTEM]
$	   'CD.SYS$LDR]
$	   'CD.SYS$STARTUP]
$	   'CD.SYSCBI]
$	   'CD.SYSERR]
$	   'CD.SYSEXE]
$	   'CD.SYSFONT]
$	   'CD.SYSHLP]
$	   'CD.SYSHLP.EXAMPLES]
$	   'CD.SYSLIB]
$	   'CD.SYSMAINT]
$	   'CD.SYSMGR]
$	   'CD.SYSMSG]
$	   'CD.SYSTEST]
$	   'CD.SYSUPD]
$	endif
$	SET FILE /ENTER='outdev'[SYS0]SYSCOMMON.DIR 'outdev'[0,0]VMS$COMMON.DIR;
$ !
$ ! **************** PREPARE COPIED VMS SYSTEM FOR OPERATION *******************
$ !
$MAKEFIL:			! Make (build) necessary system files
$ !
$ ! 	Create basic, minimum AUTHORIZATION file
$ !
$	DEFINE/USER SYSUAF 'outdev'[VMS$COMMON.SYSEXE]SYSUAF.DAT
$	RUN SYS$SYSTEM:AUTHORIZE
ADD SYSTEM/UIC=[1,4]/PASSW=MANAGER/DEVI=SYS$SYSROOT:/DIRE=[SYSMGR]/PRIVS=ALL -
    /NOPWDLIFE/BYTLM=20480/PGFLQUO=20000/WSEXTENT=4096/JTQUOTA=1024/WSDEF=512
$	PURGE	  	'outdev'[VMS$COMMON.SYSEXE]SYSUAF.*
$ !
$ ! 	Page/swap file sizes update
$ !
$	SAY FAC+"I-FILSIZ, System file sizes PG=''PFSIZ', SW=''SWSIZ', DM=''DMSIZ'"
$	file=outdev+"[SYS0.SYSEXE]PAGEFILE.SYS
$	size=PFSIZ
$	GOSUB GENFILE					! Create pagefile
$	file=outdev+"[SYS0.SYSEXE]SWAPFILE.SYS
$	size=SWSIZ
$	GOSUB GENFILE					! Create swapfile
$	file=outdev+"[SYS0.SYSEXE]SYSDUMP.DMP
$	size=DMSIZ
$	GOSUB GENFILE					! Create dumpfile
$ !
$ ! Create VMS SYSGEN parameters  for a new system (refer to VMSKITBLD.COM)
$ !
$	OPEN /Write file SYS$SYSTEM:GENPAR.TMP
$	if .not.  $status then GoTo FATERR
$	Write file "$  RUN SYS$SYSTEM:SYSGEN"
$	Write file "USE DEFAULT			! Minimum VMS parameters"
$	Write file "SET VAXCLUSTER 0		! Turn off CLUSTER for uVMS"
$
$	Write file "SET /STARTUP=sys$system:STARTUP1.COM"
$	Write file "Write ''outdev'[SYS0.SYSEXE]VAXVMSSYS.PAR"
$	Write file "EXIT"
$	Write file "$ EXIT 1"
$	CLOSE file
$	@SYS$SYSTEM:GENPAR.TMP
$	DELETE SYS$SYSTEM:GENPAR.TMP;*
$	PURGE 'outdev'[SYS0.SYSEXE]VAXVMSSYS.PAR
$ !
$ ! Create initial AUTOGEN MODPARAMS.DAT file for  a new system
$ ! Any old one is renamed to an .OLD 
$ !
$	if f$search("''outdev'[SYS0.SYSEXE]MODPARAMS.DAT") then -
	   RENAME/LOG 'outdev'[SYS0.SYSEXE]MODPARAMS.DAT;0 *.OLD
$	CREATE 'outdev'[SYS0.SYSEXE]MODPARAMS.DAT
$	PURGE  'outdev'[SYS0.SYSEXE]MODPARAMS.DAT
$	OPEN /Append file 'outdev'[SYS0.SYSEXE]MODPARAMS.DAT
$	if .not.  $status then GoTo FATERR
$	user:='f$getjpi("","USERNAME")			! Name without blanks
$	tim  = f$time()					! Stamp: user, ddmmmyy
$	stamp=user+","+f$ext(0,2,tim)+f$ext(2,5,tim)+f$ext(9,2,tim)
$	Write file "! SYS$SPECIFIC:[SYSEXE]MODPARAMS.DAT"
$	Write file "! Site specific AUTOGEN data file.  In a VAXcluster where a common system"
$	Write file "! disk is being used, this file should reside in SYS$SPECIFIC:[SYSEXE],"
$	Write file "! not a common system directory."
$	Write file "! Add modifications that you wish to make to AUTOGEN's hardware configuration"
$	Write file "! data, system parameter calculations, and page, swap, and dump file sizes to "
$	Write file "! the bottom of this file.  "
$	Write file "! In ATTC LAVC, backup copy of this file should be maintained"
$	Write file "! in LAVC$DATA:[nodename]"
$	Write file "!"
$	Write file "! History:"
$	Write file "! DD-MMM-YYYY,who,comment"
$	Write file "! "+f$extract(0,11,f$time())+","+f$getjpi("","USERNAME")+", Created by MGMSYSCPY"
$	Write file "!"            
$	Write file "SCSNODE       	= ""''node'""  	! ''stamp' New node"
$	Write file "SCSSYSTEMID   	= ''SCSSYSTEMID'     	! ''stamp' added"
$	if NM .lt. 2 then GoTo MOD010
$	Write file "VAXCLUSTER    	= 2       	! ''stamp' LAVC member"
$	Write file "MSCP_LOAD       	= 1		! ''stamp' load server"
$	Write file "MSCP_SERVE_ALL  	= 2		! ''stamp' serve all"
$	Write file "NISCS_LOAD_PEA0 	= 1		! ''stamp' NI emulator"
$	Write file "NISCS_CONV_BOOT 	= 0		! ''stamp' prevent hackers"
$	Write file "VOTES           	= 0		! ''stamp' no votes"
$	Write file "EXPECTED_VOTES 	= 1		! ''stamp' min. cluster"
$	Write file "MVTIMEOUT     	= 10800 !3600	! ''stamp' ATTC boosted to 3 hr"
$MOD010:
$	Write file "!"
$	Write file "PAGEFILE      	= ''PFSIZ'     	! ''stamp' Created"
$	Write file "SWAPFILE      	= ''SWSIZ'     	! ''stamp' Created"
$	Write file "DUMPFILE      	= ''DMSIZ'     	! ''stamp' Created"
$	Write file "!"
$ 	Write file "MIN_MAXPROCESSCNT = 32		! ''stamp' ATTC LAVC minimum"
$	if NM .lt. 2 then GoTo MOD020
$ 	Write file "MIN_SRPCOUNT  	= ''NM'*30+600	! ''stamp' ATTC LAVC minimum"
$ 	Write file "MIN_IRPCOUNT  	= ''NM'*20+400	! ''stamp' ATTC LAVC minimum"
$ 	Write file "MIN_LRPCOUNT  	= 20		! ''stamp' ATTC LAVC minimum"
$ 	Write file "MIN_LOCKIDTBL 	= ''NM'*10+200	! ''stamp' ATTC LAVC minimum"
$ 	Write file "!"
$MOD020:
$	CLOSE file
$	PURGE 'outdev'[SYS0.SYSEXE]MODPARAMS.DAT
$ !
$ ! Set-up the CLUSTER authorization values
$ !
$CAFSET:
$	x=f$search("sys$system:SYSMAN.EXE")
$ 	if x .eqs. "" then ERR FAC+"E-SYSMAN, SYSMAN utility missing"
$	if x .eqs. "" then GoTo STASET
$	OPEN/Write file SYS$SYSTEM:CAF.TMP
$	if .not.  $status then GoTo FATERR
$	Write file "$DEFINE/USER SYS$OUTPUT NL:"
$	Write file "$DEFINE/USER SYS$SYSTEM ''outdev'[VMS$COMMON.SYSEXE]"
$	Write file "$RUN SYS$SYSTEM:SYSMAN
$	Write file "SET ENVIRONMENT/CLUSTER"
$	Write file "CONFIGURE SET CLUSTER_AUTHOR/GROUP=''LAVCGRP'/PASSWORD=''LAVCPWD'"
$	CLOSE file
$	@SYS$SYSTEM:CAF.TMP
$	DELETE/NOLOG SYS$SYSTEM:CAF.TMP.*
$ !
$ ! Create the initial system startup file (from CLUSTER_CONFIG.COM)
$ !
$STASET:
$ 	CREATE 'outdev'[SYS0.SYSEXE]STARTUP1.COM
$ 	OPEN/APPEND file 'outdev'[SYS0.SYSEXE]STARTUP1.COM
$	if .not.  $status then GoTo FATERR
$	q:="""
$	Write file "$ ! STARTUP1.COM - intitial startup file"
$	Write file "$ ver=f$verify(0)"
$	Write file "$ Write sys$output "+q+"STARTUP1.COM executing..."+q
$	Write file "$ Write sys$output "+q+"Start UPGRADE system ..."+q
$	Write file "$ set noon"
$	Write file "$root = f$getdvi(""SYS$SYSDEVICE"",""fulldevnam"") - ""_"""
$	Write file "$if f$trnlnm(""SYS$TOPSYS"",""LNM$SYSTEM"") .nes. """" then -"
$	Write file "root = root + ""<"" + f$trnlnm(""SYS$TOPSYS"",""LNM$SYSTEM"") + "".>"""
$	Write file "$define/system/exec/nolog/translation=(terminal,concealed) sys$specific 'root"
$	Write file "$no_common_root = f$search(""SYS$SPECIFIC:<000000>SYSCOMMON.DIR"") .eqs. """"
$	Write file "$if no_common_root then -"
$	Write file "define/system/exec/nolog/translation=(terminal,concealed) sys$sysroot 'root"
$	Write file "$if no_common_root then -"
$	Write file "define/system/exec/nolog/translation=(terminal,concealed) sys$common 'root"
$	Write file "$define/system/exec/nolog sys$sysdisk sys$sysroot:"
$	Write file "$define/system/exec/nolog sys$errorlog sys$sysroot:<syserr>"
$	Write file "$define/system/exec/nolog sys$examples sys$sysroot:<syshlp.examples>"
$	Write file "$define/system/exec/nolog sys$help sys$sysroot:<syshlp>"
$	Write file "$define/system/exec/nolog sys$instruction sys$sysroot:<syscbi>"
$	Write file "$define/system/exec/nolog sys$library sys$sysroot:<syslib>"
$	Write file "$define/system/exec/nolog sys$maintenance sys$sysroot:<sysmaint>"
$	Write file "$define/system/exec/nolog sys$manager sys$sysroot:<sysmgr>"
$	Write file "$define/system/exec/nolog sys$update sys$sysroot:<sysupd>"
$	Write file "$define/system/exec/nolog sys$test sys$sysroot:<systest>"
$	Write file "$define/system/exec/nolog sys$scratch sys$sysroot:<sysmgr>"
$	Write file "$define/system/exec/nolog sys$startup sys$sysroot:<sys$startup>,sys$manager"
$	Write file "$define/system/exec/nolog startup$startup_vms sys$startup:vms$vms.dat"
$	Write file "$define/system/exec/nolog startup$startup_layered sys$startup:vms$layered.dat"
$	Write file "$define/system/exec/nolog startup$startup_list startup$startup_vms,startup$startup_layered"
$	Write file "$define/system/exec/nolog startup$phases sys$startup:vms$phases.dat"
$	Write file "$define/table=lnm$system_directory/super lnm$dcl_logical lnm$file_dev"
$	Write file "$ IF F$SEARCH(""sys$common:<sysupd>lmf$config.com"") .NES. """" THEN -"
$	Write file "     @sys$common:<sysupd>lmf$config.com"
$	Write file "$ RUN SYS$SYSTEM:SYSGEN"
$	Write file "AUTOCONFIGURE ALL"
$	Write file "EXIT"
$	Write file "$ DEFINE NETCIRC SYS$SPECIFIC:<SYSEXE>NETCIRC.DAT"
$	Write file "$ DEFINE NETLINE SYS$SPECIFIC:<SYSEXE>NETLINE.DAT"
$	Write file "$ DEFINE NETOBJECT SYS$SPECIFIC:<SYSEXE>NETOBJECT.DAT"
$	Write file "$ DEFINE NETLOGING SYS$SPECIFIC:<SYSEXE>NETLOGING.DAT"
$	Write file "$ DEFINE NETNODE_LOCAL SYS$SPECIFIC:<SYSEXE>NETNODE_LOCAL.DAT"
$	Write file "$ DEFINE NETNODE_REMOTE SYS$SPECIFIC:<SYSEXE>NETNODE_REMOTE.DAT"
$	Write file "$ DEFINE NETCONF SYS$SPECIFIC:<SYSEXE>NETCONF.DAT"
$	Write file "$ IF F$SEARCH(""sys$common:<sysexe>netnode_remote.dat"") .EQS. """" THEN GOTO install"
$	Write file "$ DEFINE NETNODE SYS$SPECIFIC:<SYSEXE>NETNODE.DAT"
$	Write file "$INSTALL:"
$	Write file "$ install = ""$install"""
$	Write file "$ install sys$common:<syslib>secureshr /open/header/shared/protect"
$	Write file "$ install sys$common:<syslib>dismntshr /open/header/shared/protect/nopurge"
$	Write file "$ install sys$common:<syslib>mountshr /open/header/shared/protect"
$	Write file "$ install sys$common:<sysmsg>sysmgtmsg"
$	!
$	if .not.ROOT0 
$	  then
$	  Write file "$ write sys$output ""Configuring network..."""
$	  Write file "$ @SYS$MANAGER:NETCONFIG ''node' ''dnetadr' NO NO YES"
$	endif
$	! Removed boot node handling
$	! Removed alias handling
$	Write file "$ ncp =""$ncp"""
$	Write file "$ ncp define executor maximum address 1023"
$	Write file "$ ncp purge known logging all"
$	Write file "$ IF F$SEARCH(""sys$specific:<sysexe>netnode_remote.dat"") .EQS. """" THEN GOTO norem"
$	Write file "$ IF F$SEARCH(""sys$common:<sysexe>netnode_remote.dat"") .EQS. """" THEN GOTO norem"
$	Write file "$ delete/nolog sys$specific:<sysexe>netnode_remote.dat;*"
$	!
$	Write file "$ Write sys$output "+q+"Using AUTOGEN, reboot..."+q
$	Write file "$ @SYS$COMMON:<sysupd>AUTOGEN GETDATA REBOOT NOFEEDBACK"
$	Write file "$ verify = 'F$VERIFY(verify)'"
	CLOSE file
$	PURGE 'outdev'[SYS0.SYSEXE]STARTUP1.COM
$ !
$ ! Create inital systartup.com (may be overriden later by LAVC data)
$ !	
$	CREATE  'outdev'[VMS$COMMON.SYSMGR]SYSTARTUP_V5.COM
$	PURGE 'outdev'[VMS$COMMON.SYSMGR]SYSTARTUP_V5.COM
$ !
$ ! Set the correct cluster system volume name
$ !
$VOLSET:
$	SET VOLUME 'outdev'/LABEL='node'_SYS
$ !
$ ! ***************** COPY FILES FROM THE LAVC DATABASE *********************
$ !
$ 	if f$search("LAVC$DATA:[LAVCCOM]*.*") .eqs. "" then -
	   ERR FAC+"E-NOLAVC, LAVC Database not accessible"
$ 	if f$search("LAVC$DATA:[LAVCCOM]*.*") .eqs. "" then GoTo FINISH
$	COPY/Write/READ lavc$data:[LAVCCOM]SYSTARTUP_V5.COM -
             'outdev'[VMS$COMMON.SYSMGR]SYSTARTUP_V5.COM;0	! Standard STARTUP file
$	PURG 'outdev'[VMS$COMMON.SYSMGR]SYSTARTUP_V5.COM
$	COPY/Write/READ lavc$data:[LAVCCOM]SYSHUTDWN.COM -
             'outdev'[VMS$COMMON.SYSMGR]SYSHUTDWN.COM;0	! Standard SHUTDOWN file
$	PURG 'outdev'[VMS$COMMON.SYSMGR]SYSHUTDWN.COM
$	BACKUP/Over/Ignore=interlock lavc$data:[LAVCCOM]*.*;0 -
				     'outdev'[*...] 	! LAVC common data copy
$	BACKUP/Over/Ignore=Interlock lavc$data:['node']*.*;0  -
                                     'outdev'[*...] 	! NODE specific data
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	if .not. ready then DISMOUNT 'outdev'		! Device was not ready
$	SAY FAC+"I-FINISH, Operation finished "+f$time()
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	if .not. ready then DISMOUNT 'outdev'		! Device was not ready
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	Verify = f$verify(Verify)
$	Exit %X10000004
$ !
$ ! Create system files subroutine ( file, size )
$ !
$GENFILE:
$	if size .eq. 0 then Return			! No size = done
$	if f$sear(file) .eqs. "" then Goto GENFILE1	! No file = make a new 
$	if f$file(file,"EOF") .gt. size then GoTo GENFILE2
$	Delete/Log/Noconf 'f$sear(file)			! Delete an old one
$GENFILE1:
$	SYSGEN:=$SYSGEN					! SYSGEN is defined
$	SYSGEN CREATE 'file /Size='size			! Create the file
$GENFILE2:
$	Set File/Nobackup 'file
$	Return
