$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ 	GoTo START
$ !

$ ! Facility: ATTC LVAC System Management
$ ! Purpose:  Procedure used to prepare a disk for VMS system.
$ ! Notes:    
$ !	      MGMSYSDEL.COM MUST be be revised on each VMS and VWS software 
$ !	      release to make sure harcoded directories are correct !
$ !	     
$ ! History:
$ ! 07/06/87,MXB,Upgrade to VMS 5.0, added P2,P3 arguments
$ ! 10/30/87,MXB,Initial code
$ !
$ ! Arguments:
$ !
$ !	P1	Target VMS system root device (Cluster layout will be destroyed)
$ !		If not mounted, device will be INITIALIZED !!!!!!!
$ !
$ !	P2      VMS version to handle: V4 or V5 (or both), default = V5
$ !     
$ !     P3      Delete ALL system roots, default = YES
$START:
$	Set NoOn
$	Set UIC [1,4]				! Make sure running under SYSTEM
$	SAY="Write sys$output"			! Shorthands
$	ERR="Write sys$error
$	FAC="%SYSDEL-"
$	STS=1					! Standard status
$	SAY FAC+"I-RNOTES, Please, read NOTES in procedure header"
$	On CONTROL_Y then GoTo FATERR		! Handle CTRL^Y correctly
$ !
$ ! Argument inquiry:
$ !
$GETTGT:
$	ready = 0
$	if P1 .eqs. "" then INQUIRE p1 "* Target device for VMS tree [node$ddcu:] "
$	if p1 .eqs. "" then GoTo GETTGT
$GETVER:
$	V5 = 0
$	V4 = 0
$	if P2 .eqs. "" then P2 = "V5"
$	if f$loc("4",p5) .ne. f$len(P5) V4 = 1
$	if f$loc("5",p5) .ne. f$len(P5) V5 = 1
$GETROO:
$	DR = 1					! Delete all roots
$	if p3 .nes. "" then DR = 0		! Keep roots (remove common)
$ !
$ ! ************************* VMS SYSTEM FILES DELETE  *************************
$ !
$ ! Check the target device. If not mounted, will be initialized !
$ !
$DEVCHK:
$	if f$getdvi(P1,"EXISTS") then Goto DEVCHK1
$	ERR fac+"F-NOTEXI, Target root device does NOT exist: "+p1
$	Goto FATERR
$DEVCHK1:
$	ready=f$getdvi(P1,"MNT")			! Get device readiness state
$	if ready then GoTo DEVCHK2
$	ERR fac+"I-TGTINI, Target device not mounted: "+p1
$	Goto FATERR
$DEVCHK2:
$	outdev=f$getdvi(p1,"FULLDEVNAM")		! Get full output device name
$ !	=====================================================================
$ !	Now delete ALL VMS files:
$ !
$	SAY fac+"W-DELFIL, All system-like files on ''outdev' will be deleted'
$	Inquire YN "Ready to go ahead [YES or NO] "
$	if YN .nes. "YES" then GoTo FATERR
$	Assign nl: sys$output
$	Assign nl: sys$error
$	if .not. DR then SET FILE/REMOVE 'outdev'[SYS*]syscommon.dir;*
$	n=8						! 8 directory levels
$DELSTA:
$	if V4 then Delete/NoLog/Noconf 'outdev'[v4common...]*.*;*
$	if V5 then Delete/NoLog/Noconf 'outdev'[vms$common...]*.*;*
$	Delete/NoLog/Noconf 'outdev'[SYSEXE...]*.*;*
$	Delete/NoLog/Noconf 'outdev'[SYSMAINT...]*.*;*
$	if DR then Delete/NoLog/Noconf 'outdev'[SYS*...]*.*;*
$	n=n-1
$	if (n.gt.0)then GoTo DELSTA
$ 	if V4 then Delete/NoLog/Noconf 'outdev'[000000]v4common.dir;*
$ 	if V5 then Delete/NoLog/Noconf 'outdev'[000000]vms$common.dir;*
$ 	Delete/NoLog/Noconf 'outdev'[000000]sysmaint.dir;*
$ 	Delete/NoLog/Noconf 'outdev'[000000]sysexe.dir;*
$ 	if DR then Delete/NoLog/Noconf 'outdev'[000000]sys*.dir;*
$	deass sys$output
$	deass sys$error
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	if .not. ready then DISMOUNT 'outdev'		! Device was not ready
$	SAY FAC+"I-FINISH, Operation finished "+f$time()
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	if .not. ready then DISMOUNT 'outdev'		! Device was not ready
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	Verify = f$verify(Verify)
$	Exit %X10000004
$	Return
