$ 	Verify = f$verify(f$extract(0,1,"''debug'0"))
$ !
$ ! MGMTAILOR.COM - VMS TAILORING PROCEDURE
$ ! Facility: ATTC LVAC System Management
$ ! Purpose:  Procedure used to delete/restore files on the specified
$ !	      target disk's VMS common [V4COMMON] tree.
$ !	      The "source" disk is used as an input for restore oper,
$ !	      and  to check that file may be restored on delete oper.
$ ! Notes:    
$ ! History:
$ ! 05/08/87,MXB,Coding started
$ !
$ ! Arguments:
$ !
$ !	P1   	Operation        	    "DELETE|RESTORE"
$ !	P2	Source disk (readonly)	    "node$ddcu"
$ !	P3	Target disk (modified)	    "node$ddcu"
$ !	P4	Tailoring control file      "pathname"
$ !
$ ! 	********************************************************************
$START:
$	Set NoOn
$	node=f$getsyi("NODENAME")
$	SAY:="write sys$output"
$	ERR:="write sys$error"
$	FAC:="%MGMTLR-"
$	if P1 .eqs. "" then Inquire P1 "Operation type [DELete,REStore]"
$	if P2 .eqs. "" then Inquire P2 "Source disk device  [node$ddcu]"
$	if P3 .eqs. "" then Inquire P3 "Target disk device  [node$ddcu]"
$	if P4 .eqs. "" then Inquire P4 "Control file pathname [filespc]"
$	OPER=f$extr(0,3,f$edit(P1,"TRIM,UPCASE"))
$	If OPER .nes. "DEL" .and. OPER .nes. "RES" then GoTo BADARG
$	if .not. f$getdvi(P2,"EXISTS") then GoTo BADARG
$	if .not. f$getdvi(P3,"EXISTS") then GoTo BADARG
$	P2 = f$getdvi(P2,"FULLDEVNAM")
$	P3 = f$getdvi(P3,"FULLDEVNAM")
$	if .not. f$getdvi (P2,"MNT") then Goto BADARG
$	if .not. f$getdvi (P3,"MNT") then Goto BADARG
$	!
$	Define/Nolog/Transl=concealed TGTROOT  'P3'[V4COMMON.]
$	Define/Nolog/Transl=concealed SRCROOT  'P2'[V4COMMON.]
$	if f$search (P4) .nes. "" then GoTo OPEN_FILE
$BADARG:
$	ERR FAC+"F-IVARG, Invalid argument specified, exiting"
$	GoTo FATERR
$ !
$ ! *********************** MAIN PROCESSING LOOP *************************
$ !
$OPEN_FILE:
$	SAY FAC+"I-START, Starting on ''node' "+f$time()
$	OPEN/READ/ERR=FATERR file 'P4
$LINE_LOOP:
$	READ/ERR=LINE_END/END=LINE_END file rec	
$	if f$len(rec) .lt. 1 then GoTo LINE_LOOP
$	if f$extract(0,1,rec) .eqs. "!" then GoTo LINE_LOOP
$	if f$extract(0,1,rec) .eqs. "$" then 'rec	! Execute line
$	if f$extract(0,1,rec) .eqs. "$" then GoTo LINE_LOOP
$	if OPER .eqs. "DEL" then GOSUB DELFILE
$	if OPER .eqs. "RES" then GOSUB RESFILE
$	GoTo LINE_LOOP
$LINE_END:
$	CLOSE file
$	SAY FAC+"I-FINIS, Finished on ''node' "+f$time()
$	GoTo FINISH
$ !
$ ! *********************** Delete a single file *************************
$ !
$DELFILE:
$	if f$search ("SRCROOT:''rec'") .eqs. "" then GoTo DEL_NOSRC
$	if f$search ("TGTROOT:''rec'") .eqs. "" then GoTo DEL_NOTGT
$	Delete/NoLog/Noconfirm TGTROOT:'rec';*
$	RETURN
$DEL_NOSRC:
$	ERR FAC+"W-NOSRC, No source for ''rec', file not deleted"
$	RETURN
$DEL_NOTGT:
$	ERR FAC+"I-NOTGT, No target for ''rec', file not deleted"
$	RETURN
$ !
$ ! *********************** Restore a single file *************************
$ !
$RESFILE:
$	if f$search ("SRCROOT:''rec'") .eqs. "" then GoTo RES_NOSRC
$	BACKUP/Verify SRCROOT:'rec';0 TGTROOT:'rec';0/Replace/Own=orig
$	if .not. $STATUS then -
$	ERR FAC+"E-NORES, Backup error: ''rec', file not restored"
$	RETURN
$RES_NOSRC:
$	ERR FAC+"E-NOSRC, No source for ''rec', file not restored"
$	RETURN
$ !
$ ! *********************** Finally gracefully exit *************************
$ !
$FINISH:
$	Verify = f$verify(Verify)
$	Exit
$FATERR:
$	ERR FAC+"F-INCOMP, Operation incomplete for reason above"
$	Verify = f$verify(Verify)
$	Exit %X10000004

