#include <ssdef.h>
#include <desc.h>
#include <syidef.h>

main()
{
unsigned int shift = 10000000;
unsigned int	status, split_ios, seconds_wasted_split, seconds_since_boot;
unsigned int	window_turns, seconds_wasted_turns, seconds_wasted_tot;
unsigned int	boot_time[2], current_time[2], up_time[2];
float	pct_wasted_split, pct_wasted_turns, pct_wasted_tot;

struct	ITEM
{
	short	len;			/* buffer length */
	short	item_code;		/* information item requested */
	char	*buf;			/* return buffer */
	int	*rlen;			/* return length */
};

struct
{
	struct	ITEM items[1];
	int	endoflist;
} itemlist				=
					{
		/* boottime	*/	8 ,SYI$_BOOTTIME,&boot_time	,0
					};

/* Get boot time */
	itemlist.endoflist = 0;
	status = sys$getsyi(0,0,0,&itemlist,0,0,0);
	if (status != SS$_NORMAL)
		{
		printf ("GETSYI status of %d\n",status);
		exit(status);
		}

/* Get current time */
	status = sys$gettim(&current_time);
	if (status != SS$_NORMAL)
		exit(status);

/* Find elapsed clock time since boot */
	subquad (&current_time,&boot_time,&up_time);
	ediv (&up_time,&shift,&seconds_since_boot);

/* Find number of split I/O's */
	split_ios = *(int *)0x80000b1c;
	seconds_wasted_split = (float)(split_ios * .030);
	seconds_wasted_tot = seconds_wasted_split;

/* Find number of window turns */
	window_turns = *(int *)0x80000b18;
	seconds_wasted_turns = (float)(window_turns * .030);
	seconds_wasted_tot += seconds_wasted_turns;

/* Calculate percentages */
	pct_wasted_split = (((float)seconds_wasted_split /
		(float)seconds_since_boot) * 100);
	pct_wasted_turns = (((float)seconds_wasted_turns /
		(float)seconds_since_boot) * 100);
	pct_wasted_tot = (((float)seconds_wasted_tot /
		(float)seconds_since_boot) * 100);

/* Print results */
	printf ("Total of %3.1f%% clock time wasted since boot for\n",
		pct_wasted_tot);
	printf ("\t %d (%3.1f%%) split I/O's, and",split_ios,pct_wasted_split);
	printf (" %d (%3.1f%%) window turns!\n",window_turns,pct_wasted_turns);

	exit(SS$_NORMAL);
}
