$	verify = f$verify(0)
$!*****************************************************************************
$!
$!	GBLSUBS - Procedure to do a global substitution in wildcarded files.
$!
$!	V1.000	 06/30/86  Geoff Bryant		Initial versin
$!
$!*****************************************************************************
$
$	say := "write sys$output"
$
$ ! Check for help
$
$	if f$edit(p1,"collapse,upcase") .nes. "HELP" then goto 10
$	type sys$input

            GBLSUBS - Utility to substitute text in multiple files

	This utility allows you to replace all occurances of a string
	with another string in a list of files.    GBLSUBS is invoked
	as follows:

		$ @TOOLS:GBLSUBS file(s) search_string replace_string

	You will be prompted for any unspecified parameters.  Options
	are specified as switches for a file:

		/Confirm - will ask you to confirm each file
		/Exact   - will do a case sensitive search
		/Query   - will ask you to confirm each substitution

$	p1 := ""
$	p2 := ""
$	p3 := ""
$
$ ! Get input file(s)...
$
$ 10:
$	if p1 .eqs. "" then inquire p1 "Enter the filename(s) to be edited"
$	p1 = f$edit(p1,"collapse,upcase")
$ 20:	if p2 .eqs. "" then read/prompt="Search for: " sys$command p2
$	if p3 .eqs. "" then read/prompt="Replace with: " sys$command p3
$
$ ! Process the file(s)...
$
$	element_number = 0
$
$ 100:
$	element = f$element(element_number,",",p1)
$	if element .eqs. "," then goto exit
$
$	file = f$extract(0,f$locate("/",element),element)
$	if f$parse(file,,,,"syntax_only") .nes. "" then goto 105
$		say "%GBLSUBS-W-INVFILE, ''file' is not a valid filename."
$		element_number = element_number + 1
$		goto 100
$	105:
$	switch = f$extract(f$locate("/",element),f$length(element),element)
$
$	confirm = f$locate("/C",switch) .ne. f$length(switch)
$	if .not. confirm then goto 110
$		beg = f$extract(0,f$locate("/C",switch),switch)
$		end = f$extract(f$locate("/C",switch)+2,-
				f$length(switch),switch)
$		end = f$extract(f$locate("/",end),f$length(end),end)
$		switch = beg + end
$	110:
$	query = f$locate("/Q",switch) .ne. f$length(switch)
$	if .not. query then goto 120
$		beg = f$extract(0,f$locate("/Q",switch),switch)
$		end = f$extract(f$locate("/Q",switch)+2,-
				f$length(switch),switch)
$		end = f$extract(f$locate("/",end),f$length(end),end)
$		switch = beg + end
$	120:
$	exact_flag = f$locate("/E",switch) .ne. f$length(switch)
$	if .not. exact_flag then goto 130
$		beg = f$extract(0,f$locate("/E",switch),switch)
$		end = f$extract(f$locate("/E",switch)+2,-
				f$length(switch),switch)
$		end = f$extract(f$locate("/",end),f$length(end),end)
$		switch = beg + end
$	130:
$	if exact_flag then exact_text := "exact"
$	if .not. exact_flag then exact_text := "no_exact"
$	wild = (f$locate("*",file) .ne. f$length(file)) .or. -
	       (f$locate("%",file) .ne. f$length(file)) .or. -
	       (f$locate("...",file) .ne. f$length(file))
$
$ ! Find a file
$
$ 200:	this_file = f$search(file,97532)
$	if this_file .eqs. "" then goto 400
$	this_file = this_file - f$parse(this_file,,,"version","syntax_only")
$
$	if confirm then goto 220
$		say "File: ",this_file
$		goto 230
$	   220:	inquire/nopunc this_one -
			"File ''this_file' [Y/N/Q default=N]? "
$		if (this_one .eqs. "Q") .or (this_one .eqs. "q") then goto exit
$		if .not. this_one then goto 300
$	   230:
$	open/write out sys$login:gblsubs_temp_file.tpu
$	write out ""
$	write out "procedure gbl_rep(s,r)"
$	write out "   on_error"
$	write out "      msg_txt := fao('!UL replacement!%S of !AS with !AS',"
$	write out "                     replaced,s,r);"
$	write out "      message(msg_txt);"
$	write out "      return;"
$	write out "   endon_error;"
$	if query then goto 240
$	write out "   loop"
$	write out "      search_range := search(s,forward,''exact_text');"
$	write out "      erase(search_range);"
$	write out "      position(end_of(search_range));"
$	write out "      copy_text(r);"
$	write out "      replaced := replaced + 1;"
$	write out "   endloop;"
$	goto 250
$ 240:
$	write out "   loop"
$	write out "      search_range := search(s,forward,''exact_text');"
$	write out "      position(beginning_of(search_range));"
$	write out "      mark_it := mark(reverse);"
$	write out "      refresh;"
$	write out "      loop"
$	write out "         cmd := read_line('Replace [Y/N/Q default=N]? ');"
$	write out "         if cmd = """" then cmd := 'n' endif;"
$	write out "         edit(cmd,compress,lower);"
$	write out "         cmd := substr(cmd,1,1);"
$	write out "         exitif ((cmd = 'y') or (cmd = 'n') or (cmd = 'q'))"
$	write out "      endloop;"
$	write out "      if cmd = 'q' then"
$	write out "         msg_txt:= fao('!UL replacement!%S of !AS with !AS',"
$	write out "                        replaced,s,r);"
$	write out "         message(msg_txt);"
$	write out "         return;"
$	write out "         endif;"
$	write out "      if cmd = 'y' then"
$	write out "         erase(search_range);"
$	write out "         position(end_of(search_range));"
$	write out "         copy_text(r);"
$	write out "         replaced := replaced + 1;"
$	write out "         endif;"
$	write out "      if cmd = 'n' then move_horizontal(1); endif;"
$	write out "   endloop;"
$ 250:
$	write out "endprocedure"
$	write out ""
$	write out "replaced := 0;"
$	write out "input_file := get_info(command_line,'file_name');"
$	write out "main_buffer := create_buffer('main',input_file);"
$	if .not. query then goto 260
$	write out "screen_length := get_info(screen,""visible_length"");"
$	write out "set(prompt_area,(screen_length - 2),1,reverse);"
$	write out "message_buffer := create_buffer(""message"");"
$	write out "set(eob_text,message_buffer,"""");"
$	write out "set(permanent,message_buffer);"
$	write out "set(no_write,message_buffer);"
$	write out "set(system,message_buffer);"
$	write out "message_window := create_window((screen_length-1),2,off);"
$	write out "set(video,message_window,none);"
$	write out "map(message_window,message_buffer);"
$	write out "set(system,main_buffer);"
$	write out "main_window := create_window(1,(screen_length - 3),off);"
$	write out "set(scrolling,main_window,on,6,7,0);"
$	write out "map(main_window,main_buffer);"
$	write out "position(main_window);"
$ 260:
$	write out "position(beginning_of(main_buffer));"
$	write out "gbl_rep(""''p2'"",""''p3'"");"
$	write out "if replaced <> 0 then"
$	write out "   write_file(main_buffer,input_file);"
$	write out "   endif;"
$	write out "quit;"
$	write out ""
$	close out
$	assign/user sys$command sys$input
$	if query then -
	   edit/tpu/nosection/command=sys$login:gblsubs_temp_file.tpu 'this_file
$	if .not. query then -
	   edit/tpu/nodisp/nosec/comm=sys$login:gblsubs_temp_file.tpu 'this_file
$	delete/nolog sys$login:gblsubs_temp_file.tpu;0
$
$ 300:	if wild then goto 200
$
$ 400:	element_number = element_number + 1
$	goto 100
$	
$ EXIT:
$	clean_up = f$trnlnm("out") .nes. ""
$	if clean_up then close out
$	if clean_up then delete/nolog sys$login:gblsubs_temp_file.com;0
$	verify = f$verify(verify)
$	exit
