{   	INI FILE MODULE FOR RNO TO TEX CONVERSION           }
{ 	RANDALL VENHOLA JULY 7, 1987                        }
               
[INHERIT('UTILITYOPS','BASICFILEOPS','ARGOPS',
         'TREEANDLISTOPS','SCREENHANDLERS')]

MODULE INIOPS;


                           
[GLOBAL] PROCEDURE readarglistfromini( var ini : text; var index : integer;
	                          var list : arglist );
const
  iniseparator = '$';
var
  s : pckstr;
  done : boolean;
  gotten : boolean;
  arg : argument;
  inserted : boolean;

  function endofline : boolean;
  begin
    if eof(ini) then
       endofline := true
    else
       begin
         if eoln(ini) then
            endofline := true
         else
           begin
             if ini^ = blank then
                endofline := true
             else
                endofline := false
           end
       end
  end;
                     
  function atseparator : boolean;
  begin
    atseparator := (ini^ = iniseparator)
  end;

  procedure readpckstr( var s : pckstr; var gotten : boolean );
  var
    ch : char; 
    done : boolean;
    charindex : integer;
  begin
    s.body := blank;
    done := false;
    charindex := 0;
    repeat
        if endofline then
            done := true
        else
          if atseparator then
             done := true
          else
             if charindex = maxchars then
             begin
	        warningmessage('readini','ini file argument size overflow');
                done := true                                              
             end
	     else
             begin
                read(ini, ch);
                charindex := charindex + 1;
                s.body[charindex] := ch
             end;
         s.length := charindex
    until done;
    gotten := charindex > 0;
    if atseparator then read(ini, ch)                      
  end;
  
  procedure readindex(var index : integer; var gotten : boolean );
  const
    ndigits = 3;
  var
    count : integer;
    ch    : char;
  begin
    gotten := true;
    count := 0;
    index := 0;
    repeat
        if endofline then
            gotten := false
        else
          if count < ndigits then
          begin
             read(ini, ch);                   
             count := count + 1;
             if ch in ['0'..'9'] then
                index := index*10 + ord(ch) - ord('0')
             else
             begin
	        warningmessage('readini','bad index digits in INI');
	        gotten := false                                   
             end
          end
     until (not gotten) or (count = ndigits);
     if (gotten) and (not eof(ini)) then read(ini, ch)
  end;

  procedure pckstrtoarg( s : pckstr; index : integer; var arg : argument);
  label
      routineexit;
  begin
     initarg(arg, [dsrverb], s, index, false );        
     if s = '[N]' then
     begin
       reassignargclass(arg, [int,signedint,nulltype]);
       reassignarggeneralization(arg, true);
       goto routineexit
     end;
     if s = '[Y]' then
     begin
       reassignargclass(arg, [stylespecifier]);
       reassignarggeneralization(arg, true);
       goto routineexit
     end;
     if s = '[T]' then
     begin            
       reassignargclass(arg, [textpckstr,character,nulltype]);
       reassignarggeneralization(arg, true);
       goto routineexit
     end;
     if s = '[C]' then
     begin
       reassignargclass(arg, [character,nulltype]);
       reassignarggeneralization(arg, true);
       goto routineexit
     end;                  
     if s = '[Q]' then
     begin
       reassignargclass(arg, [quotedpckstr,nulltype]);
       reassignarggeneralization(arg, true);
       goto routineexit
     end;
     routineexit : nullstatement
  end;         
  
begin {readarglistfromini}
  list := nulllist;
  readindex(index, gotten );
  if gotten then                                              
  begin         
    if index < 1 then      
      warningmessage('readini','bad INI index value');
    repeat
       readpckstr(s, gotten );
       if gotten then        
       begin
         pckstrtoarg(s, index, arg );
         appendargonlist(list, arg);
       end                                             
    until not gotten;
    if arglistlength(list) = 0 then
       warningmessage('readini','empty argument list in INI file')
  end  
  else
  begin
    index := indexofunknowntexcommand;
    warningmessage('readini','could not read index from INI file')
  end;                        
  if not eof(ini) then
    readln(ini)
end;  
         




                   
[GLOBAL] PROCEDURE setuptree( var ini : text; var tree : argtree );
var 
   list : arglist;
   index : integer;
begin  
    openinifile( ini );
    tree := nulltree;
    while not eof(ini) do
    begin          
       readarglistfromini( ini, index, list);

       {   ***** ttywritestring(' index read = ');
                 ttywriteint(index);
                 ttywriteln;                   *****      }

       insertlistintotree( list, tree )
    end;
    closeinifile( ini )
end;
    
    
                                      
END.                  
