[INHERIT('UTILITYOPS','ARGOPS','BASICFILEOPS',
'TREEANDLISTOPS','FLAGOPS')]

MODULE LATEXOPS;


TYPE
 

countparametertype = (numericcounter, lowercasechars, uppercasechars );

parameterchangestates = (nochange, altered,  assigned);

pagestyletype  = (empty, plain, headings, myheadings);

liststatetype = (nostate, itemize, enumerate);


VAR
   
   LOG               : [EXTERNAL] TEXT;
   pagestyle        : [EXTERNAL] pagestyletype;
   datestring       : [EXTERNAL] pckstr;
   title, subtitle   : [EXTERNAL] argarray;
   fill	             : [EXTERNAL] boolean;
   centering         : [EXTERNAL] boolean;
   flushright       : [EXTERNAL] boolean;
   minipageactive  : [EXTERNAL] boolean;
   inmarginpar      : [EXTERNAL] boolean;        
   infootnote       : [EXTERNAL] boolean;
   underlineactive  : [EXTERNAL] enhancmentstates;
   boldactive       : [EXTERNAL] enhancmentstates;
   listnestlevel   : [EXTERNAL] integer;

PROCEDURE startlatex( var outfile : text; outputfont : integer ; outputstyle: pckstr );
const
   minfont = 10;
   maxfont = 12;
var
  pt : integer;
begin          
  pt := outputfont;
  if (pt < minfont) or (pt > maxfont) then
    pt := minfont;                                                  
  writeln(outfile,'%');
  if pt = 10 then
     writeln(outfile,'\documentstyle{',outputstyle,'}')
  else
     writeln(outfile,'\documentstyle[',pt:2,'pt]{',outputstyle,'}');
   writeln(outfile,'%');
   writeln(outfile,'% (put preamble statements here) ');
   writeln(outfile,'%');
   writeln(outfile,'\begin{document}');
   writeln(outfile,'%')
end;


[GLOBAL] PROCEDURE closeanyopenbrackets( var outfile : text );
var
  i : integer;
begin
   if not fill then
     writeln(outfile,'} % - end of obeylines and obeyspaces group');
   if centering then
     writeln(outfile,'\end{centering}');
   if flushright then
     writeln(outfile,'\end{flushright}');
   if minipageactive then
     writeln(outfile,'\end{minipage}');
   if inmarginpar then
     writeln(outfile,'} % - end of margin par ');
   if infootnote then
     writeln(outfile,'} % - end of footnote');
   if inliteral then
     writeln(outfile,'\end{verbatim}');
   for i := 1 to listnestlevel do
      writeln(outfile,'\end{itemize} % - RNOTOTEX forced list close');
   stopunderline( outfile );
   stopbold( outfile )
end;
    


[GLOBAL] PROCEDURE endlatex( var outfile : text );
begin           
  closeanyopenbrackets( outfile );
  writeln(outfile,'%');
  writeln(outfile,'%  (put postamble statements here) ');
  writeln(outfile,'%');
  writeln(outfile,'\end{document}')
end;


                                     
[GLOBAL] PROCEDURE adjustpagestyle( var f : text; newstyle : pagestyletype);
begin
  pagestyle := newstyle;
  case pagestyle of
    empty       : writeln(f,'\pagestyle{empty}');
    plain       : writeln(f,'\pagestyle{plain}');
    headings    : writeln(f,'\pagestyle{headings}');
    myheadings  : begin
                     writeln(f,'\pagestyle{myheadings}');
	             write(f,'\markright{');
                     writeargarray(f, title);
                     writeargarray(f, subtitle);
                     write(f, datestring );
                     writeln(f,'}')
                  end
  end;
  case pagestyle of
    empty       : writeln(log,'\pagestyle{empty}');
    plain       : writeln(log,'\pagestyle{plain}');
    headings    : writeln(log,'\pagestyle{headings}');
    myheadings  : begin
                     writeln(log,'\pagestyle{myheadings}');
	             write(log,'\markright{');
                     writeargarray(log, title);
                     writeargarray(log, subtitle);
                     write(log, datestring );
                     writeln(log,'}')
                  end
  end
end;
                      
                      


[GLOBAL] PROCEDURE writecharwidth( var f : text; nchars : integer);
const
  widthofcharincm = 0.254; { 10 chars per inch, 2.54 cm per inch }
  maxwidth = 20.0;
  minwidth = -20.0;
var
  cm  : real;
begin
  cm := nchars * widthofcharincm;
  if cm > maxwidth then
  begin
    writeln(log,'[too many chars to skip, ',nchars,' = ',cm:10:2,'cm]');
    cm := 1.0
  end;             
  if  cm < minwidth then
  begin
    writeln(log,'[too many chars to skip ',nchars,' = ',cm:10:2,'cm]');
    cm := -1.0
  end;
  write(f, cm:6:2, 'cm ');
  write(log, cm:6:2,'cm ')
end;



[GLOBAL] PROCEDURE writecharheight( var f : text; nlines : integer );
const
  heightoftextincm = 0.425; { 6 lines per inch, 2.54 cm per inch }
  maxheight = 25.0;
  minheight = -25.0;
var
  cm : real;
begin
  cm := nlines * heightoftextincm;
  if cm > maxheight then
  begin
    writeln(log,'[too many lines to skip, ',nlines,' = ',cm:10:2,'cm]');
    cm := 1.0
  end;             
  if  cm < minheight then
  begin
    writeln(log,'[too many lines to skip ',nlines,' = ',cm:10:2,'cm]');
    cm := -1.0
  end;
  write(f, cm:6:2,'cm ');
  write(log, cm:6:2,'cm ')
end;





[GLOBAL] PROCEDURE adjustlength( var outfile : text; modified : parameterchangestates;
lengthvalue : integer; adjustmentvalue : integer; charwidth : boolean;
latexname : pckstr );
begin
   case modified of
     nochange : nullstatement;
     altered   : begin
	           write(outfile,'\addtolength{',latexname,'}{');
                   if charwidth then
                      writecharwidth(outfile, adjustmentvalue)
                   else
                      writecharheight(outfile, adjustmentvalue);
                   writeln(outfile,'}')
                 end;
     assigned  : begin
	           write(outfile,'\setlength{',latexname,'}{');
                   if charwidth then
                      writecharwidth(outfile, lengthvalue)
	           else
	              writecharheight(outfile, lengthvalue);
                   writeln(outfile,'}')
                 end
  end;              
   case modified of
     nochange : noconversion;
     altered   : begin
	           write(log,'\addtolength{',latexname,'}{');
                   if charwidth then
                      writecharwidth(log, adjustmentvalue)
                   else
                      writecharheight(log, adjustmentvalue);
                   writeln(log,'}')
                 end;
     assigned  : begin
	           write(log,'\setlength{',latexname,'}{');
                   if charwidth then
                      writecharwidth(log, lengthvalue)
	           else
	              writecharheight(log, lengthvalue);
                   writeln(log,'}')
                 end
  end              
end;                                              
 
               

[GLOBAL] PROCEDURE adjustcounter( var outfile : text;  modified : parameterchangestates;
countervalue : integer; adjustmentvalue : integer; latexname : pckstr );
begin
   case modified of
     nochange : nullstatement;
     altered   : writeln(outfile,'\addtocounter{',latexname,'}{',adjustmentvalue,'}');
     assigned  : writeln(outfile,'\setcounter{',latexname,'}{',countervalue,'}')               
   end;
   case modified of
     nochange : noconversion;
     altered   : writeln(log,'\addtocounter{',latexname,'}{',adjustmentvalue,'}');
     assigned  : writeln(log,'\setcounter{',latexname,'}{',countervalue,'}')               
   end
end;

                                                     

[GLOBAL] PROCEDURE adjuststyle(var outfile : text; s : styletype;
	                         latexname : pckstr );
begin                                                         
   case s of 
     undetermined : nullstatement;
     decimal      : writeln(outfile,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}');
     octal        : writeln(outfile,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}'); 
     hexidecimal  : writeln(outfile,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}');
     romanupper  : writeln(outfile,'\renewcommand{\the',latexname,'}{\Roman{',latexname,'}}');
     romanlower  : writeln(outfile,'\renewcommand{\the',latexname,'}{\roman{',latexname,'}}');
     romanmixed  : writeln(outfile,'\renewcommand{\the',latexname,'}{\roman{',latexname,'}}');
     letterupper : writeln(outfile,'\renewcommand{\the',latexname,'}{\Alpha{',latexname,'}}');
     letterlower : writeln(outfile,'\renewcommand{\the',latexname,'}{\alpha{',latexname,'}}');
     lettermixed : writeln(outfile,'\renewcommand{\the',latexname,'}{\alpha{',latexname,'}}');
     nostyle     : nullstatement
  end;
   case s of                     
     undetermined : noconversion;
     decimal      : writeln(log,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}');
     octal        : writeln(log,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}'); 
     hexidecimal  : writeln(log,'\renewcommand{\the',latexname,'}{\arabic{',latexname,'}}');
     romanupper  : writeln(log,'\renewcommand{\the',latexname,'}{\Roman{',latexname,'}}');
     romanlower  : writeln(log,'\renewcommand{\the',latexname,'}{\roman{',latexname,'}}');
     romanmixed  : writeln(log,'\renewcommand{\the',latexname,'}{\roman{',latexname,'}}');
     letterupper : writeln(log,'\renewcommand{\the',latexname,'}{\Alpha{',latexname,'}}');
     letterlower : writeln(log,'\renewcommand{\the',latexname,'}{\alpha{',latexname,'}}');
     lettermixed : writeln(log,'\renewcommand{\the',latexname,'}{\alpha{',latexname,'}}');
     nostyle     : noconversion
  end
end;


END.
                                
