$!
$!    SETUP Version 2.1
$!
$ exit_value = 1
$ on control_y then goto exit
$ on WARNING then goto exit
$! Check that a product is specified
$ if p1.nes."" then goto product_specified
$    if .not.f$environment("interactive") then goto bad_string
$    if f$environment("depth") .gt. 1 then goto bad_string
$    inquire p1 "Facility"
$    if p1.eqs."" then goto bad_string
$product_specified:
$!
$!		Single product with separate parameters
$ if p2.eqs."" then goto parse_string
$   number           = 99            ! Set up  number and input_string to
$   input_string     = " "           !   abort product loop
$   product          = p1            ! Product name for Site_products list
$   goto lib_product
$!
$!		Get the multi-product parameter string
$parse_string:
$ input_string = p1
$ if input_string.eqs."*.*" then goto no_wild_card
$!
$!		Initialize counters
$ number        = 0
$ l_max         = f$length(input_string)
$ format        = "/par="
$ format_length = f$length(format)
$!
$!		Main loop over specified products
$product_loop:
$ p2               = ""       ! clear previous Bison product
$ parameters       = ""
$ parameter_string = ""
$ parsed_string    = f$element(number,",",input_string)
$ product          = parsed_string
$ if parsed_string.eqs."," then goto exit
$!
$!		Do we have to parse a quoted string ?
$ length  = f$length(parsed_string)
$ ipar    = f$locate("""",parsed_string)
$ if ipar.eq.length then goto done_parsing
$!
$!		Yes, quoted string, scan for double quotes
$ product_length = ipar-format_length
$ product        = f$extract(0,product_length,parsed_string)
$ previous_char  = ""
$ flag           = "off"
$ icnt           = 0
$ ichar          = ipar+1
$!
$!		Move characters from parsed_string to parameter_string
$parsing_string:
$ character        = f$extract(ichar,1,parsed_string)
$ if ichar.gt.l_max then goto bad_string
$ if character.nes."""".and.flag.eqs."on" then goto finish_parsing
$ if character.eqs."""" then goto set_flag
$ if ichar.eqs.length then goto get_more_of_string
$ parameter_string = parameter_string+character
$ previous_char    = "''character'"
$ ichar            = ichar+1
$ goto parsing_string
$!
$!		Get some more input string, we had an embedded comma
$get_more_of_string:
$ number=number+1
$ parameter_string   = parameter_string+","
$ parsed_string      = parsed_string+","
$ previous_char      = ","
$ flag               = "off"
$ ichar              = ichar+1
$ more_parsed_string = f$element(number,",",input_string)
$ parsed_string      = parsed_string+more_parsed_string
$ length             = f$length(parsed_string)
$ ichar              = ichar+1
$ goto parsing_string
$!
$!		Flag for quote character encountered
$set_flag:
$ icnt = icnt + 1
$ if icnt.eq.2 then icnt = 0
$ previous_char          = character
$ if icnt.eq.0 then flag = "off"
$ if icnt.eq.1 then flag = "on"
$ if icnt.eq.1 then parameter_string = parameter_string+character
$ ichar = ichar + 1
$ goto parsing_string
$!
$!		Closing single quote found
$finish_parsing:
$ parameter_string_length = f$length(parameter_string)-1
$ parameter_srting = f$extract(0,parameter_string_length,parameter_string)
$!
$!		
$done_parsing:
$ number    = number + 1
$ qualifier = "/"+f$element(1,"/",product)
$ if qualifier.eqs."//" then goto lib_product
$!
$!		Bison style single parameter
$!
$ p1          =  f$element(0,"/",product)
$ if   f$extract(0,3,qualifier).eqs."/V="   then  -
  qualifier   =  f$extract(3,f$length(qualifier)-3,qualifier)
$ p2          =  qualifier
$ product     =  p1
$!
$!		Set up from LIB
$lib_product:
$ if f$locate("*",product) .ne. f$length(product) then goto no_wild_card
$!
$! Look first in CCRS:
$ if f$search("ccrs:[''product']setup.com").eqs."" then goto product_third_party
$ if p2.eqs."" then  @ccrs:['product']setup 'parameter_string'
$ if p2.nes."" then  @ccrs:['p1']setup -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$!
$! Look next in THIRD_PARTY:
$product_third_party:
$ if f$search("third_party:[''product']setup.com").eqs."" then goto product_decus
$ if p2.eqs."" then  @third_party:['product']setup 'parameter_string'
$ if p2.nes."" then  @third_party:['p1']setup -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$!
$! Look next in DECUS:
$product_decus:
$ if f$search("decus:[''product']setup.com").eqs."" then goto product_known
$ if p2.eqs."" then  @decus:['product']setup 'parameter_string'
$ if p2.nes."" then  @decus:['p1']setup -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$!
$! Look next in data base of known products
$product_known:
$ this_file = f$environment("procedure")
$ this_area = f$element(0,"]",this_file) + "]"
$ if f$search("''this_area'SITE_PRODUCTS$KNOWN.data").eqs."" -
	then goto sys$product
$ open/read  known_list  'this_area'SITE_PRODUCTS$KNOWN.data
$ read/key="''product'" known_list real /error=unknown_siteproduct
$ close known_list
$ real_product_path = f$element(1,",",real)
$ if p2.eqs."" then @'real_product_path'setup 'parameter_string'
$ if p2.nes."" then @'real_product_path'setup -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$unknown_siteproduct:
$ close known_list
$!
$!		Set up from product$COMMANDS
$sys$product:
$ if f$search("''product'$commands:setup.com").eqs."" then goto sys_product
$ if p2.eqs."" then  @'product'$commands:setup.com  'parameter_string'
$ if p2.nes."" then  @'p1'$commands:setup.com  -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$!
$!		Set up from product_COMMANDS
$sys_product:
$ if f$search("''product'_commands:setup.com").eqs."" then goto bad_product
$ if p2.eqs."" then  @'product'_commands:setup.com 'parameter_string'
$ if p2.nes."" then  @'p1'_commands:setup.com -
  "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"
$ goto product_loop
$!
$!		D I A G N O S T I C S
$bad_product:
$ write sys$output "%SETUP-W-NOTFOUND-> setup file for ''product' not found"
$ exit_value = 0
$ goto product_loop
$!
$bad_string:
$ write sys$output "%SETUP-E-BADSTRING-> bad string"
$ exit_value = 2
$ goto exit
$!
$no_wild_card:
$ write sys$output "%SETUP-E-NOWILDCARD-> no wild card allowed"
$ exit_value = 2
$!
$exit:
$ exit exit_value+%X10000000
