       
C +
          OPTIONS /EXTEND_SOURCE
      PROGRAM SUBTCOPY 
C $$S02  
C                           ******************  
C                           *                *  
C $ NAME                    *    SUBTCOPY    *  
C                           *                *  
C                           ******************  
C 
C $ VERSION 
C	CVF01A 
C  
C $ PURPOSE 
C	This program generates a batch job for the TCOPY program. 
C 
C $ CONSTANTS 
      IMPLICIT NONE  
C                                             
C $ DATA STRUCTURES  
C  
C $ RUNNING SEQUENCE  
C	
C	TYPE	NAME 
C	IN/OUT	DESCRIPTION                
C
C	$ SUBTCOPY/NOTIFY/PRINT/QUEUE=AIR2 MSA0: MFA0: 
C  
C $ COMMON BLOCKS/GLOBALS  
C	TYPE	NAME  
C	IN/OUT	DESCRIPTION  
C  
C $ SUBROUTINES AND FUNCTIONS CALLED  
C	NAME	DESCRIPTION  
C
      INTEGER*4 cli$get_value,cli$present 
      EXTERNAL  cli$get_value,cli$present
C     Command line access routines
C
      EXTERNAL lib$signal
C     Standard signal routine
C              
      INTEGER*4 lib$spawn
      EXTERNAL lib$spawn
C     Operation to execute a DCL command
C  
C $ DESCRIPTION  
C	The command line elements are extracted.  A file called `TCOPY.COM'
C     is opened in the current directory.  The commands to run TCOPY are
C     written to the file.  The file is submitted to batch by spawning
C     a DCL SUBMIT command.
C  
C $ KEY WORDS  
C	TCOPY,BATCH,SUBMIT,OPERATOR 
C  
C $ LOCAL VARIABLES  
C      	TYPE	NAME/DESCRIPTION  
C                 
      CHARACTER*20 indevice
      INTEGER*2 indevicesize
C     Input device as extracted from the command line
C
      CHARACTER*20 outdevice
      INTEGER*2 outdevicesize
C     Output device as extracted from the command line
C
      CHARACTER*20 queuename
      INTEGER*2 queuenamesize
C     Name of the queue to submit the batch job to
C
      CHARACTER*100 queuequalifier
      INTEGER*2 queuequalifiersize
C     buffer to write the queue qualifier for the submit
C
      LOGICAL*1 printlog
C     Flag to print the log file or not
C
      LOGICAL*1 notify
C     Flag to notify the operator that batch job has completed
C
      INTEGER*4 status
C     R0 value of system functions
C
      CHARACTER*255 command
C     DCL submit command to execute
C
      CHARACTER*20 printqualifier
      INTEGER*2 printqualifiersize
C     Print qualifier
C
      CHARACTER*20 notifyqualifier
      INTEGER*2 notifyqualifiersize
C     Notify qualifier
C	  
C $ COMPILER DIRECTIVES  
C
      EXTERNAL cli$_present, ss$_normal, cli$_negated
C     Return values from the CLI routines
C        
C $ REMARKS AND WARNINGS  
C	The batch job is always deleted. 
C  
C $ REFERENCES  
C	SUBTCOPY user manual  
C  
C $ COMPUTER AND OS-VERSION  
C	STORM   VAX/VMS Version 4.7   
C  
C $ COMPILER  
C	FORTRAN-77   version 5.0  
C  
C $ AUTHOR  
C	DD-MMM-YY    NAME		AFFILIATION  
C	23-Jun-1988  R. Venhola         PSL
C  
C $ PROPRIETARY NOTICE  
C	COPYRIGHT (C) 1986  GOVERNMENT OF CANADA  
C	                    (DEPT. OF ENERGY, MINES and RESOURCES).  
C  
C	     This software in all of its forms is proprietary to the  
C	Canada  Centre  For  Remote  Sensing (CCRS) of the Dept.  of  
C	Energy, Mines & Resources of the Government of Canada.  This  
C	software  is  furnished  for use solely on a single computer  
C	system.  This software can be copied only  for  the  use  in  
C	this  single  computer system.  This proprietary information  
C	may not be duplicated or disclosed except  to  employees  or  
C	agents  of  the  firm  or agency owning the computer system.  
C	CCRS assumes no responsibility for the use or reliability of  
C	its software.  
C 
C $ INITIALIZATION   
C 
C $ REVISION HISTORY  
C	DD-MMM-YY VERSION(EDIT)	NAME		REASON  
C	[tbs] 
C -  
         
C     BEGIN

C     Get the input device name.  The routine CLI$GET_VALUE uses the
C     definition of the label in the file SUBTCOPY.CLD.  
      status = cli$get_value('INDEVICE', indevice, indevicesize)
      IF (status .ne. %loc(ss$_normal)) THEN
          CALL lib$signal( %val(status) )
          GOTO 9998
      END IF


C     Get the output device name.
      status = cli$get_value('OUTDEVICE', outdevice, outdevicesize)
      IF (status .ne. %loc(ss$_normal)) THEN
          CALL lib$signal( %val(status) )
          GOTO 9998                                     
      END IF

C     Check if the /PRINT qualifier is present.  By default it is present
C     so that the only check required is if it has been negated.
      printlog = (cli$present('PRINT') .ne. %loc(cli$_negated))

C     Set up the /PRINT qualifier on the submit command
      IF (printlog) THEN
          printqualifier = '/PRINT'
          printqualifiersize = 6
      ELSE
          printqualifier = '/NOPRINT'
          printqualifiersize = 8
      END IF

C     Check if the /NOTIFY qualifier is present.
      notify = (cli$present('NOTIFY') .ne. %loc(cli$_negated))

C     Set up the /NOTIFY qualifier on the submit command
      IF (printlog) THEN
          notifyqualifier = '/NOTIFY'
          notifyqualifiersize = 7
      ELSE
          notifyqualifier = '/NONOTIFY'
          notifyqualifiersize = 9
      END IF

C     Extract the queue definition.  This requires checking if the 
C     queue qualifier is present and then extracting the value of that
C     qualifier.
      IF (cli$present('QUEUE') .eq. %loc(cli$_present)) THEN
          status = cli$get_value('QUEUE', queuename, queuenamesize)
          IF (status .ne. %loc(ss$_normal)) THEN
              CALL lib$signal( %val(status) )
              GOTO 9998                                     
          END IF
          queuequalifier = '/QUEUE='//queuename(:queuenamesize)
          queuequalifiersize = queuenamesize + 7
      ELSE
          queuequalifier = ' '
          queuequalifiersize = 1
      END IF

C     Create the submit command
      command = 'SUBMIT/DELETE TCOPY '//
     1          printqualifier(:printqualifiersize)//
     1          notifyqualifier(:notifyqualifiersize)//
     1          queuequalifier(:queuequalifiersize)


C     Open the output TCOPY.COM command procedure
      OPEN (
     1 UNIT=20,
     1   ACCESS = 'SEQUENTIAL',
     1   CARRIAGECONTROL = 'LIST',
     1   FILE = 'TCOPY.COM',
     1   FORM = 'FORMATTED',
     1   STATUS = 'NEW')

C     Write the commands to run TCOPY.
      WRITE(20,10) indevice(:indevicesize), outdevice(:outdevicesize)
10    FORMAT ('$ SET NOON',/,
     1        '$ RUN RCVEXE:TCOPY'/
     1        A,/,                    ! Enter input device
     1        A,/,                    ! Enter output device
     1        'Y',/,                  ! Print number of records in each file? Y
     1        /,                      ! Number of files to copy - default to all
     1        /,                      ! Output density - default to input
     1        '5')                    ! End menu option 5

C     Close the file
      CLOSE (UNIT=20)          
                               
C     Submit the procedure to batch
      status = lib$spawn( command )
      IF (status .ne. %loc(ss$_normal)) THEN
          call lib$signal(%val(status))
          GOTO 9998
      END IF

C     Skip the error section
      GOTO 9999              

9998  CONTINUE
      WRITE(6,100) 
100   FORMAT(' Error during the execution of program SUBTCOPY.  Either',/,
     1       ' the input DCL command line was incorrect or there is a bug',/,
     1       ' in the program.  Please try the command again, checking the',/,
     1       ' input and report an error if the program fails again.')

9999  CONTINUE
          
      END
