      subroutine hardcopy( code )

      include    'swing.cmn'
      include    '($smgdef)'

      integer    column, num, ii, jj, level, ikey, start, end, len
      integer    code, ll, kk
      character  hard_node*12, dashes*12, out_line(MAX_LINES)*132
      character  one_line*200

      data dashes / '------------' /

      open( unit=1,
     .      name='swing.lis',
     .      carriagecontrol='list',
     .      status='new',
     .      err=99 )

      call print_message( 'Creating hardcopy listing in SWING.LIS', 0 )

      last_level = 1
      line = 0
      do ii = 0, MAX_LEVELS
         last_line(ii) = 1
      end do
      do ii = 1, num_lines
         out_line(ii) = ' '
      end do

      do jj = 1, num_lines
         do level = 0, MAX_LEVELS
            if ( node_pointer(level,jj) .ne. 0 ) then
               num = node_pointer(level,jj)

               column = level * 17 + 1
               line = node(num).line

               call str$trim( hard_node, node(num).name, len )
               if ( level .lt. 7 ) then
                  if ((node_pointer(level+1,jj).ne.0).and.(len.lt.12))
     .               hard_node = hard_node(1:len)//dashes(len+1:12)
                  end if

               out_line(line)(column:column+11) = hard_node
               if ( level .gt. 0 ) then
                  out_line(line)(column-3:column-1) = '---'

                  if ( level .le. last_level ) then
                     out_line(line)(column-3:column-3) = '+'
                     if ( out_line(line-1)(column-3:column-3) .eq. '+' )
     .                  out_line(line-1)(column-3:column-3) = '|'

                     else if ( level .eq. last_level + 1 ) then
                     out_line(line)(column-5:column-2) = '----'
                     end if

                  if ( level .lt. last_level ) then
                     if ( out_line(last_line(level))(column-3:column-3)
     .                    .eq. '+' ) then
                        ll = last_line(level)
                        else
                        ll = last_line(level) + 1
                        end if
                     do kk = ll, line-1
                        out_line(kk)(column-3:column-3) = '|'
                     end do
                     end if
                  end if

               last_level = level
               last_line(level) = line
               end if
         end do
      end do

      do ii = 1, num_lines
         call str$trim( out_line(ii), out_line(ii), len )
         write( 1, 100 ) out_line(ii)(1:len)
100      format( a )
      end do

      call print_message( 'Finished creating SWING.LIS',
     .                    0 )

      close( unit=1 )

      return

99    call print_message( 'Unable to open file for hardcopy', 0 )
      return
      end
