      subroutine pd_load_bar( width, pd_choices )

*     PD_LOAD_BAR( WIDTH, PD_CHOICES )
*     
*     WIDTH          INTEGER*4
*     PD_CHOICES     RECORD /PD_CHOICE_TYPE/  (PULLDOWN.CMN)
*
      implicit none
      include '($smgdef)'
      include 'pulldown.cmn'

      integer smg$create_virtual_display, smg$change_virtual_display
      integer max_cell, ii, jj, kk, lens(PD_MAX_CHOICES)
      integer start_pos, off_set, width, istat
      record /pd_choice_type/ pd_choices

C     FIND OUT HOW MANY CHOICES THERE ARE AND THE MAXIMUM LENGTH
      ii = 1
      max_cell = 0
      do while ( ii .le. pd_choices.number )
         call str$trim( pd_choices.choice(ii), pd_choices.choice(ii), 
     .                  lens(ii) )
         max_cell = max( max_cell, lens(ii) )         
         ii = ii + 1         
      end do
      ii = ii - 1
      
C     CREATE THE VIRTUAL DISPLAY FOR THE BAR
      if ( pd_bar_id .eq. 0 ) then
         istat = smg$create_virtual_display( 1, width, pd_bar_id,,
     .                                       smg$m_reverse )
         else
         call smg$erase_display( pd_bar_id )
         istat = smg$change_virtual_display( pd_bar_id, 1, width, 
     .                                       pd_bar_id,, smg$m_reverse )
         end if

C     FIGURE OUT THE LENGTH OF EACH CELL

C     IF THERE IS ROOM ENOUGH FOR ALL OF THE CHOICES AS IS
      if ( (ii*max_cell) .le. width ) then
         pd_cell_size = min( 16, width / ii )

C        MAKE IT 16 OR LESS
         else
         pd_cell_size = min( 16, width / max_cell )
         end if

C     PUT THE CHOICES IN THE MENU
      do jj = 1, ii
         start_pos = 1 + (pd_cell_size*(jj-1))
         off_set = max( 1, pd_cell_size-lens(jj)) / 2
         call smg$put_chars( pd_bar_id, 
     .                       pd_choices.choice(jj)(1:lens(jj)),,
     .                       start_pos + off_set )
      end do      

      pd_num_choices = ii

      return
      end
