      subroutine update_file_window

c     Craig Young               3-AUG-87

c     This subroutine updates the filer window to reflect movement of the
c     cursor and scrolling.

      include    'swing.cmn'
      include    '($smgdef)'

      integer    ii

      call smg$begin_pasteboard_update( board_id )

c     Check if scrolling required.  If so, scroll as required.

	if ( file_num .gt. top_file_line+files_per_screen ) then
	    top_file_line = min(file_num-files_per_screen,
     .			        num_files-files_per_screen-2)

	  else if ( file_num .lt. top_file_line+2 ) then
	    top_file_line = max(1,file_num-2)

         end if

      call smg$set_cursor_abs( file_window, 1, 1 )

      do ii = top_file_line, top_file_line+files_per_screen+2
         call smg$put_line( file_window, fnode(ii).name )    !Reprint file names
      end do                                                 !for new range

      call smg$change_rendition( file_window, 
     .                           file_num - top_file_line + 1,
     .                           2, 1, 34, smg$m_reverse )

      call smg$end_pasteboard_update( board_id )

      return
      end
