C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************

C This is file Cursor_Movement.For 

C		Contents:
C	DnArrow and UpArrow
C	Page
C	GoTop and GoBot
C	Top_Of_Screen and Bottom_Of_Screen


C-------------------------------------------------------------------C
C Downarrow was entered.  Move the cursor down one line on the CRT. C
C-------------------------------------------------------------------C
       Subroutine DnArrow
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	If ((Current_Line .EQ. Last_File) .OR.
	1   (Current_Line .EQ. LastLine )) then  !Show border if needed.
		If (Current_Line .GT. (TopLine + 20)) then
			TopLine = Current_Line - 20   
			If (TopLine .EQ. 2) TopLine = 3
			Call Write22
		End If
		GoTo 9999

	Else If  (Current_Line .EQ. Last_Dir) then
		If (First_File .GT. Current_Line) then
			Call Make_Dull
			Current_Line = First_File
		Else
			GoTo 9999
		End If
	Else
		Call Make_Dull
		Current_Line = Current_Line + 1
	End If


	If (Current_Line .GT. (TopLine + 21)) then

		TopLine = Current_Line - 21   

C	      	CHECK FOR CONDITION (BUG) WHICH CRASHES SMG$
		If (TopLine .EQ. 2) TopLine = 3

		Call Write22
	End If

9999	Return
        End

C-------------------------------------------------------------------C
C Up arrow was entered.  Move the Cursor up one line on the CRT.    C
C-------------------------------------------------------------------C
       Subroutine UpArrow
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	If (Current_Line .EQ. First_Dir) then
		If (TopLine .NE. 1) Call GoTop
		GoTo 9999
	End If

	If ((NumFiles + NumDirs) .EQ. 0) GoTo 9999

	If  (Current_Line .EQ. First_File) then
		If (Last_Dir .GT. 0) then
			Call Make_Dull
			Current_Line = Last_Dir
		Else
			If (TopLine .NE. 0) Call GoTop
			GoTo 9999
		End If
	Else
		Call Make_Dull
		Current_Line = Current_Line - 1
	End If


	If (Current_Line .LT. TopLine) then
		TopLine = Current_Line

C	      	CHECK FOR CONDITION (BUG) WHICH CRASHES SMG$
		If (TopLine .EQ. 2) then
			TopLine = 1
		End If

		Call Write22
	End If



9999	Return
        End


C-------------------------------------------------------------------C
C The page key was entered.  Display the next page of data.         C
C-------------------------------------------------------------------C
       Subroutine PAGE
       Implicit Integer*4 (A - Z)
       Integer*4 Cl_At_Entry
       Include 'Common.Dat'
C-------------------------------------------------------------------C

C 	CHECK SIMPLE CASES FIRST

	If ((LastLine .LE. 42) .OR.
	1   ((Forward) .AND. ((LastLine-TopLine).LE.40)) .OR.
	2   ((.NOT.Forward) .AND. (TopLine .LE. 22))) then

	        Cl_At_Entry  = Current_Line
		If (Forward) then
			Call GoBot
			If (Cl_At_Entry .GE. TopLine)
	1		    Current_Line = Cl_At_Entry
		Else
			Call GoTop
			If (Cl_At_Entry .LE. (TopLine+21))
	1		    Current_Line = Cl_At_Entry
		End If

		GoTo 500


C	OTHERWISE, IT AIN'T SO SIMPLE...


	Else If (Forward) then
		TopLine = TopLine + 20
		If (Current_Line .GE. TopLine) GoTo 400

	        Call Make_Dull	
		Current_Line = Current_Line + 20
		If (Current_Line .LT. First_File) then
			If (Current_Line .GT. Last_Dir)
	1		     Current_Line = Last_Dir
		Else
			If (NumFiles .LE. 0) 
	1		     Current_Line = MIN(Current_Line,Last_Dir)
		End If

	Else   ! Reverse
		TopLine = TopLine - 20
		If (Current_Line .LE. (TopLine+21)) GoTo 400

	        Call Make_Dull	
		Current_Line = Current_Line - 20
		If (Current_Line .GT. Last_Dir) then
			If (Current_Line .LT. First_File)
	1		     Current_Line = First_File
		Else
			If (NumDirs .LE. 0)
	1		     Current_Line = MAX(Current_Line,First_File)
		End If
	End If


400	Call Write_Screen


500    Return
       End

C------------------------------------------------------------------C
C Change display to start at line 1 and put cursor there.          C
C	<GOLD> T
C------------------------------------------------------------------C
       Subroutine GoTop
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C------------------------------------------------------------------C

	Call Make_Dull

        If (TopLine .NE. 1) then
        	TopLine = 1
        	Call Write22
        End If

	Current_Line = FirstUsed

C	  Not Necessary to Validate Cursor!

	If (.NOT.Forward) then
		Forward = .TRUE.
		Line23_Dirty = .TRUE.
	End If

       Return
       End

C------------------------------------------------------------------C
C Change display to contain the bottom of the data, 
C and put the cursor there.
C	<GOLD> B
C------------------------------------------------------------------C
       Subroutine GoBot
       Implicit Integer*4 (A - Z)
       Logical Same	
       Include 'Common.Dat'
C------------------------------------------------------------------C

	Call Make_Dull

	Top_At_Entry = Topline                                          
        TopLine = MAX(1, LastLine - 19)   !Show bottom with 2 empties.
	If (TopLine .EQ. 2) TopLine = 1   !Pathological case

	If (TopLine .NE. Top_At_Entry) Call Write22

	If (FirstUsed .EQ. 7) then
		Current_Line = 7
	Else If (NumFiles .GT. 0) then
		Current_Line = Last_File
	Else
		Current_Line = Last_Dir
	End If


500	If (Forward) then
		Forward = .FALSE.
		Line23_Dirty = .TRUE.
	End If

        Return
        End

C-------------------------------------------------------------------C
C Top of screen was entered.  Move the cursor to the first file on the CRT.
C
C-------------------------------------------------------------------C
       Subroutine Top_of_Screen
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	If (Current_Line .NE. TopLine) then
		Call Make_Dull
	Else
		GoTo 500
	End If
                            
        IF (Topline .LE. FirstUsed) then      ! No files or top page.
		Current_Line = FirstUsed
	Else If (TopLine .LE. Last_Dir) then
		Current_Line = MAX(TopLine, First_Dir)
	Else
		Current_Line = MAX(TopLine, First_File)
        END IF

500     Return
        End !top of screen

C-------------------------------------------------------------------C
C Bottom of screen was entered.  Move the cursor to the last file on the CRT
C-------------------------------------------------------------------C
       Subroutine Bottom_of_Screen
       Implicit Integer*4 (A - Z)
       Integer*4 BotLine	
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	If ((Current_Line .EQ. LastLine) .OR.
	1   (Current_Line .EQ. Last_File)) then
		GoTo 500
	Else
		Call Make_Dull
	End If

	BotLine = TopLine + 21

        IF (Botline .GE. LastLine) then
		If (NumFiles .GT. 0) then
			Current_Line = Last_File
		Else If (NumDirs .GT. 0) then
			Current_Line = Last_Dir
		Else
			Current_Line = FirstUsed
		End If
	Else If (BotLine .LE. Last_File) then
		If (BotLine .GE. First_File) then
			Current_Line = BotLine
		Else
			Current_Line = MIN(BotLine, Last_Dir)
		End If
	Else
		Current_Line = MIN(BotLine, Last_Dir)
	End If

500    Return
       End !Bottom of screen
