C*****************************************************************************
C
C	OPERATIONS FOR -
C      	DELETE A SINGLE DIRECTORY TREE
C
C   (Version 6.x)            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C  Modified Oct 86 - (V6.8) D.E.C.
C	Fix problem with trying to delete a .DIR file which isn't a directory.
C
C*****************************************************************************

C-------------------------------------------------------------------C
C Delete one Directory Tree
C-------------------------------------------------------------------C
        Subroutine Delete_Directory_Tree (Didit)
        Implicit Integer*4 (A - Z)
        Logical Didit
        Character*1 Answer
        Include 'Common.Dat'
	Integer*2 Last_Left_Dir(Max_Stack)
        Character*(Files_Display_Width) FileName
C-------------------------------------------------------------------C

	Do I = 1, Max_Stack
		Last_Left_Dir(I) = 0
	End Do

	StkIndex = 0
C-------------------------------------------------------------------C
C		NOTE: This is the key to the whole thing.  We must begin
C			at the top of the stack.
C-------------------------------------------------------------------C

	Didit      = .TRUE.

100	CONTINUE
	If (StkIndex .GE. Max_Stack) then
		Call Mess_Wait ('Exceeded Maximum Tree Depth')
C		UNWIND STACK
		GoTo 599
	End If

	If (.NOT.All_Delete)Call SMG$Erase_Display(Delete_File_Display)

	Old_Stack_Index = StkIndex
	Call PushStack

C		If we can't push the stack, we must have a .DIR file which
C		isn't a real directory.  We will have a confirmation (if
C		needed) - so just delete the file and handle as if we had
C		done a delete_leaf.
	If (StkIndex .LE. Old_Stack_Index) then  ! Couldn't Push Stack
	   If (Files_Only_Delete) then
		Didit = .FALSE.
	   Else
		Call Delete_One_File (Didit)
	   End If
		GoTo 250
	End If

	If (NumDirs .GT. 0) then
		Current_Line = MAX( Current_Line,
	1			Last_Left_Dir (StkIndex) + 1)

		If ( (All_Delete)
	1	.OR. (Remainder_Delete)
	2	.OR. (Files_Only_Delete)) then
			Call Make_Bright
			GoTo 100
		End If

	Call SMG$Begin_Display_Update (Delete_Operation_Display)
	Call SMG$Put_Chars (Delete_Operation_Display, 
	1    	'e   Sub-Directory Tree?           ',1,7)
		Call SMG$Change_Rendition (Delete_Operation_Display,
	1		1,11,1,13,SMG$M_Bold)
	Call SMG$End_Display_Update (Delete_Operation_Display)

150     Call GetName(Current_Line, FileName, Itsa_Dir)

	Call Delete_Answer2 (FileName, Answer)

	If (Answer .EQ. 'Y')   then
		GoTo 100  ! Down another directory

	Else If (Answer .EQ. 'N') then
		If (Current_Line .GE. Last_Dir) then
			Last_Left_Dir (StkIndex) = 0
			GoTo 200   ! We're through with this level
		Else
			Last_Left_Dir (StkIndex) = Current_Line
			Current_Line = Current_Line + 1
			GoTo 150 ! Try next directory
		End If
		
	Else If (Remainder_Delete)   then
		All_Delete = .TRUE.
		Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

		Call SMG$Put_Chars (Delete_Operation_Display, 
	1		'ing Directory Tree                ',1,7)
		Call SMG$Change_Rendition (Delete_Operation_Display,
	1		1,11,1,9,SMG$M_Bold)

		Call SMG$UnPaste_Virtual_Display (Delete_Menu_Underlay_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_Menu1_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_Menu2_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_File_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display 
	1		(Delete_Op_Underlay_Display, Pasteboard_ID)

		Call SMG$End_Pasteboard_Update (Pasteboard_ID)

		GoTo 100  ! Down another directory

	Else If (Quit_Delete) then
C		UNWIND STACK
		GoTo 599

	Else   ! Should never happen
		GoTo 100
	End If

	END IF ! (NumDirs .GT. 0)

C	WE ARE IN A DIRECTORY WITH ONLY FILES (NO SUBDIRECTORIES).

200	Call Delete_Leaf (Didit)
C		NOTE THAT DELETE_LEAF RETURNS AT THE NEXT HIGHER
C			STACK LEVEL!!!


C		NORMAL EXIT IS HERE
250	If (StkIndex .LE. 0) GOTO 600


	If (Quit_Delete) then
C		UNWIND STACK   
		GoTo 599                                                

	End If

C	NOW, CHECK TO SEE IF WE HAVE ANY MORE DIRECTORIES TO CHECK
C	AT THIS LEVEL.

	If (NumDirs .LE. 0) then
		GoTo 200

	Else If (Didit) then   ! Current_Line may be correct
		If ((Current_Line .LE. Last_Left_Dir (StkIndex)) .OR.
	1	    (Current_Line .GT. Last_Dir))    then
			Last_Left_Dir (StkIndex) = 0
			GoTo 200   ! We're through with this level
		Else  ! Current_Line should be correct
			If ((All_Delete).OR.(Remainder_Delete))
	1			 Call Make_Bright
			GoTo 100
   		End If

	Else  ! Didn't delete directory
		If (Current_Line .GE. Last_Dir) then
			Last_Left_Dir (StkIndex) = 0
			GoTo 200   ! We're through with this level
		Else
			Last_Left_Dir (StkIndex) = Current_Line
			Current_Line = Current_Line + 1
			If ((All_Delete).OR.(Remainder_Delete))
	1			 Call Make_Bright
			GoTo 100
		End If
	End If

	GoTo 600

C		UNWIND STACK
599		Call SMG$Begin_Display_Update (Delete_Operation_Display)
		Call SMG$Put_Chars (Delete_Operation_Display, 
	1		'ing Nothing Else                  ',1,7)
		Call SMG$Change_Rendition (Delete_Operation_Display,
	1		1,11,1,12,SMG$M_Bold)
		Call SMG$End_Display_Update (Delete_Operation_Display)
		Call SMG$UnPaste_Virtual_Display 
	1		(Delete_Op_Underlay_Display, Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_File_Display,
	1	    	Pasteboard_ID)
		Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)
		Call SMG$UnPaste_Virtual_Display (Delete_Menu2_Display,
	1		Pasteboard_ID)
		Call SMG$UnPaste_Virtual_Display 
	1		(Delete_Menu_Underlay_Display,Pasteboard_ID)
		Call SMG$End_Pasteboard_Update (Pasteboard_ID)

598    		Call PopStack
		If (StkIndex .GT. 0) GOTO 598

600	Return
	End

C-------------------------------------------------------------------C
C Delete "LEAF" (All files, plus associated .DIR at next level up.
C	Must be entered at the point where there are only files.
C	Does a "Popstack", so it ends at the next higher level.
C-------------------------------------------------------------------C
        Subroutine Delete_Leaf (Didit)
        Implicit Integer*4 (A - Z)
	Integer*4 Status
        Logical Didit, Didwe
        Character*1 Answer
        Include 'Common.Dat'
C-------------------------------------------------------------------C


C  AT THIS POINT, WE USUALLY HAVE NO DIRECTORIES - JUST 0 OR MORE FILES
C	AT ANY RATE, OUR TASK IS TO DELETE ALL OF THE FILES.

	Didit = .TRUE.  ! Assume success

	If (NumFiles .GT. 0) then
		Call Delete_All_Files (Didwe)
		If (Quit_Delete) GoTo 500
	Else If (Files_Only_Delete) then
     		Didwe = .FALSE.
	Else
		Didwe = .TRUE.
	End If

	If (NumDirs .GT. 0) Didwe = .FALSE.

	If (.NOT.All_Delete)
	1	Call SMG$Erase_Display (Delete_File_Display)

C-------------------------------------------------------------------C
	Call PopStack  !!!!!!!!!!!!!!!!
C-------------------------------------------------------------------C

C		NOW FOR THE DIRECTORY FILE:
	If (Didwe) then
		If ((All_Delete).OR.(Remainder_Delete)) then
			Call Delete_One_File (Didwe)
			If (.NOT.Didwe) Didit = .FALSE.
			Remainder_Delete = .FALSE.
		Else
			Call SMG$Begin_Display_Update 
	1			(Delete_Operation_Display)
			Call SMG$Put_Chars (Delete_Operation_Display, 
	1		      'e   Directory File?                 ',1,7)
			Call SMG$Change_Rendition 
	1		  (Delete_Operation_Display,1,11,1,9,SMG$M_Bold)
			Call SMG$End_Display_Update 
	1			(Delete_Operation_Display)
			Call Confirm_Delete_File (Didit)
			If (.NOT.Didwe) Didit = .FALSE.
		End If          
	Else
		Didit = .FALSE.
	End If !Didwe

500	Return
	End

C-------------------------------------------------------------------C
C Delete All Files
C-------------------------------------------------------------------C
        Subroutine Delete_All_Files (Didit)
        Implicit Integer*4 (A - Z)
	Integer*4 Status, Last_Left_File
        Logical Didit, Didwe, XX
        Character*1 Answer
        Include 'Common.Dat'
C-------------------------------------------------------------------C


	Didit      = .TRUE.

	If (NumFiles .LE. 0) RETURN
	Didwe      = .TRUE.
	Last_Left_File = 0


	If (Confirm_Delete) then

		Call SMG$Begin_Display_Update (Delete_Operation_Display)
		Call SMG$Put_Chars (Delete_Operation_Display, 
	1		'ing Confirmed Regular Files       ',1,7)
		Call SMG$Change_Rendition (Delete_Operation_Display,
	1		1,11,1,7,SMG$M_Bold)
		Call SMG$End_Display_Update (Delete_Operation_Display)
                               
   	End If
        

	If ((All_Delete) .AND. (NumDirs .LE. 0)) then
	    If (Files_Only_Delete) then
C			CONSTRUCT STRING FOR LIB$DELETE
		NHold = WildCard
		K = Lib$MatchC(' ', NHold)
		L = Lib$MatchC(';', NHold)
		If (L .LE. 0) then   ! We need to add something to the wildcard
			L = Lib$MatchC('.', NHold)

			If (L .GT. 0) then   ! There's a . but no ;
				NHold(K:) = ';*'
			Else                 ! There's no . either
				NHold(K:) = '.*;*'
			End If	
		Else
     			If (NHold(L+1:)   .EQ. ' ') then
			    NHold(L+1:L+1) =   '*'
			End If
		End If


		Status = Lib$Delete_File (%Descr(NHold))

		If (.NOT.Status) then
			Call Get_FileNames (XX, Normal_Mode)
			If (NumFiles .GT. 0) Call Mess_Wait 
	1		(' Couldn''t delete some Wildcard files in '//
	2		 'this Directory')
		End If

	    Else

		Status = Lib$Delete_File 
	1		(%Descr('*.*;*'))
		If (.NOT.Status) then
			Call Get_FileNames (XX, Normal_Mode)
			If (NumFiles .GT. 0) then
              			Didit = .FALSE.
				Call Mess_Wait 
	1 	  (' Couldn''t delete some files in this directory')
			End If
		End If
		RETURN
	    End If

C	   We get here for Confirms & Cases where there are directory files.

	Else If (.NOT.All_Delete) then ! Confirms

C		DO I = First_File, Last_File   ! But Last_File is changing!
		Current_Line = First_File		

100		If ((Remainder_Delete) .OR. (All_Delete)) then
   			Call Delete_One_File (Didwe)
   			If (.NOT.Didwe) Didit = .FALSE.
   		Else
   			Call Confirm_Delete_File (Didwe)
   			If (.NOT.Didwe) Didit = .FALSE.
   			If (Quit_Delete) GoTo 600
   		End If

   		If (Didwe) then
   			If ((NumFiles .EQ. 0) .OR.
	1		    (Current_Line .LE. Last_Left_File)) then
				GoTo 600
			Else  ! Current_Line should be correct
				If (Current_Line .GT. Last_File) then
					GoTo 600
				Else
					GoTo 100
				End If
			End If
	
		Else If (Current_Line .GE. Last_File) then
			GoTo 600
		Else
			Last_Left_File = Current_Line
		    	Current_Line = Current_Line+ 1
			GoTo 100
		End If
C		End DO

C		CASES WHERE THERE ARE DIRECTORY FILES (NOT CONFIRMS)
C		Delete in reverse for screen efficiency.
	Else  !  
		DO I = Last_File, First_File, -1
		Current_Line = I

 		Call Delete_One_File (Didwe)
   		If (.NOT.Didwe) Didit = .FALSE.

		End DO

	End If

600	CONTINUE
	If (Files_Only_Delete) Didit = .FALSE.
	Return
	End

