C-------------------------------------------------------------------C
C  Directory Management        January 1983                         C
C  Written by John C. Hayre, Texas Instruments                      C
C  Send suggestions and/or complaints to:                           C
C                                                                   C
C               Veeco Integrated Automation			    C
C               10355 Brockwood Rd				    C
C               Dallas, Texas 75238                                 C
C               (Attention John Hayre)                              C
C                                                                   C
C  Phone: 214-349-8482                                              C
C-------------------------------------------------------------------C
C  Extensive revisions and improvements made by:
C
C                            Rich Gregory
C                 Pharmaceutical Research Associates
C                           Rt  1, Box 380
C                     Charlottesville, VA 22901
C                           (804) 971-8182
C
C***********************************************************************
C
C  Revisions (Version 6.xA)            May-August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C       MS/J957, PO Box 1663, Los Alamos, NM 87545
C	(505) 667-3270
C
C  Code cleanup, generalization, and added "utilities"
C  Major Purposes: Supply a "WPS+/A1"-like interface.
C                  Convert to SMG$ with window presentation
C
C  Added capability for fractional version numbers, which started
C	with version 6.0A  (All 'A' versions are successors of
C	this major revision).
C
C  Converted to SMG$, and supplied an efficient subprocess interface to
C	allow staying within DM for most operations.
C
C  VERSION 6.8A
C
C  Added * (Tree Command), Interface with SD Stack, Checking of .DIR
C	files - Dale E. Coy
C
C  THRU VERSION 7.1A
C 	Dale E. Coy  6-APR-1987
C
C  Misc. bug fixes and performance improvements.
C	
C  THRU VERSION 8.005A
C	Dale E. Coy 16-SEP-1988
C  Improvements and fixes for VMS V5.0	
C
C***********************************************************************
C
C-------------------------------------------------------------------C
C MainLine for 'Directory Management':                              C
C                                                                   C
C Purpose: List the files in a directory and allow the user to      C
C look at individual files, or look at other directories.  The 24th C
C line on the CRT gives a list of single letter commands that can   C
C be envoked.  The following is a PARTIAL list of these commands:   C
C	See Help (PF2) for complete list.
C                                                                   C
C   PF2 Instructions for user to use this program                   C
C   E   Edit file                                                   C
C   F   FMS editor
C   V   View a file or directory                                    C
C   T   Tag files for a multiple file operation                     C
C   U   Untag files (undo the I command above)                      C
C   M   Show more information about the files                       C
C   L   Show less information about the files (Makes Screen faster) C
C   Q   Quit                                                        C
C   X   Exit
C   G   Purge this directory                                        C
C   R   Rename a file                                               C
C  *D   Delete a file(s) or directory(s) or both                    C
C  *C   Copy file(s) to a file                                      C
C                                                                   C
C  * - Multiple file operations that may use include/exclude        C
C  * - Included files can also be used with any DCL spawned command C
C      Dcl is spawned by 1st typing the Gold, 7 keys.  Instructions C
C      for spawning DCL are given after typing GOLD 7.              C
C                                                                   C
C In addition to these single letter commands, a DCL command may be C
C done by entering Gold 7.  After the DCL command is finished the   C
C program returns to the directory that the user was examining.     C
C-------------------------------------------------------------------C
C	Most of the following is no longer accurate, but it is
C	preserved to maintain the code history.
C-------------------------------------------------------------------C
C 4.1 RTGREGORY : 4/10/85 Removed vt100 check from setchan.mar and 
C		increased the length of the file-name variable (log_name)
C------------------------------------------------------------------
C Program version 4 : June 17, 1983  John C. Hayre                  C
C   Put version number on screen and made '2' be show function as   C
C   well as 's'.                                                    C
C-------------------------------------------------------------------C
C Program version 3 : Dec 9, 1982  John C. Hayre                    C
C   Fixed some problems with copy.  Also changed the showfile find  C
C   function to display all the strings sought on the screen with   C
C   reverse video.                                                  C
C-------------------------------------------------------------------C
C Program version 2 : Aug 9, 1982  John C. Hayre                    C
C   Fixed several problems that came about due to version 3.0 of VMSC
C-------------------------------------------------------------------C
C Program version 3 : Oct 7, 1982  John C. Hayre                    C
C   Added the ability to do DCL from the program and return.  This  C
C   is accomplished by using the VMS 3.0 Spawn command.             C
C-------------------------------------------------------------------C
       Program DM

       Implicit Integer*4 (A - Z)

       Logical Did_Not_Load	
       Character*1 Com
       Character*250 Symbol

       Include 'Common.Dat'

C	   LOCAL - SET THESE TO SUFFICIENT SIZE FOR DEFAULTS
       Character*3 	  Default_Editor
	       Parameter (Default_Editor = 'TPU' )

       Character*3 	  Default_Viewer	
	       Parameter (Default_Viewer = 'TPU')		

       Character*5 	  Default_Print_Command	
	       Parameter (Default_Print_Command = 'PRINT')		

       Character*2 	  Default_Printer_Type	
	       Parameter (Default_Printer_Type = 'LP')		

C-------------------------------------------------------------------C
C	  Structure for Exit Handler
        Integer Exit_Status

       	Structure /Exit_Descriptor/
	  Integer Link,
	2 Addr,
	2 Args /1/,
	2 Status_Addr
	End Structure

	Record /Exit_Descriptor/ Handler

	External DM_Exit_Handler

	Handler.Addr = %Loc(DM_Exit_Handler)
	Handler.Status_Addr = %Loc(Exit_Status)

	Call Sys$Dclexh (Handler)
C-------------------------------------------------------------------C
C
       Version = 80 !  Current version number. . . . . . . 

C       file_attr_pos = 33	!where 'more' info starts on the line
C                                  (Set in COMMON.FOR)
C-------------------------------------------------------------------C
C
C
       Stat = SYS$Assign('TT', TT_Channel,,)
       If (.not. Stat) Call Lib$Stop(%Val(Stat))

C-------------------------------------------------------------------C
C	Set Wildcard, Editor, and Viewer.
C-------------------------------------------------------------------C
                                        
C Wildcard:             
       WildCard = ' '	
       Call Lib$GET_Symbol(%Descr('DM$WildCard'), %Descr(WildCard))

C	   IFF DM$wildcard was not defined or is empty, then use "*"

	If ((Ichar(WildCard(1:1)) .EQ. 0) 
	1	.OR. (WildCard(1:1) .EQ. ' ')) then
		          WildCard='*'
			  WildCard_length = 1
	Else
C		Trim Leading Blanks, if any.
8		If (WildCard(1:1) .EQ. ' ') then
			WildCard = WildCard(2:)
			GoTo 8
		End If

	End If 


	Call Str$UpCase (%Descr(WildCard),%Descr(WildCard))
	Call Str$Trim (%Descr(WildCard),%Descr(WildCard),
	1	%Ref(WildCard_Length))
	If (WildCard_Length .LE. 0) WildCard_Length = 20

C 	See if we can get the information from SYS$LOGIN:DM_DEFAULTS.COM
	
	Open (Unit=1, File='SYS$LOGIN:DM_DEFAULTS.COM', Readonly, Shared,
	1		Carriagecontrol='NONE', Organization='SEQUENTIAL',
	2		Status='OLD', Err=201)
210	Format (23X,A)	
	Read (1,210,End=201,Err=201) Editor
	Read (1,210,End=202,Err=202) Viewer
	Read (1,210,End=203,Err=203) Print_Command
	Read (1,210,End=204,Err=204) Printer_Type
	GoTo 205
	
C Editor:	
201	Editor = ' '	
	Call Lib$GET_Symbol(%Descr('DM$Editor'), %Descr(Editor))

C	   IFF DM$Editor was not defined or is empty, then use Default

	If ((Ichar(Editor(1:1)) .EQ. 0) 
	1	.OR. (Editor .EQ. Blanks)) then 
	       	            Editor = Default_Editor
	End If 

C Viewer:	
202	Viewer = ' '	
	Call Lib$GET_Symbol(%Descr('DM$Viewer'), %Descr(Viewer))

C	   IFF DM$Viewer was not defined or is empty, then use Default

	If ((Ichar(Viewer(1:1)) .EQ. 0) 
	1	.OR. (Viewer .EQ. Blanks)) then
	       	            Viewer = Default_Viewer
	End If 

	
C Print Command:	
203	Print_Command = ' '	
	Call Lib$GET_Symbol(%Descr('DM$Print_Command'), 
	1	%Descr(Print_Command))

C	   IFF DM$Print_Command was not defined or is empty, then use Default
                   
	If ((Ichar(Print_Command(1:1)) .EQ. 0) 
	1	.OR. (Print_Command .EQ. Blanks)) then
		            Print_Command = Default_Print_Command
	End If 

	
C Printer Type
204	Printer_Type = ' '	
	Call Lib$GET_Symbol(%Descr('DM$Printer_Type'), 
	1	%Descr(Printer_Type))

C	   IFF DM$Printer_Type was not defined or is empty, then use Default
                   
	If ((Ichar(Printer_Type(1:1)) .EQ. 0) 
	1	.OR. (Printer_Type .EQ. Blanks)) then
		            Printer_Type = Default_Printer_Type
	End If 

205	Close (Unit=1, Err=206)
	
C Highlighting
206	Call Lib$GET_Symbol(%Descr('DM$Highlight'), 
	1	%Descr(Com))

C	   IFF DM$Highlight was not defined or is not 'N', then use Default
                   
	If (Com .EQ. 'N') then 
		Highlight = .FALSE.
	End If 

	
C-------------------------------------------------------------------C
C	Now - if this is the first time into DM, DM$SYM1 will be 'Y'
C	(as set by DM.COM) - otherwise, it'll be something else.
C-------------------------------------------------------------------C

	Call Save_Entering_Terminal		 ! Save terminal status
	Call WriteTerm (LargeScreen)		 ! Make sure scrolling OK
	Call Set_Terminal_NoLine_Edit		 ! So we can use F6, etc.
	
        Stat = Lib$GET_Symbol('DM$SYM1', Symbol)
        If (.NOT. Stat) Call Lib$Stop(%Val(Stat))

        Com = Symbol(1:1)	

	If (Com .NE. 'Y') then   ! Just returned from using '%'
C 			Restore the terminal, position to the
C 			bottom line, and eat anything typed.
		Call WriteTerm (Char(10)//CSI//'24;1H')
		Call Lib$Get_Command (%Descr(Symbol),'$ ')
	End If


	Call Create_SMG_Environment
       
	Call Get_Stack (Cmd)
         

C-------------------------------------------------------------------C
C Read (or ReLoad) all files into the data array                    C
C-------------------------------------------------------------------C

100    Call Get_FileNames ( Did_Not_Load, Menu ) ! Get the file names.
C		   Get_FileNames guarantees a "good" cursor position.

       If (Did_Not_Load) then              ! Error from Get_FileNames
         Exit_Com = 'zzzz' 
         Goto 9999
       Else
	 Call Write_Screen
	 Call SMG$End_Pasteboard_Update (Pasteboard_ID)	
	 Call SMG$End_Pasteboard_Update (Pasteboard_ID)	
       End If


C-------------------------------------------------------------------C
C Loop here waiting for valid command.                              C
C-------------------------------------------------------------------C

200	Continue

       If (Have_Broadcast) then
		Call Mess_Wait (Broadcast_Msg)	
C 			Mess_Wait can set DM_Exit for '!'
		If (DM_Exit) 	GoTo 9999
		Have_Broadcast = .FALSE.
       End If	

       If (Line23_Later) then
		Line23_Dirty = .TRUE.
		Line23_Later = .FALSE.
       End If
		

       If ((Menu .EQ. Info_Mode)           .and.        !PRINT MORE INFO
	1       (.NOT.Have_More     ))	
	2             Call Info

       Call Make_Bright

       Call GET1Char(CMD)        ! Wait for keyboard input.

C-------------------------------------------------------------------C
C Handle command:                                                   C
C	First: There are "normal" characters and "special" 
C		characters.  The "special" ones all start with 
C		ESCAPE  [Char(27)].
C
C   Calling Structure is........
C	Normal_Keys or
C	Special_Keys: Handle arrow keys or call...
C		Function_Keys or
C		Keypad_Keys: Handle keypad commands except PF1 or call...
C			Gold_Keys
C
C-------------------------------------------------------------------C
C
C-------------------------------------------------------------------C
C	NORMAL CHARACTER COMMANDS
C-------------------------------------------------------------------C
C		The normal character commands are processed in order
C	of estimated usage frequency, to speed up operation as much
C	as possible.
C
C	The "possible" and currently "used" normal characters are-
C                                
C	Possible: [ Regular Keys ]
C		: @ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*\/?|Space
C	    Used: @ABCDE G I  LM  PQRSTUVWX Z0 2345 78    $%  *    Space
C	
C	NOTE: The numbers are there to support non-application-keypad
C
C	Possible: [ Key used with <GOLD>:  <PF1>T = <GOLD>T = Top ]
C		: @ABCDEFGHIJKLMNOPQRSTUVWXYZ $#%@^&[].,:;
C	    Used:  AB D FGHI K M  P   T  W    $     [ .,
C
C	Possible: [ Key used with <CTL>:  <CTL>@ = CHAR(0) ]
C		: @ABCDEF HIJKLMNOP R TUVWXYZ \]^_
C	    Used:  AB          M         W  Z
C
C_________________________________________________________________________

C	---------------------------
  	IF (Terminator .LE. 255) THEN
C	--------------------------- It's a "normal" character command

	Call Normal_Keys            ! (CMD & Terminator) passed in Common

C       ----
  	ELSE
C	---- It's a "special" character command

     
	Call Special_Keys

C	------
	END IF
C	------ END OF BLOCK FOR NORMAL/SPECIAL COMMANDS
                        
 
C_________________________________________________________________________
C		What do we do from here?
C  Two global (Common) symbols are set by the called routines, to indicate
C  what we should do:  DM_Exit and ReLoad.
C_________________________________________________________________________


	If (DM_Exit) 	GoTo 9999

	Exit_Com (1:5) = 'zzzzz'
	If (ReLoad) then
		GoTo 100
	Else
		If (Line23_Dirty) Call Fix23
		If (Line24_Dirty) Call Fix24
	        GoTo 200
	End If
C      --------
C		NOTE: 200 is the branch target for all loops.
C      		It is the "Get Next Command" starting location.


C.9999...............................................................
C 	SPAWN TASK OR EXIT PROGRAM.
C		If exit_com begins with 'zzzz' we set DM$command to
C			'GOTO GETOUT' and exit to the calling procedure.
C		Otherwise, we have placed the results in DM$command, and 
C			now we exit to the calling procedure (DM.COM).
C		In either case, DM.COM can look in DM$command to figure
C			out what to do (we hope)!
C....................................................................

9999   Continue ! exit the entire program
C		  NOTE: Cleanup is handled by DM_EXIT_HANDLER

C		GO OUT TO DCL  (DM.COM) AND RUN A COMMAND
C		Will run 'exit_com' unless it's value is 'GOTO GETOUT'
        End

