Contents: DM_Copy and Get_Files
C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Copy files to a file                                              C
C-------------------------------------------------------------------C
       Subroutine DM_Copy 
       Implicit Integer*4 (A - Z)
       Integer*2 Nbytes,Namlen
       Character*80 NewName
       Character*255 Temp_Line
       Character*128 Namex
       Include 'Common.Dat'
C-------------------------------------------------------------------C

       IF (IncluCount .LT. 1) then  ! Copy file at Current_Line 

         Call GetName(Current_Line,Namex,Itsa_Dir)
         If (.NOT.Itsa_Dir) then 
		Namlen = Lib$Matchc(' ',Namex)
		If (Namlen.le.1) goto 9000
  		Temp_Line = 'COPY '//Namex(:Namlen)
		Nbytes = 6 + Namlen + 2        !Include trailing blank

C		We'll assume success, make the line ourselves, and not
C		hang the screen for user input.
                    

	       Call Get_Answer_Line23(' Enter file destination (name):',
	1		NewName,Namlen)
	       If (Namlen .EQ. 0) then 
	         Goto 9000
	       Else	
		 Exit_Com=Temp_Line(:Nbytes)//NewName
C			Assume that, if [dir] is specified, the
C			file ISN'T going to THIS directory: so, no reload.
		 If (Lib$MatchC('[',NewName(:NamLen)) .EQ. 0) 
	1			ReLoad = .TRUE.
		 Call Do_Hidden_DCL
		 GOTO 9000
	       End If    
	
         Else 


	 	Call Mess_Wait(' Can''t Copy A Directory ')
                Goto 9000
         End If         ! This completes a single file.

	ELSE      ! Multiple files into .......

       Call Get_Answer_Line23(' Copy Tagged Files To:',NewName,NBytes)       

       If (Nbytes .EQ. 0) then 
         Goto 9000
       Else 
C			Assume that, if [dir] is specified, the
C			file ISN'T going to THIS directory: so, no reload.
		 If (Lib$MatchC('[',NewName(:NBytes)) .EQ. 0) 
	1			ReLoad = .TRUE.

	  Temp_Line = 'COPY/LOG \\ '//NewName(:Nbytes)
	  Nbytes=Nbytes+13
	  Call Make_DCL_Line (Temp_Line, Nbytes )
	  If (Do_DCL) then 
		 Call Do_Controlled_DCL
		 Do_DCL = .FALSE.
	  Else
		 If (Terminator .EQ. SMG$K_TRM_PF1) 
	1			Call Get1Char(Cmd) ! Eat <Gold>
		 ReLoad = .FALSE.    ! Reset if something was wrong.
	  End If
       End If         

       END IF

9000   Return 
       End

C-------------------------------------------------------------------C
C Copy files INTO current directory
C-------------------------------------------------------------------C
       Subroutine Get_Files 
       Implicit Integer*4 (A - Z)       
       Integer*4 Save_Current_Line	
       Integer*2 Nbytes
       Character*80 NewName
       Include 'Common.Dat'
C-------------------------------------------------------------------C

       Call Get_Answer_Line23(' File(s) To Get:',NewName,NBytes)

       If (Nbytes .GT. 0) then 

	  ReLoad = .TRUE.

	  If ((Lib$Matchc('*',NewName(1:NBytes)).LE.0) .AND.
	1      (Lib$Matchc(',',NewName(1:NBytes)).LE.0)) then  !One File


C		We'll assume success, make the line ourselves, and not
C		hang the screen for user input.

  		 Exit_Com = 'COPY/LOG '//NewName(:NBytes)//' *'

C			Open the DCL "error" window at the Bottom of the
C			screen.
		 Save_Current_Line = Current_Line
		 Current_Line = TopLine + 20
		 Call Do_Hidden_DCL
		 Current_Line = Save_Current_Line
	  
          Else
 		 Exit_Com = 'COPY/LOG  '//NewName(:Nbytes)//' *'
		 Call Do_One_DCL
          End If         

       End If

9000   Return 
       End

