C*****************************************************************************
C
C	DELETE FILES AND/OR DIRECTORIES
C
C   (Version 6.x)            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Delete file(S) or Dir(S) or both.                                 C
C-------------------------------------------------------------------C
        Subroutine DM_Delete
        Implicit Integer*4 (A - Z)
        Logical Didit	
        Character*1 Answer
        Include 'Common.Dat'
        Character*(Files_Display_Width) Namex	
C-------------------------------------------------------------------C

	If (IncluCount .LT. 1) then  ! Delete 1 FILE OR DIRECTORY
		If ((Current_Line .GE. First_File) .AND.
	1	    (Current_Line .LE. Last_File )) then
		        Call GetName(Current_Line, Namex, Itsa_Dir)
		        J = MAX( Lib$MatchC (' ',Namex), 1)
	 	        Answer = 'N'
	                Call Mess_Get1Char
	1			(' Do you really want to delete '//
	2		        Namex(1:J)//'? (Y/N) [N] ',Answer)
	                If ((Answer .NE. 'Y') .AND. 
	1		    (Answer .NE. 'y'))      Return
C			     	  DELETE ONE FILE
			Call Delete_One_File (Didit)
		Else
C		       DELETE ONE DIRECTORY

			Call Delete_One_Directory (Didit)
		    	Call UnPaste_Delete_Windows
                End If

        Else       ! Tagged Files
       
		Call Make_Dull

C			First the files
		If ((NumFiles .GT. 0) .AND.
	1	    (IncluLines(IncluCount) .GE. First_File)) then !files

			Call Delete_Tagged_Files
		End If

C			And then the Directories
		If ((IncluCount .GT. 0) .AND.
	1		    (IncluLines(1) .LE. Last_Dir)) then

			Call Delete_Tagged_Directories
		End If

	    	Call UnPaste_Delete_Windows
	End If


600	Return 
        End


C-------------------------------------------------------------------C
C (CREATE AND) PASTE BASIC DELETE WINDOWS
C-------------------------------------------------------------------C
        Subroutine Paste_Delete_Windows
        Implicit Integer*4 (A - Z)
        Include 'Common.Dat'

C-------------------------------------------------------------------C

	If (Have_Delete_Windows) GoTo 100

	Call SMG$Create_Virtual_Display
	1	(1,40,Delete_Op_Underlay_Display,
	2	 SMG$M_Border,SMG$M_Reverse)

	Call SMG$Create_Virtual_Display
	1	(1,40,Delete_Operation_Display,
	2	 ,SMG$M_Reverse)


	Call SMG$Create_Virtual_Display
	1	(1,80,Delete_File_Display,
	2	 ,SMG$M_Bold)


	Call SMG$Create_Virtual_Display
	1	(6,31,Delete_Menu1_Display)

		Call SMG$Put_Line (Delete_Menu1_Display, 
	1		'"A" to delete All (No Confirm) ')
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		1,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		1,15,1,1,SMG$M_Bold)
		Call SMG$Put_Line (Delete_Menu1_Display, 
	1		'"C" to Confirm each deletion   ')
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		2,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		2,8,1,1,SMG$M_Bold)
		Call SMG$Put_Line (Delete_Menu1_Display, 
	1		'"Q" to Quit                    ')
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		3,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu1_Display,
	1		3,8,1,1,SMG$M_Bold)


	Call SMG$Create_Virtual_Display
	1	(6,31,Delete_Menu2_Display)

		Call SMG$Put_Line (Delete_Menu2_Display, 
	1		'"Y" for Yes (delete this item) ')
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		1,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		1,9,1,1,SMG$M_Bold)
		Call SMG$Put_Line (Delete_Menu2_Display, 
	1		'"N" for No  (don''t delete it)  ')
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		2,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		2,9,1,1,SMG$M_Bold)
		Call SMG$Put_Line (Delete_Menu2_Display, 
	1		'"A" to delete All (remaining)  ')
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		3,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		3,15,1,1,SMG$M_Bold)               
		Call SMG$Put_Line (Delete_Menu2_Display, 
	1		'"Q" to Quit                    ')
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		4,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		4,8,1,1,SMG$M_Bold)
		Call SMG$Put_Line (Delete_Menu2_Display, 
	1		'"I" for Information on file    ')
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		5,2,1,1,SMG$M_Bold)
		    Call SMG$Change_Rendition (Delete_Menu2_Display,
	1		5,9,1,1,SMG$M_Bold)


	Call SMG$Create_Virtual_Display
	1	(6,40,Delete_Menu_Underlay_Display,
	2	 SMG$M_Border)

		Call SMG$Put_Line (Delete_Menu_Underlay_Display, 
	1		' Press -')

	
	Have_Delete_Windows = .TRUE.

100	Continue   ! Now paste the windows.

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$Paste_Virtual_Display (Delete_Op_Underlay_Display,
	1		Pasteboard_ID,3,2)

	Call SMG$Put_Line (Delete_Operation_Display, ' Delete',0)
	Call SMG$Paste_Virtual_Display (Delete_Operation_Display,
	1		Pasteboard_ID,3,2)

	Call SMG$Erase_Display (Delete_File_Display)

	Call SMG$Paste_Virtual_Display (Delete_Menu_Underlay_Display,
	1		Pasteboard_ID,6,2)

	Call SMG$Paste_Virtual_Display (Delete_Menu2_Display,
	1		Pasteboard_ID,6,11)

	Call SMG$Paste_Virtual_Display (Delete_Menu1_Display,
	1		Pasteboard_ID,6,11)

	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return
	End

C-------------------------------------------------------------------C
C UNPASTE DELETE WINDOWS
C-------------------------------------------------------------------C
        Subroutine UnPaste_Delete_Windows
        Implicit Integer*4 (A - Z)
        Include 'Common.Dat'

C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display (Delete_Op_Underlay_Display,
	1		Pasteboard_ID)

	Call SMG$Erase_Display (Delete_Operation_Display)
	Call SMG$UnPaste_Virtual_Display (Delete_Operation_Display,
	1		Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display (Delete_File_Display,
	1		Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display (Delete_Menu_Underlay_Display,
	1		Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display (Delete_Menu1_Display,
	1		Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display (Delete_Menu2_Display,
	1		Pasteboard_ID)

	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return
	End

C-------------------------------------------------------------------C
C	DELETE ANSWER 1
C Process answer from Delete_Menu1
C	Note: This only gets the answer.  It is the responsibility
C	of the calling routine to paint the menu(s).  Also, this
C	subroutine does not initialize the global logicals.
C
C	The "Answer" is returned by setting All_Delete, Confirm_Delete,
C	or Quit_Delete to .TRUE.
C-------------------------------------------------------------------C
        Subroutine Delete_Answer1
        Implicit Integer*4 (A - Z)
        Character*1 Answer
        Include 'Common.Dat'
C-------------------------------------------------------------------C

C	Call WriteTerm (Cursor_Off)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)

100	Answer = ' '

	Call Get1Char(Answer)

	If (Lib$MatchC (Answer,'aAdDyY') .NE. 0)    then
		All_Delete = .TRUE.
 
	Else If (Lib$MatchC (Answer,'cCvV') .NE. 0) then
		Confirm_Delete = .TRUE.

	Else If ((Lib$MatchC (Answer,'qQnN') .NE. 0) .OR.
	1	 (Terminator .EQ. SMG$K_TRM_CtrlZ))            then
		Quit_Delete = .TRUE.

	Else
		GoTo 100
	End If

C      	Call WriteTerm (Cursor_On)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)

	Return
	End

C-------------------------------------------------------------------C
C	DELETE ANSWER 2
C Process answer from Delete_Menu2
C	Note: This only paints the filename and gets the answer.  
C	The calling routine must the filename (because the 
C		caller usually wants to know the filename anyway).
C	It is the responsibility of the calling routine to paint 
C	the menu(s).  Also, this subroutine does not initialize 
C	the global logicals.
C
C	Current_Line must point to the correct file (for Info).
C
C	The "Answer" is returned by setting Answer to "Y" or "N" 
C	(guaranteed upper case), or by setting
C	Remainder_Delete, or Quit_Delete to .TRUE.
C-------------------------------------------------------------------C
        Subroutine Delete_Answer2 (FileName, Answer)
        Implicit Integer*4 (A - Z)
        Character*1 Answer
	Character*(*) FileName
        Include 'Common.Dat'
        Character*(Attributes_Display_Width) File_Info
C-------------------------------------------------------------------C

	Call SMG$Put_Chars (Delete_File_Display,FileName,
	1	1,%Ref(Name_Pos))

C	Call WriteTerm (Cursor_Off)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)

100	Answer = ' '

	Call Get1Char(Answer)

	If (Lib$MatchC (Answer,'yYcC1dD') .NE. 0)    then
		Answer = 'Y'

	Else If (Lib$MatchC (Answer,'nN0') .NE. 0) then
		Answer = 'N'
		
	Else If (Lib$MatchC (Answer,'aArR') .NE. 0) then
		Remainder_Delete = .TRUE.
		Confirm_Delete = .FALSE.
		All_Delete = .TRUE.
		Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

		Call SMG$Put_Chars (Delete_Operation_Display, 
	1		'ing Remainder                     ',1,7)
		Call SMG$Change_Rendition (Delete_Operation_Display,
	1		1,11,1,9,SMG$M_Bold)

		Call SMG$UnPaste_Virtual_Display (Delete_Menu_Underlay_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_Menu2_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display (Delete_File_Display,
	1		Pasteboard_ID)

		Call SMG$UnPaste_Virtual_Display 
	1		(Delete_Op_Underlay_Display, Pasteboard_ID)

		Call SMG$End_Pasteboard_Update (Pasteboard_ID)


		
	Else If (Lib$MatchC (Answer,'iI') .NE. 0) then
		NHold = FileName
	        Call Make_file_prot_string (File_Info)
		Call SMG$Put_Chars (Delete_File_Display, 
	1		'|'//File_Info,
	1		1,%Ref(File_Attr_Pos - 1))
		GoTo 100
		
	Else If ((Lib$MatchC (Answer,'qQ') .NE. 0) .OR.
	1	 (Terminator .EQ. SMG$K_TRM_CtrlZ))            then
		Didit = .FALSE.
		Quit_Delete = .TRUE.


	Else   ! Don't recognize the answer.
		GoTo 100
	End If

C      	Call WriteTerm (Cursor_On)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)

	Return
	End
