C*****************************************************************************
C
C  User Message Handlers for DM			August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Output a message to line 23 of the CRT, and wait for a character  C
C  Writes out Strng, prompts on line 24 for ANY INPUT, 
C	and eats the next character - then cleans up.
C-------------------------------------------------------------------C
       Subroutine Mess_Wait(Strng)
       Implicit Integer*4 (A - Z)
       Character*(*) Strng
       Character*100 Line24
	Character*1 C
       Include 'Common.Dat'


C-------------------------------------------------------------------C

        Call Mess_Line (Strng)

	Call SMG$Paste_Virtual_Display
	1	 (Line24BBMSG_Display,Pasteboard_ID,24,1)

        Call Get1Char(C)

C 		If the character is !, we may want to read messages.
        If (C .EQ. '!') then 
	  If (Num_Message .GT. 0) then
	    NBytes = 1
	    Call Make_DCL_Line ('!', NBytes )
	    DM_Exit = .TRUE.
	    Return
	  End If
	End If
	

	Call SMG$UnPaste_Virtual_Display
	1	 (Line24BBMSG_Display,Pasteboard_ID)

	Call SMG$UnPaste_Virtual_Display
	1	 (Line23MSG_Display,Pasteboard_ID)

	Line23MSG_On = .FALSE.

	Return
	End

C-------------------------------------------------------------------C
C Output a full-line message to line 23 of the CRT.                 C
C  Used generally to ask a Yes/No Question.  Calling routine must
C  do whatever is necessary to clean up.
C-------------------------------------------------------------------C
       Subroutine Mess_Line (Strng)
       Implicit Integer*4 (A - Z)
       Character*(*) Strng
       Character*85 TempLine
       Include 'Common.Dat'
C-------------------------------------------------------------------C
	

       TempLine(1:81) = Strng

	Call SMG$Put_Line(Line23MSG_Display,TempLine(:80),0)
	Call SMG$Paste_Virtual_Display
	1	 (Line23MSG_Display,Pasteboard_ID,23,1)


        Line23_Dirty = .TRUE.
	Line23MSG_On = .TRUE.

       Return
       End

C-------------------------------------------------------------------C
C Get a SINGLE CHARACTER response to a message on line 23 of the CRT.
C   (Used when you want to get a CHAR response on the same line)
C   Out_Strng is the string to be put on line 23.
C   In-Char is the returned character.
C   This routine cleans up Line 23 after the input.
C-------------------------------------------------------------------C
       Subroutine Mess_Get1Char (Out_Strng,In_Char)
       Implicit Integer*4 (A - Z)
       Character*(*) Out_Strng
       Character*1 In_Char
       Character*91 TempLine
       Character*80 Spaces
       Integer*2 L
       Integer*4 LL	
       Include 'Common.Dat'
       Parameter (Spaces = ' ')
C-------------------------------------------------------------------C

	Call Str$Trim (%Descr(TempLine),%Descr(Out_Strng),%Ref(L))
	L=Min(L+1,91)
	TempLine (L:) = Spaces
	LL = L

	Call SMG$Put_Line(Line23MSG_Display,TempLine(:80),0)
	Call SMG$Paste_Virtual_Display
	1	 (Line23MSG_Display,Pasteboard_ID,23,1)



	Call SMG$Set_Cursor_Abs(Line23_Display,1,LL)

C	Call WriteTerm (Cursor_Off)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)

       	Call Get1Char (In_Char)

	Call SMG$UnPaste_Virtual_Display
	1	 (Line23MSG_Display,Pasteboard_ID)

C      	Call WriteTerm (Cursor_On)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)

        Return
        End

