C*****************************************************************************
C
C  Print Handlers for DM			August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Print File(s).                                                    C
C-------------------------------------------------------------------C

        Subroutine DM_Print
        Implicit Integer*4 (A - Z)
        Integer*2 NBytes	
        Integer*4 ThisLine, Save_Current
        Logical OK
        Character*1 Answer
        Include 'Common.Dat'
        Character*(Files_Display_Width) TEMPXX

C-------------------------------------------------------------------C

        If (IncluCount .LT. 1) then
		Call Include  ! Make 1 same as many
	End If

	If (IncluCount .GT. 1) then
		Answer = 'N'	
20	        Call Mess_Get1Char(' Are you sure you want to print '//
	1		'the tagged files?  (Y/N) [N] ' ,Answer)

		If (Terminator .EQ. SMG$K_TRM_PF1) then  ! Might be Gold_A
C			Call WriteTerm (Cursor_Off)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)
			Call Get1Char(Answer)
C			Call WriteTerm (Cursor_On)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)
	    	        If (Lib$MatchC( Answer, 'Aa') .LE. 0) then
				GoTo 9999
			Else
  				Call DM_Gold_A
				GoTo 20
			End If

    	        Else If (Lib$MatchC( Answer, 'Yy') .LE. 0) then
			GoTo 9999
		End If  ! Otherwise, we should try printing.
	End If

C		Check to see if we can/should print the files.
	Save_Current = Current_Line
	Call Make_Dull
100     Do I = 1, IncluCount       

		Current_Line = IncluLines(I)
		Call DM_Print_Check (OK)
		If (.NOT.OK) then
			Call Exclude
			GoTo 100  ! Must re-do, because IncluCount changes.
		End If
        End Do
	Current_Line = Save_Current

	If (IncluCount .LE. 0) GoTo 9999


C--------------------------------------------------------
C	Print the file(s)
C--------------------------------------------------------

300	Call Str$Trim(%Descr(TEMPXX),%Descr(Print_Command),
	1			%Ref(NBytes))

   	If (IncluCount .GT. 1) then
		TEMPXX(NBytes+1:) = ' \\'	
		NBytes = NBytes + 3

		Call Make_DCL_Line (TEMPXX, Nbytes )
		If (Do_DCL) then 

			Call Do_Hidden_DCL
			Do_DCL = .FALSE.
			Do I = 1, IncluCount
				ThisLine = InCluLines(I)
				Call SMG$Erase_Chars (Files_Display,1,
	1				%Ref(ThisLine),	Flag_Pos)
			End Do
		        IncluCount = 0

		Else If (Terminator .EQ. SMG$K_TRM_PF1) then  ! Might be Gold_A
C			Call WriteTerm (Cursor_Off)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)
			Call Get1Char(Answer)
C			Call WriteTerm (Cursor_On)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)
	    	        If (Lib$MatchC( Answer, 'Aa') .LE. 0) then
				GoTo 9999
			Else
  				Call DM_Gold_A
				GoTo 300
			End If

		End If
	Else
		Exit_Com = TEMPXX
		Current_Line = IncluLines(1)
	        Call GetName (Current_Line, TEMPXX, Itsa_Dir)
		Exit_Com(NBytes+2:) = TEMPXX	
		Call Do_Hidden_DCL
		Call Exclude
		Current_Line = Save_Current  !  Already in there.
	End If

9999	Return
        End

C-------------------------------------------------------------------C
C Check File(s) to see if they should be printed.                   C
C	Check file to see if it can be opened, and prompt user if
C	it is an "odd" file.  Also, refuse to print an "itsa_dir".
C	Return a logical if we can't/won't print.
C-------------------------------------------------------------------C

        Subroutine DM_Print_Check (OK)
        Implicit Integer*4 (A - Z)
	Integer Semi, NB
        Logical OK
        Character*1 Answer
        Character*3 File_Name_Extension
        Include 'Common.Dat'
        Character*(Files_Display_Width) TEMPXX

C-------------------------------------------------------------------C
	
	OK = .FALSE.

        Call GetName (Current_Line, TEMPXX, Itsa_Dir)

        If (Itsa_Dir) then

		Call Make_Bright
		Call Mess_Wait (' DM won''t print Directory file '//
	1		TEMPXX)
		Call Make_Dull
		GoTo 9999

	Else If (TEMPXX(1:1) .EQ. ' ') then
		GoTo 9999	


	Else
	        Semi   = Lib$Matchc(';',TEMPXX)

		If (Semi.LT.5) then
			GoTo 100
		Else If (TEMPXX(Semi-4:Semi-4).ne.'.') then
			GoTo 100
		Else 
    			File_Name_Extension = TEMPXX (semi-3:semi-1)
	    		If (Lib$MatchC (File_Name_Extension, 
	1	              'EXE-OLB-OBJ-FRM-FLB' ) .gt. 0) then
			Answer = 'N'
			NB = MAX(Lib$MatchC('  ',TEMPXX),5)
			Call Make_Bright
			Call Mess_Get1Char 
	1			('Do you Really want to print '//
	2			File_Name_Extension//' file '//
	3			TEMPXX(:NB)//'??? (Y/N) [N]',Answer)
			Call Make_Dull

		    	        If (Lib$MatchC( Answer, 'Yy')
	1				 .LE. 0) GoTo 9999
C				Otherwise, fall through to 100

			End If
		End If
	End If
	
100	CONTINUE   ! OK so far, but can we open it?

        Open  (Unit=1, File=TEMPXX, Status='OLD', READONLY, ERR=200) 
        Close (Unit=1)   !OK to Print the file
	OK = .TRUE.
	GoTo 9999

200	CONTINUE   ! Couldn't open the file!
	Call Make_Bright
	Call Mess_Wait (' Can''t Open (print) file '//TEMPXX)
	Call Make_Dull


9999	Return
	End

C-------------------------------------------------------------------C
C Print the Directory (Screen)
C-------------------------------------------------------------------C

        Subroutine DM_Print_Dir
        Implicit Integer*4 (A - Z)
        Integer*2 NBytes	
	Integer*4 Index, Ver
	Character*80 Line
	Character*22 File(3)
        Include 'Common.Dat'
        Character*(Files_Display_Width) Name
	Character*(Attributes_Display_Width) Att
	Data File(1) /'SYS$LOGIN:DM$DIR.LIS;1'/
	Data File(2) /'SYS$LOGIN:DM$DIR.LIS;2'/
	Data File(3) /'SYS$LOGIN:DM$DIR.LIS;3'/
C-------------------------------------------------------------------C

	Line = Blanks

	If (Menu .LE. Normal_Mode) then
		K = MIN(80,Current_Files_Width)
		L = K+1
		M = L+1
		If (M .LE. File_Attr_Pos) then
			M = File_Attr_Pos
			J = 1
		Else
			J = M - File_Attr_Pos + 1
		End If
	Else
		M = File_Attr_Pos
		L = M-1
		K = L-1
		J = 1
	End If

C		Try to open one of 3 available files
	Do 10 Ver = 1,3
  	Open (Unit=1, File=File(Ver), Status='Unknown', Err=10)
	GoTo 50
10	Continue
	Call Mess_Wait (' Your DM Print Queue is full.'//
	1	'  Try again after these directories are printed.')
	GoTo 900

C		We got a file.  Now do the first line.
50	Call SMG$Read_From_Display (%Ref(Files_Display)
	1	,%Descr(Name),,%Ref(1))
	Call SMG$Read_From_Display (%Ref(Attributes_Display)
	1	,%Descr(Att),,%Ref(1))

	Line(File_Attr_Pos:) = Att
	Line(:MIN(80,Current_Files_Width))   = Name

	Write (1,100) Line
100		Format (A80)

	If (L.LE.80) Line(L:L)='|'

C		The rest of the lines...
	Do 200 Index = 2, Current_Display_Length
	    Call SMG$Read_From_Display (%Ref(Files_Display)
	1	,%Descr(Name),,%Ref(Index))
	    Call SMG$Read_From_Display (%Ref(Attributes_Display)
	1	,%Descr(Att),,%Ref(Index))

		Line(:K)   = Name
		If (M.LE.80) Line(M:80) = Att(J:)

		Write (1,100) Line
200	Continue

	Close (Unit=1)

	Call Str$Trim(%Descr(Print_Command),%Descr(Print_Command),
	1			%Ref(NBytes))

	Exit_Com = Print_Command(:NBytes)
	Exit_Com(NBytes+2:) = File(Ver)	
	Call Do_Hidden_DCL

900	Return
	End

