C*****************************************************************************
C  WildCard and Search Routines for DM
C
C  Revisions (Version 6.x)            August, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
c
c routine to prompt for wildcard which is stored in the /wild/
C common block
c rich gregory 8/22/85
c
C-------------------------------------------------------------------C
	Subroutine Wild 
	character*80 temp_str
	character*20 new_wild
	Integer*2  length_str
	include 'common.dat'


	     
	Call Get_Initial_Line24 
	1	(' Edit the wildcard for this directory:',WildCard,
	2		temp_str,length_str)

	if ((length_str .le. 0).or.(temp_str(1:1) .eq. ' ')) then
	  ReLoad = .FALSE.
	else
	    new_wild = temp_str(1:20)
	    Call Str$Upcase(%Descr(new_wild),%Descr(new_wild))
	    if (new_wild .ne. wildcard) then
		  wildcard=new_wild
		  wildcard_length = length_str
		  ReLoad = .TRUE.
	    else
		  ReLoad = .FALSE.
	    end if
	end if

	return
	end

C-----------------------------------------------------------------C
C Find String utility.  Get the characters to look for from the   C
C user into Search.  Also set srchsize to the string size.        C
C Then call ShowSrch.                                             C
C-----------------------------------------------------------------C
        Subroutine FindStrg
        Implicit Integer*4 (A - Z)
        Integer*2 NBytes, L
	Integer*4 Max_Input, LL, NL
	Character*80 Old_Search
        Include 'Common.Dat'
C-----------------------------------------------------------------C

	Old_Search = Search
	Max_Input = Len(Search)
C	Call Get_Answer_Line23 (' Enter search string: ',SEARCH,NBytes)       
C 			Fix things so we can do recall of the last line
	Call Set_Terminal_Line_Edit
	
	Call SMG$Put_Line(Line23MSG_Display,' Enter search string: ',0)

	Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)
	
	Call SMG$Erase_Display (Line24MSG_Display)

	Call SMG$Paste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID,24,1)

	Call SMG$Add_Key_Def (Key_Table_ID, 'FIND',, SMG$M_Key_Terminate)
	
	Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, Search,
	1		%Descr('> '),NBytes,
	2		Line24MSG_Display,,,,,,Terminator)
                                                    
	Call SMG$Delete_Key_Def (Key_Table_ID, 'FIND')
	
	Call SMG$UnPaste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID)

	Call SMG$Erase_Display (Line24MSG_Display)
                                                    
	Call Set_Terminal_NoLine_Edit

	Call Str$Upcase (%Descr(Search),%Descr(Search))

	Call SMG$UnPaste_Virtual_Display (Line23MSG_Display,
	1	Pasteboard_ID)
	
	Call Str$Trim (%Descr(SEARCH),%Descr(SEARCH),%Ref(NBytes))
	If (NBytes .LE. 0) then
		Search = Old_Search
C			Restore previous search string.  Then, if FIND
C			was pressed (311), do the search anyway (if
C			the incoming SEARCH string had contents).
		If (Terminator .NE. SMG$K_TRM_E1) RETURN
	Else
		SRCHSIZE = NBytes
	End If
	If (SrchSize .GT. 0) Call ShowSrch
        Return
        End

C-----------------------------------------------------------------
C Find String utility.  Look for a string in Files.  If the string is
C found show the line, otherwise, put a message on the bottom of  
C the CRT.                                                        
C-----------------------------------------------------------------
       Subroutine ShowSRCH
       Implicit Integer*4 (A - Z)
       Character*1 choice
       Integer*4 I,Element	
       Logical  Other_Way, Success
       Include 'Common.Dat'
       Character*(Files_Display_Width) FileName	
C-----------------------------------------------------------------C
	Other_Way = .FALSE.
	Success   = .FALSE.

        If (SrchSize .LT. 1) then
		Call Mess_Wait 
	1		(' Use Find or Srch to set Search String')
		Return
	End If

        Element = 0

50      If (Forward) then          



	Do 100 I = (Current_Line + 1), LastLine

	   Call SMG$Set_Cursor_Abs (Files_Display,%Ref(I),1)
	   Call SMG$Read_From_Display (Files_Display,FileName
	1		,,%Ref(I))

	   If (FileName(Name_Pos:Name_Pos)  .EQ. ' ')     goto 100
           If (FileName(1:10) .EQ. This_Directory_Line)   goto 100

           G = Lib$Matchc(Search(1:SrchSize), FileName)
           If (G .NE. 0) then 
             Element = I
	     Success = .TRUE.
             Goto 300
           End If
100        Continue 

       Else
         Do 200 I = Current_Line - 1, FirstUsed, -1

	   Call SMG$Set_Cursor_Abs (Files_Display,%Ref(I),1)
	   Call SMG$Read_From_Display (Files_Display,FileName
	1		,,%Ref(I))

	   If (FileName(Name_Pos:Name_Pos)  .EQ. ' ')     goto 200
           If (FileName(1:10) .EQ. This_Directory_Line)  goto 200
                
           G = Lib$Matchc(Search(1:SrchSize), FileName)
           If (G .NE. 0) then 
             Element = I
	     Success = .TRUE.
             Goto 300
           End If        

200      Continue
       End If

	IF (.NOT. Other_Way) GOTO 250


C-------------------------------------------------------------------C
C String not found.  Show information message on CRT line 23.       C
C  (Since we looked both ways, reset direction to original)
C-------------------------------------------------------------------C

       Call Mess_Wait(' String not found')
	If (Forward) then
		Forward = .FALSE.
	Else
		Forward = .TRUE.
	End If
       Goto 9999


C-------------------------------------------------------------------C
C Try the other direction?
C-------------------------------------------------------------------C

250	CONTINUE
	Other_Way = .TRUE.
	If (Forward) then
		Forward = .FALSE.
	Else
		Forward = .TRUE.
	End If
	
	GOTO 50      ! To retry in other direction

C-------------------------------------------------------------------C
C String was found.  Show line that has string.                     C
C-------------------------------------------------------------------C
300    Continue

C	ASK FOR PERMISSION - 

	If (Other_Way) then

	     Call Mess_Get1Char (
	1  ' Found in other direction.  Go there? (Y/N) [N] '
	2	,choice)


    	   If (lib$matchc( choice, 'Yy') .eq. 0) then ! Restore Original
		If (Forward) then 
	    		Forward = .FALSE.
		Else    
			Forward = .TRUE.
		End If
		GOTO 9999    !  If we don't want to go the other way
	   Else   
		Line23_Dirty = .TRUE.  ! Reset direction word
		GOTO 400     !  To display the line
	   End If
        End If



400     Call Make_Dull
	Current_Line = Element

       If ((Current_Line .GE. (TopLine + 22))  !Not at right page
     - .OR. (Element .LT. Topline)) then

	 If (Element .LE. 22) then
		TopLine = 1
	 Else If (Forward) then
		TopLine = Element - 2
	 Else
         	TopLine = Element - 19
	 End If

         Call Write_Screen

       End If

9999    Continue
	Return
        End

