C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C
C Puts the info for one file on the line by the file. Passed NHOLD in
C DMMCCOM common block
C rich gregory 8/10/85
C
C-------------------------------------------------------------------C
       Subroutine Info
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
       Character*(Attributes_Display_Width) File_Info

C-------------------------------------------------------------------C

	Call SMG$Set_Cursor_Abs 
	1		(Attributes_Display,Current_Line,Name_Pos)
	Call SMG$Read_From_Display (Attributes_Display,File_Info)

	If ((File_Info(17:17).ne.':') .and.
	1   (File_Info (1:1)  .ne.'*')) then


	   Call SMG$Set_Cursor_Abs 
	1		(Files_Display,Current_Line,Name_Pos)
	   Call SMG$Read_From_Display (Files_Display,NHold)

           Call Make_file_prot_string (File_Info)

	   Call SMG$Set_Cursor_Abs 
	1		(Attributes_Display,Current_Line,1)
	   Call SMG$Put_Line
	1		(Attributes_Display,File_Info,0)


	End If


       Return
       End    	

C-------------------------------------------------------------------C
C
C Makes the file info string when passed the file name as NHOLD 
C in common block 'DMCCOM'. Returns file_info
C rich gregory 8/10/85
C
C-------------------------------------------------------------------C

    	 Subroutine Make_File_Prot_String ( File_Info )
	 Implicit Integer*4 (A-Z)
    	 Character*(*) File_Info
	 Integer*4 Zero
	 Integer*2 Len
         Character*21 St21, Strg
         Character*3 Hold3
         Character*7 Uichold
    	 Include 'Common.Dat'
	 Data Zero /0/

         Call FLook(NHOLD)    ! Get Prot, UIC1, UIC2, Time/Date
         If (Derror .EQ. 0) then 
           Call GetProt(LkProt, St21)
           Call Lib$sys_Asctim(Len, Strg, LkDate, Zero)
           UicHold = '000,000'
           Call OTS$CVT_L_TO(LkUic1, Hold3, %Val(3), %Val(2))     
		If (Hold3(1:1).eq.'0') then
			Hold3(1:1)=' '
			If (Hold3(2:2).eq.'0') Hold3(2:2)=' '
		End If
           UicHold(1:3) = Hold3

           Call OTS$CVT_L_TO(LkUic2, Hold3, %Val(3), %Val(2))
		If (Hold3(1:1).eq.'0') then
			Hold3 = Hold3(2:)
      			If (Hold3(1:1).eq.'0') Hold3 = Hold3(2:)
		End If
           UicHold(5:7) = Hold3

           If (First_Free .EQ. 0) File_Siz = File_Siz - 1

	   File_info = ' '
 		Write (file_info(1:5),400,IOSTAT=IgNORE) file_siz
400	   Format (i5)                          
	   File_info (7  : 19) = Strg(1:2)//Strg(4:6)//Strg(10:17)
C				!  xx        mmm       yy hh:mm - date time
	   File_Info (21 : 27) = UicHold 	! 7  uic stuff
	   File_info (29 : 49) = St21	! (1:21) protection

         Else
	    If (FirstUsed .GT. LastLine) then   ! No Files or Directories.
		File_Info = ' '                 ! We are beyond last line
	    Else
           	File_Info =
     -     	'***** No Privilege for this info '//
     -		'- - - - - - - - - -'
	    End If
         End If !NO ERROR

    	 Return
    	 End !MAKE_FILE_PROT_STRING

C-----------------------------------------------------------------C
       Subroutine GetProt(X, Stg)
       Implicit Integer*4 (A - Z)
       Character*(*) Stg
       Include 'Common.Dat'
C-----------------------------------------------------------------C
       In = 2  !Index into stg
       Stg = '('
       Z = X
       Do I = 1, 4

		K = MOD (Z,16)

		GoTo (14,13,12,11,10,9,8,7,6,5,4,3,2,1,99) K
		GoTo 15     

1		Stg(In:In)='R'
	     	In=In+1
		GoTo 99

2		Stg(In:In)='W'
		In=In+1
		GoTo 99

3		Stg(In:In+1)='RW'
		In=In+2
		GoTo 99

4		Stg(In:In)='E'
		In=In+1
		GoTo 99

5		Stg(In:In+1)='RE'
		In=In+2
		GoTo 99

6		Stg(In:In+1)='RW'
		In=In+2
		GoTo 99
       
7		Stg(In:In+2)='RWE'
		In=In+3
		GoTo 99

8		Stg(In:In)='D'
		In=In+1
		GoTo 99

9		Stg(In:In+1)='RD'
		In=In+2
		GoTo 99

10		Stg(In:In+1)='WD'
		In=In+2
		GoTo 99

11		Stg(In:In+2)='RWD'
		In=In+3
		GoTo 99

12		Stg(In:In+1)='ED'
		In=In+2
		GoTo 99

13		Stg(In:In+2)='RED'
		In=In+3
		GoTo 99

14		Stg(In:In+2)='WED'
		In=In+3
		GoTo 99

15		Stg(In:In+3)='RWED'
		In=In+4
  		GoTo 99


99       Stg(In:In) = ','
         In = In + 1
	 Z = Z/16
       End Do
       Stg(In - 1 : In - 1) = ')'  ! put on top of last ','
       Return 
       End

C-------------------------------------------------------------------C
C ASCII conversion routine.                                         C
C Given the directory name, return the file name of that directory. C
C InName - Name of a directory of form [ALL.IS.WELL.THAT.ENDS.WELL] C
C OutName - Returned name of form [ALL.IS.WELL.THAT.ENDS]WELL.DIR   C
C-------------------------------------------------------------------C
        Subroutine RealDIR(InName, OutName)
        Implicit Integer*4 (A - Z)
        Character*(*) InName,OutName
        Include 'Common.Dat'
C-------------------------------------------------------------------C
	OutName = Blanks	

        If (InName(1:8) .EQ. '[000000]') then
                OutName(1:18) = '[000000]000000.DIR'

        Else

                I = Lib$Matchc(']',InName)
	        Period = Lib$Matchc('.',InName)   


        	If (Period .EQ. 0) then           ! add [000000] directory
	        	OutName(1 : 8) = '[000000]'
			OutName(9:I+6) = InName(2:I-1)
	        Else                      ! Has '.''s no need for [000000]
			OutName (:I-1) = InName (:I-1)
110     		J = Lib$Matchc('.',Outname(Period + 1 : ))
		        Period = Period + J               ! I = the last '.'
	                If (J .NE. 0) goto 110
	                OutName(Period : Period) = ']'
	        End If

	        I = Lib$Matchc('  ',OutName)
        	If (I .EQ. 0) stop
	        OutName(I  : I + 3) = '.DIR'
        End If
        I = Lib$Matchc('[000000.000000', OutName) 
        If (I .NE. 0) then 
	        G = Lib$Matchc('.000000', OutName(1:14))
        	OutName(G:G) = '['
		OutName = OutName(G:)
        End If

        Return
        End


C-------------------------------------------------------------------C
C  GetName - Gets filename data from the screen.
C-------------------------------------------------------------------C
C InName = One of the lines of the CRT.                             C
C OUTName = Returned name of file.   (File Name is left-justified)  C
C Itsa_Dir = .FALSE. for file type name                             C
C          = .TRUE.  for directory name                             C
C-------------------------------------------------------------------C
       Subroutine GetName(Line_Number, OutpName, Itsa_Dir)
       Implicit Integer*4 (A - Z)
       Character*(*) OutpName
       Include 'Common.Dat'
C-------------------------------------------------------------------C
        Itsa_Dir = .FALSE.                 ! Assume a file type

	If ((Line_Number .LE. 2) .OR. (Line_Number .GT. LastLine)) then
		OutpName = ' '
		GoTo 9999
	End If
	                      
	   Call SMG$Set_Cursor_Abs (Files_Display,
	1		%Ref(Line_Number),Name_Pos)
	   Call SMG$Read_From_Display 
	1		(Files_Display,OutpName)

	                      

        I = Lib$Matchc('.DIR;',OutpName)

        If (I .NE. 0) then
        	Itsa_Dir = .TRUE.   ! It is a 'DIR' not a file type
        End If

C		THIS FIXES AN OCCASIONAL ERROR IN SMG$
        I = Lib$Matchc(' ',OutpName)
        If (I .NE. 0) then
        	OutpName(I:) = ' '
        End If

9999   Return
       End

C-------------------------------------------------------------------C
C  Get_DirName - Gets directory name data from the screen.
C-------------------------------------------------------------------C
C InName = One of the lines of the CRT.  (XYZ.DIR;1)                C
C OUTName = Returned name of directory.   (Name is left-justified)  C
C             in the form [ABC.DEF.XYZ] or of a file, if not a .DIR C
C Itsa_Dir = .FALSE. for file type name                             C
C          = .TRUE.  for directory name                             C
C-------------------------------------------------------------------C
       Subroutine Get_DirName (Line_Number, OutpName, Itsa_Dir)
       Implicit Integer*4 (A - Z)
       Character*(*) OutpName
       Character*128 NameXX                    
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call GetName (Line_Number, OutpName, Itsa_Dir)
                                
        If (Itsa_Dir) then   ! We fix it up
           I = Lib$Matchc('.DIR;',OutpName)
           NameXX = OutpName    ! Get current directory name
           OutpName = Current_Dir
           L = Lib$Matchc(']', OutpName)
           If (L .EQ. 0) Stop
           OutpName(L:L) = '.'

      	   OutpName(L+1:L+I-1) = NameXX(1:I-1)
	   OutpName(L+I:L+I)   = ']'

           G = Lib$Matchc('[000000.', OutpName)
              If (G .NE. 0) then 
                 G = Lib$Matchc('.', OutpName)
	         OutpName(G-6:) = OutpName(G+1:)
       	      End If
        End If

9999   Return
       End

C-------------------------------------------------------------------C
C DIR/FULL File(s).                                                    C
C-------------------------------------------------------------------C

        Subroutine DM_Gold_I
        Implicit Integer*4 (A - Z)
        Integer*2 NBytes	
        Integer*4 ThisLine, Save_Current
        Logical OK
        Character*1 Answer
        Include 'Common.Dat'
        Character*(Files_Display_Width) TEMPXX

C-------------------------------------------------------------------C

        If (IncluCount .LT. 1) then
		Call Include  ! Make 1 same as many
	End If



300   	If (IncluCount .GT. 1) then
		TEMPXX = ' DIR/FULL \\'	
		NBytes = 12

		Call Make_DCL_Line (TEMPXX, Nbytes )

		If (Do_DCL) then 

			Call Do_One_DCL
			Do_DCL = .FALSE.
			Do I = 1, IncluCount
				ThisLine = InCluLines(I)
				Call SMG$Erase_Chars (Files_Display,1,
	1				%Ref(ThisLine),	Flag_Pos)
			End Do
		        IncluCount = 0

		Else If (Terminator .EQ. SMG$K_TRM_PF1) then  ! Might be Gold_A
C			Call WriteTerm (Cursor_Off)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)
			Call Get1Char(Answer)
C			Call WriteTerm (Cursor_On)
			Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)
	    	        If (Lib$MatchC( Answer, 'Aa') .LE. 0) then
				GoTo 9999
			Else
  				Call DM_Gold_A
				GoTo 300
			End If

		End If
	Else
		Exit_Com = ' DIR/FULL '	

	        Call GetName (Current_Line, TEMPXX, Itsa_Dir)
		Exit_Com(11:) = TEMPXX	
		Call Do_One_DCL
		Call Exclude
	End If

9999	Return
        End

