C-------------------------------------------------------------------C
C  Directory Management        January 1983                         C
C  Written by John C. Hayre, Texas Instruments                      C
C  Send suggestions and/or complaints to:                           C
C                                                                   C
C               Veeco Integrated Automation			    C
C               10355 Brockwood Rd				    C
C               Dallas, Texas 75238                                 C
C               (Attention John Hayre)                              C
C                                                                   C
C  Phone: 214-349-8482                                              C
C-------------------------------------------------------------------C
C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C  Revisions (Version 7.0, 7.1)       April, 1987     
C  Revisions (Version 7.3)	      March, 1988
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************

C-------------------------------------------------------------------C
C Routine to input a character with no echo from the VT100/VT2xx Crt.
C-------------------------------------------------------------------C
        Subroutine Get1Char (X)
        Implicit Integer*4 (A - Z)
	Character*1 X
        Include 'Common.Dat'
C-------------------------------------------------------------------C

100 	Stat =  SMG$Read_Keystroke (%Ref(Keyboard_ID),
	1	%Ref(Terminator))           ! Terminator is in Common
	If (Terminator .LE. 255) then
		X = Char(Terminator)
	Else
		X = ' '
	End If

C}{}{}{}      {CTL-W} = Refresh Screen
        If (Terminator .Eq. SMG$K_TRM_CtrlW) 
	1		Call SMG$Repaint_Screen(Pasteboard_ID)
C	
        Return
        End

C-------------------------------------------------------------------C
C Routine to Get an answer from the VT100/VT2xx keyboard.
C	Uses Line23 Display for Prompt, and Line24 for Output
C   Prompt_String is the string to be put on line 23.
C   Out_String is the returned string.  It will be all uppercase.
C   Out_Bytes MUST be I*2, and is the returned length (less CR)
C   This routine cleans up Line 23 & Line 24 after the input.
C-------------------------------------------------------------------C
        Subroutine Get_Answer_Line23 
	1	(Prompt_String, Out_Text, Out_Bytes) 

        Implicit Integer*4 (A - Z)
        Integer*2 Out_Bytes
        Character*(*) Prompt_String, Out_Text
	Integer*4 Max_Input
        Character*80 TempLine
        Integer*2 L
        Integer*4 LL,NL	
	
        Include 'Common.Dat'	
C-------------------------------------------------------------------C
C		Old Name
C       Entry Mess_KBD (Prompt_String, Out_Text, Out_Bytes) 


	Max_Input = Len(Out_Text)

	Call Str$Trim (%Descr(TempLine),%Descr(Prompt_String),%Ref(L))
	L=Min(L,80)     

C 			Fix things so we can do recall of the last line
	Call Set_Terminal_Line_Edit
	
	If (L .LE. 1) then

		Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)

		Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, 
	1		%Descr(Out_Text),%Descr(Prompt_String),
	2		%Ref(Out_Bytes),Line23MSG_Display,,,,,,Terminator)
                                                    

	Else

		Out_Bytes = 0
		LL = L+2



       		Call SMG$Put_Line(Line23MSG_Display,TempLine(:L),0)

		Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)
	

		Call SMG$Erase_Display (Line24MSG_Display)

		Call SMG$Paste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID,24,1)

		Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, 
	1		%Descr(Out_Text),%Descr('> '),%Ref(Out_Bytes),
	2		Line24MSG_Display,,,,,,Terminator)
                                                    
		Call SMG$UnPaste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID)

		Call SMG$Erase_Display (Line24MSG_Display)
                                                    
	End If

C 			Put things back the way they were
	Call Set_Terminal_NoLine_Edit

	Call Str$Upcase (%Descr(Out_Text),%Descr(Out_Text))

	Call SMG$UnPaste_Virtual_Display (Line23MSG_Display,
	1	Pasteboard_ID)

        Return
        End

C-------------------------------------------------------------------C
C Routine to Get an edited line from the VT100/VT2xx keyboard.
C	Uses Line23 Display for Prompt, and Line24 for Output
C   Prompt_String is the string to be put on line 23.
C   Initial_String is the initial data to be edited.
C   Out_String is the returned string.  It will be all uppercase.
C   Out_Bytes MUST be I*2, and is the returned length (less CR)
C   This routine cleans up Line 23 & Line 24 after the input.
C-------------------------------------------------------------------C
        Subroutine Get_Initial_Line24 
	1	(Prompt_String, Initial_String, Out_Text, Out_Bytes) 

        Implicit Integer*4 (A - Z)
        Integer*2 Out_Bytes
        Character*(*) Prompt_String, Out_Text, Initial_String
	Integer*4 Max_Input
        Character*80 TempLine
        Integer*2 L, K
        Integer*4 LL,NL	
	
        Include 'Common.Dat'	
C-------------------------------------------------------------------C


	Max_Input = Len(Out_Text)

	Call Str$Trim (%Descr(TempLine),%Descr(Initial_String),%Ref(K))
	K=Min(K,80)     

	Call Str$Trim (%Descr(TempLine),%Descr(Prompt_String),%Ref(L))
	L=Min(L,80)     

C 			Fix things so we can do recall of the last line
	Call Set_Terminal_Line_Edit
	
	If (L .LE. 1) then

		Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)

		Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, 
	1		%Descr(Out_Text),%Descr(Prompt_String),
	2		%Ref(Out_Bytes),Line23MSG_Display,,
	3		Initial_String(:K),,,,Terminator)
                                                    

	Else

		Out_Bytes = 0
		LL = L+2

	   	Call SMG$Put_Line(Line23MSG_Display,TempLine(:L),0)

		Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)


		Call SMG$Erase_Display (Line24MSG_Display)

		Call SMG$Paste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID,24,1)

		Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, 
	1		%Descr(Out_Text),%Descr('> '),%Ref(Out_Bytes),
	2		Line24MSG_Display,,
	3		Initial_String(:K),,,,Terminator)
                                                    
		Call SMG$UnPaste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID)

		Call SMG$Erase_Display (Line24MSG_Display)


	End If

C 			Put things back the way they were
	Call Set_Terminal_NoLine_Edit

	Call Str$Upcase (%Descr(Out_Text),%Descr(Out_Text))

	Call SMG$UnPaste_Virtual_Display (Line23MSG_Display,
	1	Pasteboard_ID)

        Return
        End

C-------------------------------------------------------------------C
C Routine to Get a DCL Line from the VT100/VT2xx keyboard.
C	Uses Line23 Display for Prompt, and Line24 for Output
C-------------------------------------------------------------------C
        Subroutine Get_Dollar_Line24 
	1	(Prompt_String, Out_Text, Out_Bytes) 

        Implicit Integer*4 (A - Z)
        Integer*2 Out_Bytes
        Character*(*) Prompt_String, Out_Text
	Integer*4 Max_Input
        Character*80 TempLine
        Integer*2 L
        Integer*4 LL
	
        Include 'Common.Dat'	
C-------------------------------------------------------------------C

	Max_Input = Len(Out_Text)

	Call Str$Trim (%Descr(TempLine),%Descr(Prompt_String),%Ref(L))
	L=Min(L,80)     

C 		Fix things so we can do recall of the last line
	Call Set_Terminal_Line_Edit
	
	Call SMG$Put_Line(Line23MSG_Display,TempLine(:L),0)

	Call SMG$Paste_Virtual_Display (Line23MSG_Display,
	1		Pasteboard_ID,23,1)
	

	Call SMG$Erase_Display (Line24MSG_Display)

	Call SMG$Paste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID,24,1)

	
	Call SMG$Read_Composed_Line (Keyboard_ID, Key_Table_ID, 
	1		%Descr(Out_Text),%Descr('$ '),%Ref(Out_Bytes),
	2		Line24MSG_Display,,,,,,Terminator)
                                                    
C 		Put things back the way they were
	Call Set_Terminal_NoLine_Edit
	
	If (Out_Bytes .LE. 0) Call SMG$UnPaste_Virtual_Display 
	1	 (Line24MSG_Display,Pasteboard_ID)



	Call Str$Upcase (%Descr(Out_Text),%Descr(Out_Text))

	If (Out_Bytes .LE. 0) Call SMG$UnPaste_Virtual_Display 
	1	(Line23MSG_Display,Pasteboard_ID)

	Call SMG$Erase_Display (Line24MSG_Display)

        Return
        End

C-------------------------------------------------------------------C
C Routine to empty read ahead buffer from the VT100/VT2xx Crt.
C-------------------------------------------------------------------C
       Subroutine purgechar 
       Implicit Integer*4 (A - Z)
       Character*1 X
       Include 'Common.Dat'	
       External IO$M_Noecho,IO$_Readvblk,IO$M_Purge
C-------------------------------------------------------------------C

        F1 = %loc(IO$M_Purge) .OR. %Loc(Io$M_Noecho)

	Call SMG$Read_String (Keyboard_ID,X,,%Ref(0),%Ref(F1),
	1	,,,,Line23MSG_Display)

       Return                                                 
       End
