C*****************************************************************************
C
C  Construct Line for DCL from DM (using filenames)	July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C Wanna do DCL command.  Let them try.                              C
C-------------------------------------------------------------------C
       Subroutine DCL
       Implicit Integer*4 (A - Z)
       Integer*2 Nbytes, K
       Character*255 Temp_Line
       Character*80 Prompt	
       Include 'Common.Dat'
C-------------------------------------------------------------------C

        Parameter (Prompt = ' Type DCL Command:'//
	1 ' (Wildcards: "\" = Current file,'//
	2 ' "\\" = All Included files)')


        Call Get_Dollar_Line24 (Prompt,Temp_Line,NBytes)


        If (Nbytes .NE. 0) then 
	    Call Make_DCL_Line (Temp_Line, Nbytes )
 	    If ((Do_DCL) .AND. (.NOT.DM_Exit)) then
		Call Fix_Spawned_Terminal
		Call Do_One_DCL
		Call Restore_Spawned_Terminal
C	     		In case the subprocess directory was changed..
		Call Str$Trim (%Descr(Current_Device)
	1		,%Descr(Current_Device),%Ref(K))
		Exit_Com = 'SET DEFAULT '//
	1		Current_Device(:K)//Current_Dir
		Call Do_Immediate_DCL

	    Else If (Terminator .EQ. SMG$K_TRM_PF1) then
		Call Get1Char (Cmd)  ! Eat character after <GOLD>	
	    End If
        End If
	
        Return
        End

C-------------------------------------------------------------------C
C Make a DCL command, possibly using wild cards.                    C
C	Successful DCL line is created in Exit_Com from expanded TempLine
C	NBytes is 'valid' length of Temp_Line
C	Output line is put in Exit_Com
C-------------------------------------------------------------------C
       Subroutine Make_DCL_Line (Temp_Line, Nbytes)
       Implicit Integer*4 (A - Z)                  
       Logical Show_EM	
       Integer*2 Nbytes
       Integer*4 ThisLine	
       Character*(*) Temp_Line
       Character*255 DCL_LINE
       Character*1 C1
       Include 'Common.Dat'       
C-------------------------------------------------------------------C
       Do_DCL = .FALSE.     ! for safety	
       If (NBytes .LE. 0) GoTo 7000	
                                        
       Show_EM = .FALSE. ! don't show them the DCL they typed                  
	If (Lib$Matchc('\',Temp_Line(1:Nbytes)).le.0) then
		DCL_Line = Temp_Line(1:Nbytes)
		Call SMG$UnPaste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID)
		GOTO 100
	End If

       Ti = 0
       Di = 1
       DCL_Line = Blanks	
50     Continue
       Ti = Ti + 1
       If (Ti .GT. Nbytes) Goto 100
       If (Temp_Line(Ti : Ti) .NE. '\') then
         DCL_Line(Di : Di) = Temp_Line(Ti : Ti) ! Normal character.
         Di = Di + 1
         If (Di .GT. 254) goto 7000 ! error
       Else ! backslash = special char-intercept and change
         Show_EM = .TRUE. ! Since they are fancy show them the new DCL
         If (Temp_Line(Ti+1 : Ti+1) .NE. '\') then
           Call GetName(Current_Line,TempName, Itsa_Dir)
           Do J = 1, Lib$Matchc('  ', TempName) - 1
             DCL_Line(DI:DI) = TempName(J:J)
             DI = DI + 1
             If (Di .GT. 254) goto 7000 ! error
           End Do 
         Else ! handle two backslashes
           Ti = Ti + 1
           If (IncluCount .LT. 1) Goto 6000
           Do I = 1, IncluCount ! start main loop to construct line extension.
             If (I .GT. 1) then
               DCL_Line(DI:DI) = ',' ! insert a comma for them
               DI = DI + 1
               If (Di .GT. 254) goto 7000 ! error
             End If
	     ThisLine = InCluLines(I)
             Call GetName(ThisLine, TempName, Itsa_Dir)
             Do J = 1, Lib$Matchc('  ', TempName) - 1
               DCL_Line(DI:DI) = TempName(J:J)
               DI = DI + 1
               If (Di .GT. 254) goto 7000 ! error
             End Do 
           End Do
         End If
       End If
       Goto 50
100    Continue
       If (Show_EM) then
	Call Mess_Line ('$ '//DCL_Line)
C	Call PurgeChar
	C1 = 'N'

	Call SMG$Erase_Display (Line24MSG_Display)

   	Call SMG$Put_Line(Line24MSG_Display,
	1    ' Press "Q" to Quit, any other key to continue',0)

	Call SMG$Paste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID,24,1)

C      	Call WriteTerm (Cursor_Off)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 1)
        Call Get1Char(C1)    
C	Call WriteTerm (Cursor_On)
	Call SMG$Set_Cursor_Mode (Pasteboard_ID, 0)

	Call SMG$UnPaste_Virtual_Display (Line24MSG_Display,
	1		Pasteboard_ID)

	Call SMG$Erase_Display (Line24MSG_Display)

	If (Terminator .EQ. SMG$K_TRM_PF1) then  ! Might be Gold_A
		GoTo 8000
	End If

        If ((C1 .EQ. 'Q') .OR. (C1 .EQ. 'q')) Goto 8000

        Do I = 1, IncluCount
  	   ThisLine = InCluLines(I)
           Call SMG$Erase_Chars (Files_Display,1,%Ref(ThisLine),
	1		Flag_Pos)
        End Do
           IncluCount = 0
       End If     

       Exit_Com = DCL_Line
       Do_DCL = .TRUE. ! they decided to go ahead and do it
       goto 8000

6000   Continue
	Call Mess_Wait(' No files included.'//
	1  '  "\\" doesn''t make sense')

       Goto 8000

7000   Continue
	Call Mess_Wait(' Too many characters on DCL line.'//
	1	'  Untag some files and try again.')


8000   Continue
	
       Return
       End

