C*****************************************************************************
C
C  Revisions (Version 6.x)            July-Sept, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************

C	This is file Screen_Management.for

C  Contents:
C	Create_SMG_Environment
C	Create_Menu
C	SetChoices
C	RePaste_Normal and RePaste_More
C	Broadcast_Handler_AST
C
C-------------------------------------------------------------------C
C	Create the SMG environment
C-------------------------------------------------------------------C
       Subroutine Create_SMG_Environment
       Implicit Integer*4 (A - Z)
       Character*15 Temp15	
	
       Include 'Common.Dat'	
       Include '($DVIDEF)'
	
       EXTERNAL BROADCAST_HANDLER_AST	
C-------------------------------------------------------------------C

C See if the terminal is a VT300 type
	
	Call Lib$GetDVI (DVI$_DEVTYPE, ,'TT:',Type_Number)
	If (Type_Number .EQ. 112) then
		VT300 = .TRUE.
	Else
		VT300 = .FALSE.
	End If
	
	Call SMG$Create_Pasteboard
     1		 (Pasteboard_ID,,PB_Rows,PB_Columns)

	Have_Broadcast = .FALSE.
	Call SMG$Set_Broadcast_Trapping 
     1		 (Pasteboard_ID, Broadcast_Handler_AST)

	Call SMG$Create_Key_Table (Key_Table_ID)
	
	Call SMG$Create_Virtual_Keyboard (Keyboard_ID,
	1	'TT')

C 		Use NoTabs, as SMG gets confused if we don't
	Call SMG$Control_Mode (Pasteboard_ID,
	1	,Entry_Control_Mode)
	Current_Control_Mode = Entry_Control_Mode + SMG$M_NOTABS
	Call SMG$Control_Mode (Pasteboard_ID,
	1	Current_Control_Mode)
	

C------------------------------------------------------------------

	Call SMG$Create_Virtual_Display
     1		 (Initial_Display_Length,Initial_Files_Width,
     2 	 	  Files_Display,SMG$M_Border)
	Current_Display_Length = Initial_Display_Length
	Current_Files_Width    = Initial_Files_Width

	Call SMG$Create_Virtual_Display
     1		 (Initial_Display_Length,Attributes_Display_Width,
     2		  Attributes_Display,SMG$M_Border)
	If (VT300) then
            Call SMG$Change_Rendition
     1		 (Attributes_Display,1,1,1,Attributes_Display_Width,
     2		  BR_Mask)	
	Else
            Call SMG$Change_Rendition
     1		 (Attributes_Display,1,1,1,Attributes_Display_Width,
     2		  SMG$M_Reverse)	
	End If	

	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line23_Display,,BRU_Mask)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line23_Display,,RU_Mask)
	End If
	
	Write (Temp15(1:3),300) Version
300     Format(I3)
	If (Temp15(1:1) .EQ. ' ') then
		If (Temp15(2:2) .EQ. ' ') then
	     		Temp15(1:3) = Temp15(3:3)//'.0'  
		Else
			Temp15(1:2) = Temp15(2:2)//'.'
		End If
	End If

	If (Forward) then
		Temp15(4:15) = '     Forward'
	Else
		Temp15(4:15) = '     Reverse'
	End If

	Call SMG$Put_Line(Line23_Display,
	1	%Descr(' DM Version '//Temp15),0)



	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Directory_Display,,BRU_Mask)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Directory_Display,,RU_Mask)
	End If
	Call SMG$Put_Line(Directory_Display,' Directory ',0)

	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,16,Blocks_Display,,BRU_Mask)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,16,Blocks_Display,,RU_Mask)
	End If
	Call SMG$Put_Line(Blocks_Display,'         Blocks ',0)

	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,20,Purge_Display,,SMG$M_Reverse)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,20,Purge_Display,,BR_Mask)
	End If
	Call SMG$Put_Line(Purge_Display,' (    of     Files) ',0)

	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line23MSG_Display,,BR_Mask)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line23MSG_Display,,SMG$M_Reverse)
	End If
	
	Call SMG$Create_Virtual_Display
     1		 (1,80,Line24_Display)
	Call Create_Menu

	Call SMG$Create_Virtual_Display
     1		 (1,4,Less_Display)
	Call SMG$Put_Line(Less_Display,'Less',0)
	Call SMG$Change_Rendition(Less_Display,1,1,1,1,SMG$M_Bold)

	Call SMG$Create_Virtual_Display
     1		 (1,4,Empty_Display)
	Call SMG$Put_Line(Empty_Display,'    ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Line24MSG_Display)
                       
	If (VT300) then
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line24BBMSG_Display,,BR_Mask)
	Else
	    Call SMG$Create_Virtual_Display
     1		 (1,80,Line24BBMSG_Display,,SMG$M_Reverse)
	End If
	Call SMG$Put_Line_Wide (Line24BBMSG_Display,
	1	'   **** Press any key to continue ****   ',0)

	Call SMG$Create_Virtual_Display
     1		 (1,80,Working_Display,,BRB_Mask)
	Call SMG$Put_Line_Wide (Working_Display,
	1	'  Working',0)
                       
	Call SMG$Create_Virtual_Display
     1		 (8,80,Window1_Display,SMG$M_Border)
	Call SMG$Set_Display_Scroll_Region (Window1_Display)

	Call SMG$Create_Virtual_Display
     1		 (22,80,Window2_Display)


C	NOW SET UP THE INITIAL SCREEN
C----------------------------------------------------------------------

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$Paste_Virtual_Display
     1		 (Attributes_Display,Pasteboard_ID,28,File_Attr_Pos)
 
	Call SMG$Paste_Virtual_Display
     1		 (Files_Display,Pasteboard_ID,1,1)
  
	Call SMG$Paste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Dir_Display_Pos = 69
	Call SMG$Paste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

	Call SMG$Paste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)

C	  This will be done by DM.FOR
C	Call SMG$End_Pasteboard_Update (Pasteboard_ID)
	
	

	Return
	End

C-------------------------------------------------------------------C
C	Create Menu for Line 24 of the SMG Screen
C-------------------------------------------------------------------C
       Subroutine Create_Menu
       Implicit Integer*4 (A - Z)
       Character*80 Line	
       Include 'Common.Dat'	
	
C-------------------------------------------------------------------C

	Line = '$ % @ * A Z W Tag/Unt Quit eXit Ren View Edit FMS'
     1       //' More Info Del Copy purGe Print'

	Call SMG$Put_Line (Line24_Display,Line,0)

	Call SMG$Change_Rendition (Line24_Display,1,1,1,15,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,19,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,23,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,29,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,33,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,37,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,42,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,47,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,51,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,56,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,61,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,65,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,73,1,1,SMG$M_Bold)
	Call SMG$Change_Rendition (Line24_Display,1,76,1,1,SMG$M_Bold)

	Return
	End


C-------------------------------------------------------------------C
C SetChoices : Controls the modification of the menu (Line24) 
C  displayed on the bottom line of the CRT.  This is the only place C
C  that Line24_Display gets changed.                                C
C	Also, as appropriate, re-arranges the order of pasting to
C  either conceal or reveal the "attributes" window.
C-------------------------------------------------------------------C
       Subroutine SetChoices (Requested_Menu)

       Implicit Integer*4 (A - Z)
       Integer*4 Requested_Menu, MoreHere, LessHere	
       Logical Did_Not_Load	
       Include 'Common.Dat'
	Data MoreHere /51/   
	Data LessHere /56/
C-------------------------------------------------------------------C

C	MoreHere = 51
C	LessHere = 56

  	If (Requested_Menu .NE. Menu) then

      		If (Menu .EQ. More_Mode) then
			Line23_Dirty = .TRUE.
			Call SMG$UnPaste_Virtual_Display
	1			(Empty_Display,Pasteboard_ID)
		End If		



		If    (Requested_Menu .EQ. Normal_Mode) then
C				Was MORE or INFO, going to NORMAL
 			Call SMG$UnPaste_Virtual_Display
	1			(Less_Display,Pasteboard_ID)
			Call RePaste_Normal
			Menu = Requested_Menu

		Else If (Requested_Menu .EQ. Info_Mode) then
C				Was NORMAL or MORE, going to INFO
			If (Menu .EQ. Normal_Mode) Call RePaste_More
			Call SMG$Paste_Virtual_Display
	1			(Less_Display,Pasteboard_ID,
	2			 24,LessHere)
			Menu = Requested_Menu

		Else If (Requested_Menu .EQ. More_Mode) then
C				Was NORMAL or INFO, going to MORE
			If (Menu .EQ. Normal_Mode) Call RePaste_More
			If (.NOT.Have_More)        Call Get_Attributes

			Call SMG$Paste_Virtual_Display
	1			(Less_Display,Pasteboard_ID,
	2			 24,LessHere)

			Call SMG$Paste_Virtual_Display
	1			(Empty_Display,Pasteboard_ID,
	2				24,MoreHere)

			Menu = Requested_Menu

		Else
			Menu = Not_Set
			Call SMG$Put_Line 
	1			(Line24_Display,
	2			'**** Error in SetChoices ****',0)

		End If

C		Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	End If
9999  Return
      End
                        
C-------------------------------------------------------------------C
       Subroutine Repaste_Normal

       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)


	Call SMG$RePaste_Virtual_Display
     1		 (Files_Display,Pasteboard_ID,2-TopLine,1)
 
	Call SMG$RePaste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Call SMG$RePaste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

     	If (Blocks_On) Call SMG$Paste_Virtual_Display 
     1		(Blocks_Display,Pasteboard_ID,23,65)

	Call SMG$RePaste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)


	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return              
	End

C-------------------------------------------------------------------C
       Subroutine Repaste_More

       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$RePaste_Virtual_Display
     1		 (Attributes_Display,Pasteboard_ID,
     2		  2-TopLine,File_Attr_Pos)
 
	Call SMG$RePaste_Virtual_Display
     1		 (Line23_Display,Pasteboard_ID,23,1)

	Call SMG$RePaste_Virtual_Display
     1		 (Directory_Display,Pasteboard_ID,23,
     2		  %Ref(Dir_Display_Pos))

     	If (Blocks_On) Call SMG$Paste_Virtual_Display 
     1		(Blocks_Display,Pasteboard_ID,23,65)

	Call SMG$RePaste_Virtual_Display
     1		 (Line24_Display,Pasteboard_ID,24,1)


	If ( (Current_Files_Width + 1) .EQ. File_Attr_Pos)
	1	Call SMG$Repaint_Screen (Pasteboard_ID) ! "Bug in SMG"

	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return              
	End

C-------------------------------------------------------------------C
C	Handle AST from Broadcast Message
C-------------------------------------------------------------------C
       Subroutine Broadcast_Handler_AST
       Implicit Integer*4 (A - Z)
       Integer*2 Message_Length
       Include 'Common.Dat'	

C-------------------------------------------------------------------C

	Call SMG$Get_Broadcast_Message 
	1	(Pasteboard_ID, 
	2	 Message(Msgstart(Num_Message+1):),Message_Length)
	
C 		Discard if we're out of space
	If (Msgstart(Num_Message+1) .GE. Total_Message_Chars) Return
	If (Num_Message 	    .GE. Max_Messages)        Return
C 		Discard Partials
	If ((Msgstart(Num_Message+1)+Message_Length) 
	1			    .GT. Total_Message_Chars) Return
	
C 		OK, we can do it
	Num_Message = Num_Message + 1             
	
	If (Message_Length .LE. 0) then
		Message_Length = 1
		Message(Msgstart(Num_Message):Msgstart(Num_Message)) = ' '
	End If
	
	Msgstart(Num_Message+1) = Msgstart(Num_Message) + Message_Length
                   
C 		Now, tell the user every few messages
	
	If (Num_Message .EQ. 1) then
	        Have_Broadcast = .TRUE.	
	Else If (MOD(Num_Message,20) .EQ. 0) then
	        Have_Broadcast = .TRUE.	
		Call SMG$Ring_Bell (Line24_Display)
		Write (Broadcast_Msg(19:44),3010)
	1		Num_Message, ' Broadcast Messages.'
3010		Format (I4,A)	
	End If
	
	
       Return
       End			
