C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************

C	This is file Screen_Paint.For

C		Contents:
C	Write_Screen
C	Write22
C	Make_Bright & Make_Dull
C	Fix23 & Fix24

C-------------------------------------------------------------------C
C Write "some" lines of the data array on the CRT.  Display data    C
C startswith TOPLINE.  TOPLINE is a global variable.                C
C     Write 22 Lines - and, conditionally write Lines 23 & 24
C-------------------------------------------------------------------C
       Subroutine Write_Screen
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Call Write22
	If (Line23_Dirty) Call Fix23
        If (Line24_Dirty) Call Fix24
	Return
	End

C-------------------------------------------------------------------C
C Write 22 lines of the data array on the CRT.  Display data starts C
C with TOPLINE.  TOPLINE is a global variable.                      C
C-------------------------------------------------------------------C
       Subroutine Write22
       Implicit Integer*4 (A - Z)
       Integer*4 Row	
       Include 'Common.Dat'
C-------------------------------------------------------------------C

	Row = 2 - TopLine
C		BUG in SMG$ - See GET_FILENAMES.FOR for note about Label.
C 		This Bug has been verified as high as VMS 4.5
	If (Row .EQ. 0) then
		Print *,' ** INTERNAL ERROR ** TopLine is Wrong.'
		Row = 1
		TopLine = 1
		Current_Line = Current_Line - 1
	End If

	Call SMG$Begin_Pasteboard_Update (Pasteboard_ID)

	Call SMG$Move_Virtual_Display
	1	(Files_Display,Pasteboard_Id,
	2	Row,1)


	Call SMG$Move_Virtual_Display
	1	(Attributes_Display,Pasteboard_Id,
	2	Row,File_Attr_Pos)

	Call SMG$End_Pasteboard_Update (Pasteboard_ID)

	Return
	End

C-------------------------------------------------------------------C
C Make Current Cursor Line Bright
C	NOTE: Can have strange results with non-data cursor line.
C-------------------------------------------------------------------C
       Subroutine Make_Bright 
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C-------------------------------------------------------------------C


	If (.NOT. Highlight) Go To 100
	
  	Call SMG$Change_Rendition
	1	(Files_Display,Current_Line,1,1,
	2	Current_Files_Width,SMG$M_Bold,0)	

	If (Have_More .OR. (Menu .EQ. Info_Mode))
	1  	Call SMG$Change_Rendition
	2	(Attributes_Display,Current_Line,1,1,
	3	 Attributes_Display_Width,SMG$M_Bold,0)	

100	Call SMG$Set_Cursor_Abs (Files_Display,
	1	Current_Line,Flag_Pos)

	Call SMG$Read_From_Display (Files_Display,Star)

	If (Star .EQ. Tag_Char) 
	1	Call SMG$Put_Chars (Files_Display,Tag_Char
	2		,,,,BR_Mask)

	 Return
	 End

C-------------------------------------------------------------------C
C Make Current Cursor Line Dull
C	NOTE: Can have strange results with non-data cursor line.
C-------------------------------------------------------------------C
       Subroutine Make_Dull
       Implicit Integer*4 (A - Z)
       Character*1 Star	
       Include 'Common.Dat'
C-------------------------------------------------------------------C


	If (.NOT. Highlight) Go To 100
	
	Call SMG$Change_Rendition
	1	(Files_Display,Current_Line,
	2	 1,1,Current_Files_Width,SMG$M_Bold,SMG$M_Bold)	

	If (Have_More .OR. (Menu .EQ. Info_Mode))
	1	Call SMG$Change_Rendition
	2	(Attributes_Display,Current_Line,
	3	 1,1,Attributes_Display_Width,SMG$M_Bold,SMG$M_Bold)

100	Call SMG$Set_Cursor_Abs (Files_Display,
	1	Current_Line,Flag_Pos)

	Call SMG$Read_From_Display (Files_Display,Star)

	If (Star .EQ. Tag_Char) 
	1	Call SMG$Put_Chars (Files_Display,Tag_Char
	2		,,,,SMG$M_Reverse)


  	Return
	End

C-----------------------------------------------------------------C
C Fix CRT line 23 back after putting a message on it.             C
C-----------------------------------------------------------------C
       Subroutine Fix23
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C---------------------------------------------------------C

        If (Have_More) then
		If (.NOT.Blocks_On) then
		   Call SMG$Paste_Virtual_Display
	1		(Blocks_Display,Pasteboard_ID,23,65)
		   Blocks_On = .TRUE.
		   Dir_Display_Pos = Dir_Display_Pos - 15

		   Call SMG$Move_Virtual_Display (Directory_Display,
	1	 	Pasteboard_ID,23,%Ref(Dir_Display_Pos))

		End If
	Else 
		If (Blocks_On) then
		   Call SMG$Unpaste_Virtual_Display
	1		(Blocks_Display,Pasteboard_ID)
		   Blocks_On = .FALSE.
		   Dir_Display_Pos = Dir_Display_Pos + 15

		   Call SMG$Move_Virtual_Display (Directory_Display,
	1	 	Pasteboard_ID,23,%Ref(Dir_Display_Pos))

		End If
	End If


	If (Purge_On) then
		Call SMG$Unpaste_Virtual_Display
	1		(Purge_Display,Pasteboard_ID)
			 Purge_On = .FALSE.
	End If


	If (Line23MSG_On) then
		Call SMG$Unpaste_Virtual_Display
	1		(Line23MSG_Display,Pasteboard_ID)
			 Line23MSG_On = .FALSE.
	End If


	If (Forward) then
		Call SMG$Put_Chars (Line23_Display,'Forward',1,21)
	Else
		Call SMG$Put_Chars (Line23_Display,'Reverse',1,21)
	End If

    	Line23_Dirty = .FALSE.
                           
       Return
       End                             

C--------------------------------------------------------------------C
C Fix CRT line 24 back after putting a message on it or after change.
C--------------------------------------------------------------------C
       Subroutine Fix24
       Implicit Integer*4 (A - Z)
       Include 'Common.Dat'
C---------------------------------------------------------C

	If (Line24MSG_On) then
		Call SMG$Unpaste_Virtual_Display
	1		(Line24MSG_Display,Pasteboard_ID)
		Line24MSG_On = .FALSE.
	End If

	If (Line24BBMSG_On) then
		Call SMG$Unpaste_Virtual_Display
	1		(Line24BBMSG_Display,Pasteboard_ID)
		Line24BBMSG_On = .FALSE.
	End If

	Line24_Dirty = .FALSE.

	Return
	End
                     
