C-------------------------------------------------------------------C
C CAUTION: TT_Channel must be set by some other routine, using
C       Stat = SYS$Assign('TT', TT_Channel,,)
C       If (.not. Stat) Call Lib$Stop(%Val(Stat))
C before using any of these routines.  Note: TT_Channel is in common.
C-------------------------------------------------------------------C
C  Directory Management        January 1983                         C
C  Written by John C. Hayre, Texas Instruments                      C
C  Send suggestions and/or complaints to:                           C
C                                                                   C
C               Veeco Integrated Automation			    C
C               10355 Brockwood Rd				    C
C               Dallas, Texas 75238                                 C
C               (Attention John Hayre)                              C
C                                                                   C
C  Phone: 214-349-8482                                              C
C-------------------------------------------------------------------C
C*****************************************************************************
C
C  Revisions (Version 6.x)            July, 1986
C	Dale E. Coy
C	Los Alamos National Laboratory
C	(505) 667-3270
C
C*****************************************************************************
C-------------------------------------------------------------------C
C  Write a Command to the Terminal (Independent of Cursor Position)
C	Used for stuff like Cursor_Off, etc.
C-------------------------------------------------------------------C
       Subroutine WriteTerm (Data)
	
       Implicit Integer*4 (A - Z)
       Character*(*) Data
       Integer*2 NBytes	                   ! Changed from Default
	
       Include '($IODEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	NBytes = Len(Data)


C 		Carriage Control Specifier - None
         P4 = '00000000'X
	
	
         Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_WRITEVBLK),
     1   %Ref(IOSB),,,%Ref(Data),%Val(NBytes),,%Val(P4),,)

         If (.not. Stat) Call Lib$Stop(%Val(Stat))

       Return
       End

C-------------------------------------------------------------------C
C  Save entry characteristics of the terminal.
C	Since we jerk around the terminal fairly badly, we save
C 	these and restore them on exit.
C-------------------------------------------------------------------C
       Subroutine Save_Entering_Terminal
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Call WriteTerm (SvTerminal)              ! Save entering term. status
	
	
	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SENSEMODE),
	1   %Ref(IOSB),,,%Ref(TT_Entry_Char),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	
	Return
	End

C-------------------------------------------------------------------C
C  Restore entry characteristics of the terminal.
C	Since we jerk around the terminal fairly badly, we save
C 	these and restore them on exit.
C-------------------------------------------------------------------C
       Subroutine Restore_Entering_Terminal
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Call WriteTerm (Reterminal)    ! Put the tube back the way it was.
	
	
	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SETMODE),
	1   %Ref(IOSB),,,%Ref(TT_Entry_Char),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	Return
	End

C-------------------------------------------------------------------C
C  Save characteristics of the terminal before going to subprocess.
C	Since we jerk around the terminal fairly badly, we save
C 	these, set the terminal the way it was on entry, 
C 	and restore them on exit from the subprocess.
C-------------------------------------------------------------------C
       Subroutine Fix_Spawned_Terminal
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SENSEMODE),
	1   %Ref(IOSB),,,%Ref(TT_Spawned_Char),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SETMODE),
	1   %Ref(IOSB),,,%Ref(TT_Entry_Char),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	
	Return
	End

C-------------------------------------------------------------------C
C  Restore original characteristics of the terminal after return
C 	from subprocess.
C-------------------------------------------------------------------C
       Subroutine Restore_Spawned_Terminal
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SETMODE),
	1   %Ref(IOSB),,,%Ref(TT_Spawned_Char),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

C 		Some things take us out of application_keypad mode.
	
	Call WriteTerm (Application_Keypad)
	
	Return
	End

C-------------------------------------------------------------------C
C  Set Terminal to NO_LINE_EDITING mode.
C	This is done, among other things, so we can use the F6 key
C 	
C-------------------------------------------------------------------C
       Subroutine Set_Terminal_NoLine_Edit
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include '($TTDEF)'
       Include '($TT2DEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SENSEMODE),
	1   %Ref(IOSB),,,%Ref(TChar_Buf),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	If (BTest( TT2_Char, TT2$V_Editing)) then
	    TT2_Char = IBClr ( TT2_Char, TT2$V_Editing)
	
	    Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SETMODE),
	1       %Ref(IOSB),,,%Ref(TChar_Buf),
	2       %Val(TChar_Buf_Length),,,,)

	    If (.not. Stat) Call Lib$Stop(%Val(Stat))
	
	End If


	Return
	End

C-------------------------------------------------------------------C
C  Set Terminal to LINE_EDITING mode.
C	
C-------------------------------------------------------------------C
       Subroutine Set_Terminal_Line_Edit
	
       Implicit Integer*4 (A - Z)
	
       Include '($IODEF)'
       Include '($TTDEF)'
       Include '($TT2DEF)'
       Include 'Common.Dat'

C-------------------------------------------------------------------C


	Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SENSEMODE),
	1   %Ref(IOSB),,,%Ref(TChar_Buf),
	2   %Val(TChar_Buf_Length),,,,)

	If (.not. Stat) Call Lib$Stop(%Val(Stat))

	If (.NOT.BTest( TT2_Char, TT2$V_Editing)) then
	    TT2_Char = IBSet ( TT2_Char, TT2$V_Editing)
	
	    Stat = Sys$QIOW(,%Val(TT_Channel),%VAL(IO$_SETMODE),
	1       %Ref(IOSB),,,%Ref(TChar_Buf),
	2       %Val(TChar_Buf_Length),,,,)

	    If (.not. Stat) Call Lib$Stop(%Val(Stat))
	
	End If


	Return
	End

