$ ! INSTALL_WPE.COM - Installation procedure for WPE
$ !   
$	SET NOON	! Continue on error.  Important in case BUILD_WPE -
$ !				fails because [SYSHLP.EXAMPLES] is missing. 
$	wo := "WRITE SYS$OUTPUT"
$	wo "** Installing WPE Version 5.0 **"
$	wo " "
$	wo "Beginning Installation of WPE at " + f$time()
$	wo " "
$ ! 
$ !   Check and set privileges
$ ! 
$	entry_privs = f$setprv("SYSNAM,CMKRNL")
$	if f$privileges("SYSNAM,CMKRNL") .nes. "TRUE"
$	    then
$		wo "You need SETPRV or SYSNAM,CMKRNL to install WPE."
$		EXIT
$	    endif
$ ! 
$ ! 
$ !   Check the Environment
$ !   
$	is_cluster = f$getsyi("CLUSTER_MEMBER")
$	have_wpe  := 'WPE'
$	have_more := 'MORE'
$	have_mail := 'MAIL'
$	have_mailedit = f$trnlnm("MAIL$EDIT")
$	ansi_crt   = f$getdvi("TT","TT_ANSICRT")
$ ! 
$ !   DCLTABLES
$ !   
$	wo " "
$	wo "Installing the WPE command in DCLTABLES."
$	SET COMMAND/TABLES=SYS$COMMON:[SYSLIB]DCLTABLES/-
	  OUT=SYS$COMMON:[SYSLIB]DCLTABLES    WPEDIT
$ ! 		and re-install the tables
$ 	INSTALL REPLACE SYS$SHARE:DCLTABLES.EXE
$	wo -
   "SYS$COMMON:[SYSLIB]DCLTABLES.EXE was not purged.  You may wish to purge it."
$ ! 
$	wo " "
$	inquire want_purge -
    "Do you want to purge files replaced by the REST of this installation? [No]"
$ ! 
$	wo " "
$	wo "Do you want to delete files BUILT in this directory"
$	inquire want_delete -
	  "after they are COPIED to another directory? [No]"
$ ! 
$ ! 
$ !   Create the Calluser Procedure
$ !   
$	wo " "
$	wo "Linking the TPU$CALLUSER procedure WPE_CALLUSER."
$	@link_calluser
$	wo "Moving WPE_CALLUSER.EXE to SYS$SHARE"
$	copy wpe_calluser.exe sys$common:[syslib]wpe_calluser.exe/prot=wo:re
$	wo "Installing WPE_CALLUSER.EXE as TPU$CALLUSER"
$	DEFINE/USER SYS$OUTPUT NL:
$	DEFINE/USER SYS$ERROR NL:
$	INSTALL REMOVE TPU$CALLUSER
$ 	DEFINE/SYSTEM/EXE tpu$calluser sys$share:wpe_calluser.exe
$	INSTALL CREATE TPU$CALLUSER/OPEN/HEADER/SHARE
$	if want_purge then purge sys$share:wpe_calluser.exe
$	if want_delete then delete wpe_calluser.exe;*
$ ! 
$ !   Create WPE.tpu$section
$ !   
$	wo " "
$	wo "Creating the TPU$SECTION WPE.TPU$SECTION."
$	@build_wpe
$	wo "Moving WPE.TPU$SECTION to SYS$SHARE"
$	copy wpe.tpu$section sys$common:[syslib]wpe.tpu$section/prot=wo:re
$	wo "Installing WPE.TPU$SECTION as TPU$SECTION"
$	DEFINE/USER SYS$OUTPUT NL:
$	DEFINE/USER SYS$ERROR NL:
$	INSTALL REMOVE TPU$SECTION
$ 	DEFINE/SYSTEM/EXE tpu$section  sys$share:wpe.tpu$section
$	INSTALL CREATE TPU$SECTION/OPEN/HEADER/SHARE
$	if want_purge then purge sys$share:wpe.tpu$section
$	if want_delete then delete wpe.tpu$section;*
$	if want_delete then delete wpe.init;*
$	if want_delete then delete wpe.list;*
$ ! 
$ !   Check about EDW
$ !   
$	if ansi_crt .nes. "TRUE"
$	    then
$		type sys$input

If you want the EDT-keypad section (EDW.TPU$SECTION), you must use an ANSI
Terminal to run BUILD_EDW.COM, and then move EDW.TPU$SECTION to SYS$SHARE.

$	    else
$		wo " "
$		inquire want_edw -
	  "Do you want to build the EDT-keypad section (EDW.TPU$SECTION)? "
$		if want_edw
$		    then
$			wo " "
$			wo "Creating the section file EDW.TPU$SECTION."
$			@build_edw
$			wo "Moving EDW.TPU$SECTION to SYS$SHARE"
$			copy edw.tpu$section -
	  			sys$common:[syslib]edw.tpu$section/prot=wo:re
$			if want_purge then purge sys$share:edw.tpu$section
$			if want_purge then purge edw_master.file
$			if want_purge then purge edw_options.tpu
$			if want_purge then purge edw_version.dat
$			if want_delete then delete edw.tpu$section;*
$			if want_delete then delete edw.init;*
$			if want_delete then delete edw.list;*
$		    endif
$	    endif
$ ! 
$ !   Create WPEMAIN.EXE 
$ !   
$	wo " "
$	wo "Linking the main program WPEMAIN.EXE"
$	@link_wpemain
$	wo "Moving WPEMAIN.EXE to SYS$COMMON:[SYSEXE]"
$	copy wpemain.exe sys$common:[sysexe]wpemain.exe/prot=wo:re
$	wo "Installing WPEMAIN.EXE"
$	DEFINE/USER SYS$OUTPUT NL:
$	DEFINE/USER SYS$ERROR NL:
$	INSTALL REMOVE SYS$COMMON:[SYSEXE]WPEMAIN.EXE
$	INSTALL CREATE SYS$COMMON:[SYSEXE]WPEMAIN.EXE/OPEN/HEADER/SHARE
$	if want_purge then purge sys$common:[sysexe]wpemain.exe
$	if want_delete then delete wpemain.exe;*
$ ! 
$ !   Create WPEHELP.HLB
$ !   
$	wo " "
$	wo "Creating the help library WPEHELP.HLB"
$	lib/create/help wpehelp.hlb wpehelp.hlp
$	wo "Moving WPEHELP.HLB to the default location SYS$COMMON:[SYSHLP]"
$	copy wpehelp.hlb sys$common:[syshlp]wpehelp.hlb/prot=wo:re
$	if want_purge then purge sys$common:[syshlp]wpehelp.hlb
$	if want_delete then delete wpehelp.hlb;*
$		type sys$input

If you move WPEHELP.HLB to some other directory, you must provide a definition:
	DEFINE WPEHELP wherever_it_is

$ ! 
$ !   Move WPE_STARTUP.COM
$ !   
$	wo " "
$	wo "Moving WPE_STARTUP.COM to the default location SYS$COMMON:[SYSMGR]"
$	copy wpe_startup.com sys$common:[sysmgr]wpe_startup.com
$	if want_purge then purge sys$common:[sysmgr]wpe_startup.com
$	type sys$input

You must edit your startup file(s) [SYSTARTUP_V5.COM]:  Remove the following:
	Definition of TPU$SECTION
	Definition of TPU$CALLUSER
	Installation of WPE.TPU$SECTION

ADD, in your system startup procedure:
	$  @SYS$MANAGER:WPE_STARTUP.COM

$ ! 
$ !   Move MORE.COM
$ !   
$	wo " "
$	wo "Moving MORE.COM to the default location SYS$COMMON:[SYSMGR]"
$	copy more.com sys$common:[sysmgr]more.com/prot=wo:re
$	if want_purge then purge sys$common:[sysmgr]more.com
$	if have_more .nes. ""
$	    then
$		wo "Your definition of MORE is:"
$		show symbol MORE
$		type sys$input
If this is not equivalent to @SYS$COMMON:[SYSMGR]MORE.COM, you must either:
	1.  Change your system-wide definition of MORE,   or
	2.  Move MORE.COM to your chosen location.

$	    else
$		type sys$input

You must provide a system-wide definition of MORE:
	MORE :== @SYS$COMMON:[SYSMGR]MORE.COM

$	    endif
$ ! 
$	wo " "
$	wo "We recommend that a MAILEDIT.COM file NOT be used with WPE."
$	inquire want_mailedit_anyway -
	  "Do you want MAILEDIT.COM anyway? [No]"
$	if .not. want_mailedit_anyway then goto MAIL_SYMBOL_MESSAGE
$ ! 
$ !   Move MAILEDIT.COM
$ !   
$	wo " "
$	wo "Moving MAILEDIT.COM to the default location SYS$COMMON:[SYSMGR]"
$	copy mailedit.com sys$common:[sysmgr]mailedit.com/prot=wo:re
$	wo " "
$	if want_purge then purge sys$common:[sysmgr]mailedit.com
$	if have_mailedit .nes. ""
$	    then
$		wo "MAIL$EDIT on this system is defined as: ''have_mailedit'"
$		type sys$input
Although a NEW MAILEDIT.COM file has been copied to SYS$COMMON:[SYSMGR], 
and you may use it, MAIL editing will be much more efficient if:
	1.  You do NOT define MAIL$EDIT (remove the current definition), and
	2.  Users do (once) MAIL> SET EDITOR TPU

$	    else
$		type sys$input

Although a MAILEDIT.COM file has been copied to SYS$COMMON:[SYSMGR], we
recommend that you NOT use it.  MAIL editing will be much more efficient if:
	1.  You do NOT define MAIL$EDIT
	2.  Users do (once) MAIL> SET EDITOR TPU

$	    endif
$ ! 
$MAIL_SYMBOL_MESSAGE:
$	wo " "
$	if have_mail .nes. ""
$	    then
$		wo "The symbol MAIL on this system is defined as:"
$		show symbol MAIL
$		type sys$input
The recommended system-wide symbol is:
  MAI*L :== MAIL/EDIT=(SEND,REPLY=EXTRACT)

$	    endif
$ ! 
$INSTRUCTIONS:
$ ! 
$ ! Now provide other instructions.....  
$ !   
$	if have_wpe .nes. ""
$	    then
$		type sys$input

You must delete the symbol WPE before the the DCLTABLES definition will work.

$	    endif
$ ! 
$	if is_cluster
$	    then
$		type sys$input

On all OTHER nodes of the cluster, you must issue the commands:
    (You will need CMKRNL privilege.)

	INSTALL REPLACE SYS$SHARE:DCLTABLES.EXE

	@SYS$MANAGER:WPE_STARTUP.COM

$	    endif
$ ! 
$ ! 
$	wo " "
$	wo "WPE Installation procedure finished at " + f$time()
$ ! 
$ !   
$	type sys$input

Please logout and log in, to allow the DCLTABLES change to take effect.
Then test WPE for proper installation.

$	exit_privs = f$setprv(entry_privs)
