 	Program WPEMAIN
C 
C   Activated by the .CLD - accepts input parameters, checks the file name if
C   any, and transfers appropriate information to TPU.  Sets appropriate
C   symbol and logical values.  Will accept a SINGLE filename for editing. 
C   The filename may include wildcards, which will be passed on to TPU.  If a
C   version number of any kind is supplied, it is disregarded and not passed. 
C   Switches on the command line are passed appropriately to TPU.
C 
C ======================================================================
C	29-SEP-1988	Version 5.001
C	
C	Dale E. Coy				Phone: (505) 667-3270/665-0145
C	Los Alamos National Laboratory
C	CRM-2, MS/B270, PO Box 1663
C	Los Alamos, NM 87544
C ======================================================================
	
	Include 'WPE_Common.Dat'
	Include	'($LNMDEF)'
	Include	'($RMSDEF)'
	
	Structure /TrnLnm_Item_List/
	  Integer*2 BufLen
	  Integer*2 Code		/LNM$_String/
	  Integer*4 Dst_Address
	  Integer*4 Length_Address
	  Integer*4 End_List		/0/
	End Structure

	Record /TrnLnm_Item_List/ T_ItmLst

C -------------------------------------------------------------------------
	
C Get the data from the command line.  The subroutine gets info about:
C   Have_Input_File_Name and Input_File_Name(:Input_File_Name_Length)
C   Have_Recover (true if it's on the command line) and Recover (yes/NO)
C   Have_CLI_Start_Position (true if it's on the command line)
C It also compresses the command line until only qualifiers are present in
C   	The_Line (:The_Line_Length)
	
 	Call Get_Command_Line_Data
	
	
C If we don't have a file name in the command line, then we would like to get
C   one from the symbol WPE_LASTFILE, if it exists.  We may get:
C   Have_WPE_Lastfile and WPE_Lastfile (:WPE_lastfile_Length)
	
	If (.NOT. Have_Input_File_Name) then
		Call Get_WPE_Lastfile
	Else
		Have_WPE_Lastfile = .FALSE.
C 			And preserve the start_position in case of crash.
		If (Have_CLI_Start_Position) then
			Call Lib$Set_Logical 
	1		  ('TPU_POSITION',
	2		   Start_Position(:Start_Position_Length))
		Else
			Call Lib$Set_Logical 
	1		  ('TPU_POSITION', '/START_POSITION=(1,1)')
		End If
	End If
	
	
C We need the logical TPU_POSITION, if it's available.  We get:
C   Have_TPU_Start_Position, and Start_Position string
	
	If ((Have_WPE_Lastfile) .AND. (.NOT. Have_CLI_Start_Position)) then
		Call Get_Start_Position
C	Else
C		Have_TPU_Start_Position comes from Get_Command_Line_Data and
C   		is always false.
	End If
	
	
C Get (in WPE_Lastfile) a fully-qualified filename for the file to  edit.
	
	If (Have_Input_File_Name) then
		Call Strip_Version_Number 
	1		(Input_File_Name, Input_File_Name_Length)
		WPE_Lastfile = Input_File_Name
		WPE_Lastfile_Length = Input_File_Name_Length
C 			The following is OPTIONAL - editors usually work on
C   			the latest file version.  If we wish to handle 
C   			specific versions, comment-out the next line.
		Have_WPE_Lastfile = .TRUE.
	Else
		If (Have_WPE_Lastfile) then
C 				This one is NOT optional!
			Call Strip_Version_Number 
	1			(WPE_Lastfile, WPE_Lastfile_Length)
		Else
			Call Lib$Get_Input (WPE_Lastfile, 'File: ',
	1			WPE_Lastfile_Length)
C 				This one IS optional!
			Call Str$Trim (WPE_Lastfile, 
	1			WPE_Lastfile, WPE_Lastfile_Length)
			If (WPE_Lastfile_Length .GT. 0) then
C 				This one IS optional!
			    Call Strip_Version_Number 
	1			(WPE_Lastfile, WPE_Lastfile_Length)
			    Have_WPE_Lastfile = .TRUE.
			    Input_File_Name = WPE_Lastfile
			    Input_File_Name_Length = WPE_Lastfile_Length 
			    Have_Input_File_Name = .TRUE.
			Else
			    WPE_Lastfile = ' '
			    WPE_Lastfile_Length = 0
			    Have_WPE_Lastfile = .FALSE.
			End If
		End If
	End If
	
	If (Have_WPE_Lastfile) then
		Zero = 0
		FF_Stat = Lib$Find_File (WPE_Lastfile(:WPE_Lastfile_Length), 
	1			WPE_Lastfile, Zero)
	
		If ((FF_Stat .EQ. RMS$_FNM) .OR.
	1	    (FF_Stat .EQ. RMS$_SYN))	then	! Bad file spec
			    WPE_Lastfile = ' '
			    WPE_Lastfile_Length = 0
			    Have_WPE_Lastfile = .FALSE.
		Else
			Call Str$Trim 
	1		   (WPE_Lastfile, WPE_Lastfile, WPE_Lastfile_Length)
		End If	
	End If
	
C The file we want to edit is now named in WPE_Lastfile
	
C If there was no /RECOVER switch on the command line, then we need to check
C   if there is an appropriate file from which to automatically recover.
	
	If (.NOT. Have_Recover) then
		Call Get_Recovery_Possibility
	Else
		Need_Recover_Qualifier = .FALSE.
	End If
	
	
C We have all we need from the command line and symbols.  
	
C ---------------------------------------------------------------------------
C Now, we're ready to construct a command line to send to TPU
C ---------------------------------------------------------------------------
	
	If ((.NOT.Have_CLI_Start_Position) .AND.
	1   (     Have_TPU_Start_Position)) then
		The_Line 
	1	(The_Line_Length+1:The_Line_Length+Start_Position_Length) =
	2    		Start_Position
		The_Line_Length = The_Line_Length + Start_Position_Length
	End If
	
	If (Need_Recover_Qualifier) then
		The_Line (The_Line_Length+1:The_Line_Length+8) = '/RECOVER'
		The_Line_Length = The_Line_Length + 8
	End If
	
	If (Have_Input_File_Name) then
	    	The_Line = 'TPU '// Input_File_Name(:Input_File_Name_Length) //
	1	   The_Line
		The_Line_Length = The_Line_Length + 4 + Input_File_Name_Length
	Else
	    	The_Line = 'TPU '// WPE_Lastfile(:WPE_Lastfile_Length) //
	1	   The_Line
		The_Line_Length = The_Line_Length + 4 + WPE_Lastfile_Length
	End If
	
C This is always set to a "real" file name.
	Call Lib$Set_Symbol
	1	    ('WPE_LASTFILE', WPE_Lastfile(:WPE_Lastfile_Length), 2)
	
D	Print *, The_Line (:The_Line_Length)
	
C 		And get on with the editing.
	ISTAT = TPU$TPU (The_Line(:The_Line_Length))
	
	End
	
	
C ---------------------------------------------------------------------------
 	Subroutine Get_Command_Line_Data
C 
	Include 'WPE_Common.Dat'
	Character*5 ST_Value
	Integer*2   ST_Length
	
C -------------------------------------------------------------------------
	
	The_Line = ' '
	Call CLI$Get_Value ('$LINE', The_Line, The_Line_Length)
	
D	Print *, ' The original input line was:'
D	Print *, The_Line (:The_Line_Length)
	
C Take the command out of the line.  The command will end with either with a
C   space or a slash or the end of line.  Note: the command may be any unique
C   subset of "WPEDIT", and is guaranteed to be there.  Thus, space_position
C   is guaranteed to be greater than 0.
	
	Space_Position = Index (The_Line, ' ')
	Slash_Position = Index (The_Line, '/')
	
	If ((Space_Position .LT. Slash_Position) .OR.
	1   (Slash_Position .LE. 0	       )) then
C 			Remove thru the Space
		The_Line = The_Line (Space_Position + 1:)
		The_Line_Length = MAX (The_Line_Length - Space_Position, 0)
	Else	
C 			Leave the Slash
		The_Line = The_Line (Slash_Position:)
		The_Line_Length = The_Line_Length - (Slash_Position -1)
	End If
	
	
C Now, take the file name (if it exists) out of the line.
C   if a file name is present, the line is either:
C   FILE.NAME
C   FILE.NAME/QUAL1	or
C   /QUAL1 FILE.NAME/QUAL2
	
	CLI_Status = CLI$Get_Value 
	1	('FILE_NAME', Input_File_Name, Input_File_Name_Length)
	
	If (CLI_Status .NE. CLI$_ABSENT) then
		Have_Input_File_Name = .TRUE.
		File_Name_Position = 
	1	   Index (The_Line, Input_File_Name (:Input_File_Name_Length))
		If (File_Name_Position .EQ. 1) then
			The_Line = The_Line (Input_File_Name_Length + 1:)
			The_Line_Length = 
	1		   MAX (The_Line_Length - Input_File_Name_Length, 0)
		Else
			The_Line = The_Line (:File_Name_Position - 2)//
	1		   	   The_Line (File_Name_Position + 
	2					Input_File_Name_Length:)
			The_Line_Length = 
	1		   MAX (The_Line_Length - (Input_File_Name_Length + 1),
	2			 0)
		End If
	Else
		Have_Input_File_Name = .FALSE.
		Input_File_Name = ' '
		Input_File_Name_Length = 0
	End If
	
	
C Other information we need is whether there is a /RECOVER switch in
C   the command line.  If it's there, we won't even do the checks for
C   automatic recovery.
	
	CLI_Status = CLI$Present ('RECOVER')
	
	If (CLI_Status .NE. CLI$_ABSENT) then
		Have_Recover = .TRUE.
		If (CLI_Status) then
			Recover = .TRUE.
		Else
			Recover = .FALSE.
		End If
	Else
		Have_Recover = .FALSE.
		Recover = .FALSE.		! Provisionally
	End If
	
C The Other information we need is whether there is a /START_POSITION switch in
C   the command line.  If it's there, we'll use it instead of the value
C   remembered in TPU_POSITION
	
	
C	CLI_Status = CLI$Present ('START_POSITION')
	CLI_Status = CLI$Get_Value ('START_POSITION', ST_Value, ST_Length)
	
	Have_TPU_Start_Position = .FALSE.	! Initially
	If (CLI_Status .NE. CLI$_ABSENT) then
		Have_CLI_Start_Position = .TRUE.
		Start_Position = '/START_POSITION=(' // ST_Value
		Start_Position_Length = 17 + ST_Length
		If (CLI_Status .EQ. CLI$_Comma) then
		    CLI_Status = CLI$Get_Value 
	1	       ('START_POSITION', ST_Value, ST_Length)
		    If (CLI_Status .NE. CLI$_ABSENT) then
		      Start_Position (Start_Position_Length + 1:) = 
	1			','//ST_Value
		      Start_Position_Length = 
	1			Start_Position_Length + ST_Length + 1
		    End If
		End If
		Start_Position (Start_Position_Length + 1:) = ')'
		Start_Position_Length = Start_Position_Length + 1
	Else
		Have_CLI_Start_Position = .FALSE.
	End If
	
	
C ---------
D	Print *, ' The remainder of the command line is:'
D	Print *, The_Line (:The_Line_Length)
	
	Return
	End
	
C ---------------------------------------------------------------------------
 	Subroutine Get_Start_Position
C 
	Include 'WPE_Common.Dat'
	Include	'($LNMDEF)'
	
	Structure /TrnLnm_Item_List/
	  Integer*2 BufLen
	  Integer*2 Code		/LNM$_String/
	  Integer*4 Dst_Address
	  Integer*4 Length_Address
	  Integer*4 End_List		/0/
	End Structure

	Record /TrnLnm_Item_List/ T_ItmLst

C -------------------------------------------------------------------------
	
	
C Get the logical TPU_POSITION, if it's available
	
	T_ItmLst.BufLen			=	LEN(Start_Position)
	T_ItmLst.Dst_Address		=	%LOC(Start_Position)
	T_ItmLst.Length_Address		=	%LOC(Start_Position_Length)
	
	Start_Position = ' '
	Start_Position_Status = SYS$TrnLnm(LNM$M_Case_Blind, 'LNM$FILE_DEV', 
	1		'TPU_POSITION',, T_ItmLst)
	
	If (Start_Position_Status) then
		Have_TPU_Start_Position = .TRUE.
	Else
		Have_TPUStart_Position = .FALSE.
		Call Lib$Set_Logical 
	1		  ('TPU_POSITION', '/START_POSITION=(1,1)')
	End If
	
D	Print *, ' TPU_POSITION = ', Start_Position (:Start_Position_Length)
		
	Return
	End
	
	
C ---------------------------------------------------------------------------
 	Subroutine Get_WPE_Lastfile
C 
	Include 'WPE_Common.Dat'
	
C  Get the symbol WPE_LASTFILE, if it's available
	
	WPE_Lastfile_Status = 
	1    Lib$Get_Symbol ('WPE_LASTFILE', WPE_Lastfile,
	2    WPE_Lastfile_Length)
	
	If (WPE_Lastfile_Status) then
		If (WPE_Lastfile_Length .GT. 0) then
			Have_WPE_Lastfile = .TRUE.
		Else
			Have_WPE_Lastfile = .FALSE.
		End If
	Else
		Have_WPE_Lastfile = .FALSE.
	End If
	
D	Print *, ' WPE_Lastfile is:'
D	Print *, WPE_lastfile (:WPE_lastfile_length)
	
	Return
	End
	
C ---------------------------------------------------------------------------
C Trims the file version number from the file specification
C ---------------------------------------------------------------------------
	Subroutine Strip_Version_Number (Filename, Length)

	Character*(*) Filename
	Integer*2 Length
	
	K = Index (Filename(:Length), ';')
	If (K .GT. 0) then
		Length = K - 1
	End If
	
	Return
	End

	
C ---------------------------------------------------------------------------
C Finds out if there is a correctly-named file with the correct contents to be
C   used for automatic recovery.  This is called only if we need to check for
C   a .TJL file.  When called, WPE_Lastfile contains the name of the file we
C   want to edit, and the variable Input_Filename is free for use.  The sole
C   job of this routine is to set the value of Need_Recover_Qualifier.
C   
C The file name addressed by the .TJL file (in V5.0) is contained at the right
C   end of the first line of the file (and ends the record).  If everything is
C   consistent, including having a file version in both the .TJL file and the
C   name of the file to be edited, an exact match will be found.  For files of
C   the type NAME.EXT, NAME.TJL will be used.  Null file NAMES have journal
C   files TPU.TJL.
C ---------------------------------------------------------------------------
	Subroutine Get_Recovery_Possibility
	
       	Include 'WPE_Common.Dat'
	Character*43 JFile_Name
	Character*85 TFile_Name
	
	Need_Recover_Qualifier = .FALSE.	! Unless everything's OK
	
	File_Name_Pointer = 
	1    Index (WPE_Lastfile (:WPE_Lastfile_Length), ']') + 1
	
	If (File_Name_Pointer .GT. 1) then
	    File_Name_Length = WPE_Lastfile_Length - File_Name_Pointer + 1
	    If (WPE_Lastfile (File_Name_Pointer:File_Name_Pointer) .NE. '.')
	1    then		! There is a name, not just an extension
		JFile_Name = 
	1	    WPE_Lastfile (File_Name_Pointer:WPE_Lastfile_Length)
		JFile_Ext_Pointer = Index (JFile_Name, '.') + 1
		If (JFile_Ext_Pointer .LE. 1) then
			Return
		End If
		JFile_Name (JFile_Ext_Pointer:) = 'TJL'
	    Else	! No file name, thus journal file must be TPU.TJL
		JFile_Name = 'TPU.TJL'
	    End If
	Else
		Return
	End If
	
C Try to open the file.  If it isn't there, we just exit.
	
	Open (Unit=1, File= JFile_Name, Access='SEQUENTIAL', BUFFERCOUNT=1,
	1    RECL=420, STATUS='OLD', ERR=990)
	
	Read (1, 100, End=980, Err=980) Length, TFile_Name
100	Format (Q, <Length - File_Name_Length>X, A)
	
	If (TFile_Name (:File_Name_Length) .EQ.
	1    WPE_Lastfile (File_Name_Pointer:WPE_Lastfile_Length)) then
		Need_Recover_Qualifier = .TRUE.	! Exact Match
	
	End If
	
980	Close (Unit=1)
	
	
990	Continue	! Error on Open
	Return
	End

