!
! This file creates DATATRIEVE structures to read or replace
! the AI1 Corporate Telephone Directory application (and could
! be extended to personal directories as well).
!
! The application also works quite well by itself without ALL-In-1
!
! This file assumes you are going to create a CDD dictionary
! to hold these structures, and that it will be the one named
! on the next line
!
SET DICTIONARY CDD$TOP.CORPORATE

DELETE CORPHONE;
REDEFINE DOMAIN CORPHONE USING CORPHONE_REC ON OA$DATA:CORPHONE.DOM;

DELETE CORPHONE_REC;
REDEFINE RECORD CORPHONE_REC
01 CORPHONE_REC.
!
! This record definition matches (more or less) the All-in-1 corporate
!	telephone directory file.
!
!	B. Z. Lederman
!
! The first field is the only key field.
! AI1 didn't allow duplicates, I do.
!
	10 CKEY PIC X(30).
	10 NAME PIC X(32).
	10 TITLE PIC X(30).
	10 TELEPHONE.
		20 BUSINESS PIC X(20).
		20 PERSONAL PIC X(20).
		20 OTHER PIC X(20).		! carved out of the next field
	10 FILLER PIC X(10).			! wasn't anything here.
	10 ADDRESS.
		20 DEPARTMENT PIC X(20).
		20 COMPANY PIC X(30).		! address lines
		20 MAIL_STOP PIC X(30).
		20 STREET PIC X(30).
		20 CITY PIC X(27).		! shortened to make room for
		20 STATE PIC X(3).		! state seperately here
		20 ZIP PIC X(9).
!
! Extra sub fields for parts of the country. Only needed if you want to
!						do fancy lookups.
		20 SUBZIP REDEFINES ZIP.
			30 ZONE PIC X.
			30 CITY PIC XX.
			30 OFFICE PIC XX.
	10 NODE PIC X(10).			! Network Node
	10 COMMENTS PIC X(60).
;

DELETE DELETE_PHONE;
REDEFINE PROCEDURE DELETE_PHONE
!
! Delete a phone entry. Part of the replacement package for All-in-1
!
! B. Z. Lederman	19-Dec-1985
!
! Find out which entry the user wants.
!
DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
   BEGIN
   PUT_FORM PROMPT = "The entry key starts with?"
   END RETRIEVE USING BEGIN
   LOOKUP = GET_FORM REPLY
   END
   MORE = "Y"
!
! Now look through the entries until the user doesn't want to anymore.
!
! Must strip trailing blanks off of LOOKUP or it may not match.
!
   FOR CORPHONE WITH CKEY STARTING WITH LOOKUP||"" AND MORE = "Y" BEGIN
!
! Show the user this entry.
!
      DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
         BEGIN
         PUT_FORM CKEY       = CKEY
         PUT_FORM NAME       = NAME
         PUT_FORM TITLE      = TITLE
         PUT_FORM BUSINESS   = BUSINESS
         PUT_FORM PERSONAL   = PERSONAL
         PUT_FORM OTHER      = OTHER
         PUT_FORM DEPARTMENT = DEPARTMENT
         PUT_FORM COMPANY    = COMPANY
         PUT_FORM MAIL_STOP  = MAIL_STOP
         PUT_FORM STREET     = STREET
         PUT_FORM CITY       = CITY
         PUT_FORM STATE      = STATE
         PUT_FORM ZIP        = ZIP
         PUT_FORM NODE       = NODE
         PUT_FORM COMMENTS   = COMMENTS
         PUT_FORM PROMPT     = "Delete this entry [Y/N] ?"
      END RETRIEVE USING BEGIN
!
! If this is the correct entry, delete it. Default is no delete.
!
         ANSWER = GET_FORM REPLY
         IF ANSWER = "Y" THEN ERASE
      END
!
! Now find out if the user wants to go to the next entry.
!
      DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
	BEGIN
        PUT_FORM PROMPT = "Go to next entry [Y/N] ?"
        END RETRIEVE USING BEGIN
        MORE = GET_FORM REPLY
        END
!
! Default here is to continue with the next entry
!
      IF MORE = "" MORE = "Y"
   END
END-PROCEDURE

DELETE MENU_PHONE;
REDEFINE PROCEDURE MENU_PHONE
!
! Main menu for corporate phone access.
! Replaces All-In-1, reads the same data file.
!
! B. Z. Lederman	19-Dec-1985
!
READY CDD$TOP.CORPORATE.CORPHONE SHARED WRITE
SET FORM
!
! Need some variables for answers.
!
DECLARE MORE PIC X.
MORE = "Y"
DECLARE ANSWER PIC X.
ANSWER = "Y"
DECLARE LOOKUP PIC X(32).
!
! Repeat the following until the user decides to Quit.
!
! One big BEGIN-END means that startup is a little slow as everything
!	is parsed and compiled, but once started it goes fast.
!
WHILE MORE NE "Q" BEGIN
!
! Give the user a choice of actions.
!
	DISPLAY_FORM MENUPHONE IN OA$DATA:CORPHONE.FLB RETRIEVE USING
		BEGIN
		MORE = GET_FORM FMORE
		END
!
! Perform the chosen action
!
	IF MORE EQ "A" BEGIN
		:CDD$TOP.CORPORATE.STORE_PHONE
	END
!
	IF MORE EQ "D" BEGIN
		:CDD$TOP.CORPORATE.DELETE_PHONE
	END
!
	IF MORE EQ "L" BEGIN
		:CDD$TOP.CORPORATE.SHOW_PHONE
	END
!
	IF MORE EQ "M" BEGIN
		:CDD$TOP.CORPORATE.MODIFY_PHONE
	END
!
! If the users don't enter one of the above valid choices, they
!	will simply be prompted again.
END
!
! All done, clean-up before leaving.
!
FINISH CORPHONE
RELEASE ANSWER
RELEASE MORE
RELEASE LOOKUP
END-PROCEDURE

DELETE MODIFY_PHONE;
REDEFINE PROCEDURE MODIFY_PHONE
!
! Modify an existing phone entry. Part of the package replacing All-in-1
!
! B. Z. Lederman	19-Dec-1985
!
ANSWER = "Y"
!
! Do until the user wants to quit.
!
WHILE ANSWER CONTAINING "Y", "y" BEGIN
!
! Find out what entries are wanted.
!
   DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
      BEGIN
      PUT_FORM PROMPT = "The entry key starts with?"
      END RETRIEVE USING BEGIN
      LOOKUP = GET_FORM REPLY
      END
   MORE = "Y"
!
! For each set of entries...
!
! (with trailing blanks stripped off of LOOKUP or it might not match.)
!
   FOR CORPHONE WITH CKEY STARTING WITH LOOKUP||"" AND MORE = "Y"
		MODIFY USING BEGIN
      DISPLAY_FORM MODPHONE IN OA$DATA:CORPHONE.FLB USING
!
! Fill in the form with the existing data.
!
      BEGIN
         PUT_FORM CKEY       = CKEY
         PUT_FORM NAME       = NAME
         PUT_FORM TITLE      = TITLE
         PUT_FORM BUSINESS   = BUSINESS
         PUT_FORM PERSONAL   = PERSONAL
         PUT_FORM OTHER      = OTHER
         PUT_FORM DEPARTMENT = DEPARTMENT
         PUT_FORM COMPANY    = COMPANY
         PUT_FORM MAIL_STOP  = MAIL_STOP
         PUT_FORM STREET     = STREET
         PUT_FORM CITY       = CITY
         PUT_FORM STATE      = STATE
         PUT_FORM ZIP        = ZIP
         PUT_FORM NODE       = NODE
         PUT_FORM COMMENTS   = COMMENTS
         PUT_FORM PROMPT     = "Go on to next entry [Y/N] ?"
      END RETRIEVE USING BEGIN
!
! Pull back the modified data.
!
         NAME       = GET_FORM NAME
         TITLE      = GET_FORM TITLE
         BUSINESS   = GET_FORM BUSINESS
         PERSONAL   = GET_FORM PERSONAL
         OTHER      = GET_FORM OTHER
         DEPARTMENT = GET_FORM DEPARTMENT
         COMPANY    = GET_FORM COMPANY
         MAIL_STOP  = GET_FORM MAIL_STOP
         STREET     = GET_FORM STREET
         CITY       = GET_FORM CITY
         STATE      = GET_FORM STATE
         ZIP        = GET_FORM ZIP
         NODE       = GET_FORM NODE
         COMMENTS   = GET_FORM COMMENTS
         MORE       = GET_FORM REPLY
!
! The default is to continue with next entry.
!
         IF MORE = "" MORE = "Y"
      END
   END
!
! See if another entry is wanted.
!
   DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
   BEGIN
   PUT_FORM PROMPT = "Modify another entry [Y/N] ?"
   END RETRIEVE USING BEGIN
   ANSWER = GET_FORM REPLY
   END
END
END-PROCEDURE

DELETE SHOW_PHONE;
REDEFINE PROCEDURE SHOW_PHONE
!
! Display a set of telephone entries. Part of the package replacing
! All-in-1 telephone book.
!
! Bart Z. Lederman	19-Dec-1985
!
ANSWER = "Y"
!
! Do this until the user doesn't want to anymore.
!
WHILE ANSWER CONTAINING "Y", "y" BEGIN
!
! Find out what set of entries are wanted.
!
   DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
   BEGIN
   PUT_FORM PROMPT = "The entry key starts with?"
   END RETRIEVE USING BEGIN
   LOOKUP = GET_FORM REPLY
   END
   MORE = "Y"
!
! Repeat for all entries (or until user asks to stop.)
!
! (Strip trailing blanks off of LOOKUP or it may not match.)
!
   FOR CORPHONE WITH CKEY STARTING WITH LOOKUP||"" AND MORE = "Y" BEGIN
      DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
      BEGIN
         PUT_FORM CKEY       = CKEY
         PUT_FORM NAME       = NAME
         PUT_FORM TITLE      = TITLE
         PUT_FORM BUSINESS   = BUSINESS
         PUT_FORM PERSONAL   = PERSONAL
         PUT_FORM OTHER      = OTHER
         PUT_FORM DEPARTMENT = DEPARTMENT
         PUT_FORM COMPANY    = COMPANY
         PUT_FORM MAIL_STOP  = MAIL_STOP
         PUT_FORM STREET     = STREET
         PUT_FORM CITY       = CITY
         PUT_FORM STATE      = STATE
         PUT_FORM ZIP        = ZIP
         PUT_FORM NODE       = NODE
         PUT_FORM COMMENTS   = COMMENTS
         PUT_FORM PROMPT     = "Continue with the next entry [Y/N] ?"
      END RETRIEVE USING BEGIN
         MORE = GET_FORM REPLY
!
! Default is to continue with next entry.
!
         IF MORE = "" MORE = "Y"
      END
   END
!
! Find out if another set of entries is desired.
!
   DISPLAY_FORM SHOWPHONE IN OA$DATA:CORPHONE.FLB USING
   BEGIN
   PUT_FORM PROMPT = "Look up another set of entries [Y/N] ?"
   END RETRIEVE USING BEGIN
   ANSWER = GET_FORM REPLY
   END
END
END-PROCEDURE

DELETE STORE_PHONE;
REDEFINE PROCEDURE STORE_PHONE
!
! Procedure to store a new record in the phone directory.
!
! Part of the replacement package for All-in-1 phone directory.
!
! B. Z. Lederman	19-Dec-1985
!
MORE = "Y"
!
! Do the following until the user doesn't want to anymore.
!
WHILE MORE = "Y" BEGIN
	STORE CORPHONE USING DISPLAY_FORM STOREPHONE IN
		OA$DATA:CORPHONE.FLB USING BEGIN
!
! Fill the prompt here so we get everything on one screen.
!
                 PUT_FORM PROMPT = "Add another [Y/N] ?"
!
! Now get the data.
!
             END RETRIEVE USING BEGIN
                 CKEY       = GET_FORM CKEY
	         NAME       = GET_FORM NAME
	         TITLE      = GET_FORM TITLE
	         BUSINESS   = GET_FORM BUSINESS
	         PERSONAL   = GET_FORM PERSONAL
	         OTHER      = GET_FORM OTHER
	         DEPARTMENT = GET_FORM DEPARTMENT
	         COMPANY    = GET_FORM COMPANY
	         MAIL_STOP  = GET_FORM MAIL_STOP
	         STREET     = GET_FORM STREET
	         CITY       = GET_FORM CITY
	         STATE      = GET_FORM STATE
	         ZIP        = GET_FORM ZIP
	         NODE       = GET_FORM NODE
	         COMMENTS   = GET_FORM COMMENTS
                 MORE       = GET_FORM REPLY
	      END
!
! The default here is NOT to do another.
!
	IF MORE = "" MORE = "N"
END
END-PROCEDURE

