C	Functions to compute the number of weekdays and business days.
C
C	Joseph Mei, Harris Trust and Savings Bank, Chicago Il.
C
C	Presented at the Spring 1988 Wombat Magic Session
C	See the Combined newsletter for August 1988, page DTR-11
C
	integer*4 function elapsed_weekdays(start_date, end_date)
	integer*4 start_date(2), end_date(2), elapsed_time(2), zero(2)
	data zero /0,0/
	integer*4 adjustment(7,7)
	data adjustment /0, 0, 0, 0, 0, 0, 0,
	2		 1, 1, 1, 1, 1, 0, 0,
	2		 2, 2, 2, 2, 1, 0, 1,
	2		 3, 3, 3, 2, 1, 1, 2,
	2		 4, 4, 3, 2, 2, 2, 3,
	2		 5, 4, 3, 3, 3, 3, 4,
	2		 5, 4, 4, 4, 4, 4, 5/
	integer*4 status, day_of_week, sys$numtim, lib$day_of_week
	integer*4 elapsed_days(7)
C
C	Subtract start date from end date
C
	status = lib$subx(end_date, start_date, elapsed_time)
	if (.not. status) call lib$signal(%val(status))
	if (.not. (btest (elapsed_time(2), 31)))
	2 status = lib$subx(zero, elapsed_time, elapsed_time)
C
C	Determine number of elapsed days
C
	if (elapsed_time(1) .eq. 0 .and. elapsed_time(2) .eq. 0) then
		elapsed_days(3) = 0
		goto 10
	endif
	status = sys$numtim(elapsed_days, elapsed_time)
	if (.not. status) call lib$signal(%val(status))
C
C	Determine the day of week for start_date
C
10	status = lib$day_of_week(start_date, day_of_week)
	if (.not. status) call lib$signal(%val(status))
C
C	Compute the elapsed weekdays
C
	elapsed_weekdays = elapsed_days(3) / 7 * 5 +
	2 adjustment(day_of_week, imod(elapsed_days(3), 7) + 1)
	return
	end
C*
	integer*4 function elapsed_businessdays(start_date, end_date)
	integer*4 start_date(2), end_date(2), holiday(2)
	integer*4 status, elapsed_business_days, elapsed_weekdays,
	1 day_of_week, zero_to_start_date, zero_to_end_date,
	1 zero_to_holiday, lib$day, lib$day_of_week
	open (unit = 11, file='sys$tools:bank_holiday.dat', status='old',
	1 shared, readonly, form='unformatted')
5	elapsed_business_days = elapsed_weekdays(start_date, end_date)
	status = lib$day(zero_to_start_date, start_date)
	if (.not. status) call lib$signal(%val(status))
	status = lib$day(zero_to_end_date, end_date)
	if (.not. status) call lib$signal(%val(status))
10	read(11, end=100) holiday
	status = lib$day(zero_to_holiday, holiday)
	if (.not. status) call lib$signal(%val(status))
	status = lib$day_of_week(holiday, day_of_week)
	if (.not. status) call lib$signal(%val(status))
	if (day_of_week .ge. 6) goto 10
	if (zero_to_holiday .ge. zero_to_start_date) .and.
	1   zero_to_holiday .lt. zero_to_end_date)
	1	elapsed_business_days = elapsed_business_days - 1
	goto 10
100	elapsed_businessdays = elapsed_business_days
	close(11)
	return
	end
