$!************************************************************
$! This procedure takes a CDD record definition and builds a
$! FMS forms language descriptor file to be passed to the FMS
$! translateor utility.  It is used in conjunction with / called
$! by a command ilfe :CDDTOFMS.COM
$!
$! here are several restrictions:
$!  - Levels, i.e. 01, 02, must contain that 0
$!  - The letter combination "PIC" and "USAGE" must not appear
$!    anywhere ( primarily in your field names ) except the
$!    normal PIC and USAGE statement.
$!  - Field size must look like this PIC X(01) , i.e. two digits always !!
$!    The parentheses are a must !!
$!
$! From Raymond Ferrara, Wombat Magic Spring 1988
$! see the combined newsletter August 1988 page DTR-15
$!**************************************************************
$ WRITE SYS$OUTPUT ""
$ INQUIRE P1 "Entire full CDD dictionary name"
$ INQUIRE P2 "Form library name"
$LOOP:
$ INQUIRE P3 "CDD record name"
$ INQUIRE P4 "Form name"
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT "Working..."
$ WRITE SYS$OUTPUT " "
$ OPEN/WRITE TDEF TDEF.COM
$ WT :== WRITE TDEF
$ WT "$ DEFINE/USER SYS$OUTPUT TOUT.TXT"
$ WT "$ DEFINE/USER CDD$DEFAULT ''P1'"         ! location of record
$ WT "$ RUN SYS$SYSTEM:DTR32"
$ WT "EXTRACT ''P3' ON INPCDDDEF.TXT"
$ WT "EXIT"
$ WT "$ DEFINE/USER FORM$FILE ''P4'.FLG"
$! WT "$ DEFINE/USER CDD$DEFAULT CDD$TOP.wombat" ! location of GENERATE
$ WT "$ DEFINE/USER CDD$DEFAULT CDD$TOP.DTR$USERS.LEDERMAN" ! location of GENERATE
$ WT "$ DEFINE/USER SYS$OUTPUT TOUT.TXT"
$ WT "$ RUN SYS$SYSTEM:DTR32"
$ WT "PRINT ""Defining form"" ON TT:"
$ WT ":GENERATE"
$ WT "''P4'"
$ WT "EXIT"
$ WT "$EXIT"
$ CLOSE TDEF
$ @TDEF
$ WRITE SYS$OUTPUT "Translating form"
$ FMS/TRANS 'P4
$ OPEN/READ/SHARE=READ/ERROR=CREATE_IT TESTFLB 'P2.FLB
$ CLOSE TESTFLP
$ WRITE SYS$OUTPUT "Inserting form into library"
$ FMS/LIBRARY/REPLACE 'P2/FORM='P4 'P4
$ GOTO SKIP_CREATE
$CREATE_IT:
$ WRITE SYS$OUTPUT "Building form library"
$ FMS/LIBRARY/CREATE 'P2/FORM='P4 'P4
$SKIP_CREATE:
$ DELETE/NOLOG TDEF.COM;*
$ DELETE/NOLOG TOUT.TXT;*
$ DELETE/NOLOG INPCDDDEF.TXT;*
$!! DELETE/NOLOG 'P4.FLG;*
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT "Done! ''P4'.FRM saved, also inserted into library."
$ WRITE SYS$OUTPUT " '
$ INQUIRE ANS "More forms to generate for this node & Library <Y or N> "
$ WRITE SYS$OUTPUT ""
$ IF "''ANS'" .NES. "N" THEN GOTO LOOP
$ EXIT
