DELETE LINREG;
REDEFINE PLOT LINREG
!
!This plotting routine is based upon the DEC distributed code for
!the plot X_Y.  In this implementation a regression line is plotted
!automatically and the regression coefficients are displayed.
!
!	Written by Donald E. Stern, Jr.  -   February 3, 1984
!
DECLARE X_AXIS, Y_AXIS, X_LENGTH, Y_LENGTH, X_MAX, X_MIN, Y_MIN, Y_MAX
DECLARE X_POS, Y_POS, I
DECLARE VECTOR XS, YS
DECLARE REAL	SUM_X, SUM_Y, SUM_X_Y, SUM_X_SQ, SUM_Y_SQ, R_SQ, R,
		SP_XY, SP_X, SP_Y, N, MEAN, SLOPE, INTERCEPT
ENTRY 0 (X_LABEL : STRING, Y_LABEL : STRING)
    BEGIN
	PLOT HOUSEKEEP 0
	SET_SEGMENT 2
	X_AXIS = 100
	Y_AXIS = 360
	X_LENGTH = 600
	Y_LENGTH = 350
	PLOT LABEL 0 (X_AXIS, Y_AXIS, X_LENGTH, Y_LENGTH, X_LABEL, Y_LABEL)
	SUM_X = 0
	SUM_Y = 0
	SUM_X_SQ = 0
	SUM_Y_SQ = 0
	SUM_X_Y = 0
    END
ENTRY 1 (X : REAL : "horizontal coordinate", Y : REAL : "vertical coordinate")
	BEGIN
	XS (SIZE (XS) + 1 ) = X
	YS (SIZE (YS) + 1 ) = Y
		SUM_X = SUM_X + X
		SUM_Y = SUM_Y + Y
		SUM_X_SQ = SUM_X_SQ + X**2
		SUM_Y_SQ = SUM_Y_SQ + Y**2
		SUM_X_Y = SUM_X_Y + X * Y
    END
! Print scatter plot
ENTRY 2
    BEGIN
	N = SIZE (XS)
	MEAN = SUM_X / N
	SLOPE = (SUM_X_Y - MEAN * SUM_Y) / (SUM_X_SQ - MEAN * SUM_X)
	INTERCEPT = (SUM_Y - SLOPE * SUM_X) / N
	SP_XY = SUM_X_Y - (SUM_X * SUM_Y)/N
	SP_X  = SUM_X_SQ - (SUM_X * SUM_X / N)
	SP_Y  = SUM_Y_SQ - (SUM_Y * SUM_Y / N)
	R_SQ  = (SP_XY * SP_XY)/(SP_X * SP_Y)
	R = SQRT(R_SQ)
!
	X_MIN = MIN (XS)
	X_MAX = MAX (XS)
	Y_MAX = MAX (YS)
	Y_MIN = MIN (YS)
	IF Y_MIN > 0
	    THEN Y_MIN = 0
	PLOT LABEL 2 (X_MIN, X_MAX, XS)
	PLOT LABEL 3 (Y_MIN, Y_MAX)
	PLOT LABEL 8 (YS)
	INCR I OVER XS
	    PRINT CENTER (XS(I), YS(I)-9, '+', 9)
!
!Print the regression statistics
	PRINT 'P', LXY(20, 393),
		 'T(s1)', QUOTE('Slope = '),
			'T(s1)', QUOTE( CVT(SLOPE) )
	PRINT  'P', LXY(20, 415),
                 'T(s1)', QUOTE('Intercept = '),
                         'T(s1)', QUOTE( CVT(INTERCEPT) )
	PRINT 'P', LXY(20, 437),
		'T(s1)', QUOTE('Cor. Coef. = '),
		        'T(s1)', QUOTE( CVT(R) )
!
	PLOT LABEL 7
	OUTPUT_SEGMENT 2
	PLOT HOUSEKEEP 2
    END
END_PLOT

