/* "C" DATATRIEVE Access Block 

    This is a preliminary Datatrieve Access Block definition
    for the VAX-Datatrieve call interface using VAX-C.

    Although it works for one program, there is no guarantee that
    it is correct.

    Bart Z. Lederman	05-May-1987 */

/* Constant declarations section */

#define DTR$K_STL_CMD 1
#define DTR$K_STL_PRMPT 2
#define DTR$K_STL_LINE 3
#define DTR$K_STL_MSG 4
#define DTR$K_STL_PGET 5
#define DTR$K_STL_PPUT 6
#define DTR$K_STL_CONT 7
#define DTR$K_STL_UDK 8
#define DTR$K_STL_END_UDK 9

/* Initialization Options */

#define DTR$K_SEMI_COLON_OPT 1
#define DTR$K_UNQUOTED_LIT 16
#define DTR$K_SYNTAX_PROMPT 32
#define DTR$K_IMMED_RETURN 64
#define DTR$K_FORMS_ENABLE 128
#define DTR$K_VERIFY 256
#define DTR$K_CONTEXT_SEARCH 2048
#define DTR$K_HYPHEN_DISABLED 4096
#define DTR$K_MORE_COMMANDS 8192
#define DTR$K_ABORT 16384
#define DTR$K_LOCK_WAIT 32768

/* DTR$DTR call options */

#define DTR$M_OPT_CMD 1
#define DTR$M_OPT_PRMPT 2
#define DTR$M_OPT_LINE 4
#define DTR$M_OPT_MSG 8
#define DTR$M_OPT_PGET 16
#define DTR$M_OPT_PPUT 32
#define DTR$M_OPT_CONT 64
#define DTR$M_OPT_UDK 128
#define DTR$M_OPT_DTR_UDK 256
#define DTR$M_OPT_END_UDK 512
#define DTR$M_OPT_UNWIND 1024
#define DTR$M_OPT_CONTROL_C 2048
#define DTR$M_OPT_STARTUP 4096
#define DTR$M_OPT_FOREIGN 8192
#define DTR$M_OPT_BANNER 16384
#define DTR$M_OPT_REMOVE_CTLC 32768

/* User-defined keyword types */

#define DTR$K_UDK_SET 1
#define DTR$K_UDK_SET_NO 2
#define DTR$K_UDK_SHOW 3
#define DTR$K_UDK_STATEMENT 4
#define DTR$K_UDK_COMMAND 5

/* User-defined keyword token types */

#define DTR$K_TOK_TOKEN 1
#define DTR$K_TOK_PICTURE 2
#define DTR$K_TOK_FILENAME 3
#define DTR$K_TOK_COMMAND 4
#define DTR$K_TOK_TEST_TOKEN 5


/* DTR Status messages */

#define DTR$_SUCCESS 9274723

/* DTR$INFO type constants */

#define DTR$K_INF_TYPE_DOMAIN 1
#define DTR$K_INF_TYPE_COLLECTION 2
#define DTR$K_INF_TYPE_KEYWORD 3
#define DTR$K_INF_TYPE_DIC_NAME 4
#define DTR$K_INF_TYPE_GLV 5
#define DTR$K_INF_TYPE_PLOT 6

/* DTR$LOOKUP info constants */

#define DTR$K_INF_DOM_FLD 9
#define DTR$K_INF_DOM_FORM 10
#define DTR$K_INF_DOM_SHARE 11
#define DTR$K_INF_DOM_ACCESS 12
#define DTR$K_INF_DOM_NAME 13
#define DTR$K_INF_DOM_NEXT_DOM 14
#define DTR$K_INF_DOM_SSC 15
#define DTR$K_INF_FLD_NAME 16
#define DTR$K_INF_FLD_QNAME 17
#define DTR$K_INF_FLD_PICTURE 18
#define DTR$K_INF_FLD_EDIT 19
#define DTR$K_INF_FLD_DTYPE 20
#define DTR$K_INF_FLD_OFFSET 21
#define DTR$K_INF_FLD_LENGTH 22
#define DTR$K_INF_FLD_SCALE 23
#define DTR$K_INF_FLD_CHILD 24
#define DTR$K_INF_FLD_CNT 25
#define DTR$K_INF_FLD_LIST 26
#define DTR$K_INF_FLD_REDEFINES 27
#define DTR$K_INF_FLD_VIRTUAL 28
#define DTR$K_INF_FLD_FILLER 29
#define DTR$K_INF_FLD_MISSING 30
#define DTR$K_INF_COL_CURSOR 1
#define DTR$K_INF_COL_SIZE 2
#define DTR$K_INF_COL_FLD 3
#define DTR$K_INF_COL_DROPPED 4
#define DTR$K_INF_COL_ERASED 5
#define DTR$K_INF_COL_INVISIBLE 6
#define DTR$K_INF_COL_NAME 7
#define DTR$K_INF_COL_NEXT_COL 8
#define DTR$K_INF_GLV_FIRST_DOM 34
#define DTR$K_INF_GLV_FIRST_COL 35
#define DTR$K_INF_GLV_FIRST_SSC 36
#define DTR$K_INF_FRM_NAME 32
#define DTR$K_INF_FRM_LIBRARY 33
#define DTR$K_INF_SSC_NAME 46
#define DTR$K_INF_SSC_SET 47
#define DTR$K_INF_SSC_NEXT 48
#define DTR$K_INF_SET_NAME 49
#define DTR$K_INF_SET_NEXT 50
#define DTR$K_INF_SET_SDP 51
#define DTR$K_INF_SET_SINGULAR 52
#define DTR$K_INF_SDP_NEXT 53
#define DTR$K_INF_SDP_DOMAIN 54
#define DTR$K_INF_SDP_TENANCY 55
#define DTR$K_INF_SDP_INSERT 56
#define DTR$K_INF_SDP_RETAIN 57
#define DTR$K_INF_FLD_QHDR 31
#define DTR$K_INF_HDR_CNT 40
#define DTR$K_INF_HDR_STRING 41
#define DTR$K_INF_GLV_STA_OBJ 37
#define DTR$K_INF_GLV_STA_CNT 38
#define DTR$K_INF_GLV_STA_LINE 39
#define DTR$K_INF_PLO_CNT 42
#define DTR$K_INF_PLO_PAI 43
#define DTR$K_INF_PAI_PROMPT 44
#define DTR$K_INF_PAI_DTYPE 45
#define DTR$K_INF_DOM_REC_LEN 58

/* DTR$LOOKUP answer constants */

#define DTR$K_INF_DOM_ACCESS_READ	1
#define DTR$K_INF_DOM_ACCESS_WRITE	2
#define DTR$K_INF_DOM_ACCESS_MODIFY	3
#define DTR$K_INF_DOM_ACCESS_EXTEND	4
#define DTR$K_INF_DOM_SHARE_EXCLUSIVE	1
#define DTR$K_INF_DOM_SHARE_SHARED	2
#define DTR$K_INF_DOM_SHARE_PROTECT	3


/* DAB (Datatrieve Access Block) definition */

extern struct {

    char	DAB$B_BID;
    char	DAB$B_BLN;
    int		DAB$L_CONDITION;
    int		DAB$A_MSG_BUF;
    short int   DAB$W_MSG_BUF_LEN;
    short int   DAB$W_MSG_LEN;
    int		DAB$A_AUX_BUF;
    short int	DAB$W_AUX_BUF_LEN;
    short int	DAB$W_AUX_LEN;
    short int	DAB$W_IDI;
    short int	DAB$W_STATE;
    int		DAB$L_FLAGS;
    int		DAB$L_OPTIONS;
    short int	DAB$W_REC_LENGTH;
    short int	DAB$W_VERSION;
    short int	DAB$W_LEVEL;
    char	DAB$B_VER_LETTER;
    short int	DAB$W_BASE_LEVEL;
    short int	DAB$W_UDK_INDEX;
    short int	DAB$W_COLUMNS_PAGE;
    short int	DAB$W_TT_CHANNEL;
    char	DAB$REST_OF_DAB[51];	/* fill out to 100 bytes */

} DAB ;

/* Default buffers (if you use your terminal in 132 column mode
    you will want to define your own buffers */

extern	char	MSG_BUFF[80];
extern	char	AUX_BUFF[20];

